/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.arima;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Iterables;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import lombok.Generated;

public final class ArimaModels {
    public static ArimaModel of(double[] ar, double[] delta, double[] ma, double variance, boolean check) {
        Polynomial MA;
        Polynomial AR = ar == null ? Polynomial.ONE : Polynomial.of((double[])ar);
        Polynomial D = delta == null ? Polynomial.ONE : Polynomial.of((double[])delta);
        Polynomial polynomial = MA = ma == null ? Polynomial.ONE : Polynomial.of((double[])ma);
        if (check) {
            if (!SarimaMapping.checkStability((DoubleSeq)AR.coefficients())) {
                throw new IllegalArgumentException("AR");
            }
            if (!SarimaMapping.checkStability((DoubleSeq)MA.coefficients())) {
                throw new IllegalArgumentException("MA");
            }
            if (D.degree() > 0) {
                Complex[] roots = D.roots();
                for (int i = 0; i < roots.length; ++i) {
                    if (!(Math.abs(1.0 - roots[i].absSquare()) > 1.0E-6)) continue;
                    throw new IllegalArgumentException("DELTA");
                }
            }
        }
        return new ArimaModel(new BackFilter(AR), new BackFilter(D), new BackFilter(MA), variance);
    }

    public static ArimaModel sum(ArimaModel[] components) {
        if (components == null || components.length == 0) {
            return null;
        }
        if (components.length == 1) {
            return components[0];
        }
        ArimaModel m = components[0];
        for (int i = 1; i < components.length; ++i) {
            m = m.plus(components[i]);
        }
        return m;
    }

    public static double[] spectrum(ArimaModel m, int n) {
        DoubleUnaryOperator s = m.getSpectrum().asFunction();
        double[] g = new double[n];
        double q = Math.PI / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double w = q * (double)i;
            g[i] = s.applyAsDouble(w);
        }
        return g;
    }

    public static double[] acf(ArimaModel m, int n) {
        AutoCovarianceFunction acf = ((ArimaModel)m.stationaryTransformation().getStationaryModel()).getAutoCovarianceFunction();
        acf.prepare(n);
        double[] g = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            g[i] = acf.get(i);
        }
        return g;
    }

    public static byte[] toBuffer(ArimaModel model) {
        ModellingProtos.ArimaModel.Builder builder = ModellingProtos.ArimaModel.newBuilder().setName("arima").addAllAr(Iterables.of((DoubleSeq)model.getStationaryAr().coefficients())).addAllDelta(Iterables.of((DoubleSeq)model.getNonStationaryAr().coefficients())).addAllMa(Iterables.of((DoubleSeq)model.getMa().coefficients())).setInnovationVariance(model.getInnovationVariance());
        return builder.build().toByteArray();
    }

    @Generated
    private ArimaModels() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

