/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.ssf.univariate.ISsfData;

public class ExtendedSsfData
implements ISsfData {
    private final int nbcasts;
    private final int nfcasts;
    private final ISsfData data;

    public ExtendedSsfData(ISsfData data, int bcasts, int fcasts) {
        this.data = data;
        this.nfcasts = fcasts;
        this.nbcasts = bcasts;
    }

    public double get(int n) {
        if (n < this.nbcasts) {
            return Double.NaN;
        }
        return this.data.get(n - this.nbcasts);
    }

    public int getBackcastsCount() {
        return this.nbcasts;
    }

    public int length() {
        return this.nbcasts + this.nfcasts + this.data.length();
    }

    public int getForecastsCount() {
        return this.nfcasts;
    }

    @Override
    public boolean isMissing(int pos) {
        if (pos < this.nbcasts) {
            return true;
        }
        return this.data.isMissing(pos - this.nbcasts);
    }
}

