/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import jdplus.toolkit.base.api.util.Id;
import lombok.Generated;

public final class Paths {
    public static final String DEMETRA = "Demetra+";
    public static final String DEF_FILE = "demetra";
    public static final String DEF_FOLDER = Path.of(Paths.getDefaultHome(), "Demetra+").toString();

    public static String changeExtension(String file, String next) {
        int ipos;
        for (ipos = file.length() - 1; ipos >= 0 && file.charAt(ipos) != '.' && file.charAt(ipos) != File.separatorChar && file.charAt(ipos) != File.pathSeparatorChar; --ipos) {
        }
        String sfile = null;
        sfile = ipos < 0 || file.charAt(ipos) != '.' ? file : file.substring(0, ipos);
        if (next == null) {
            return sfile;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(sfile);
        builder.append('.');
        builder.append(next);
        return builder.toString();
    }

    public static String addExtension(String file, String ext) {
        StringBuilder builder = new StringBuilder();
        builder.append(file);
        builder.append('.');
        builder.append(ext);
        return builder.toString();
    }

    public static String[] splitFile(String file) {
        int ipos;
        String[] rslt = new String[3];
        for (ipos = file.length() - 1; ipos >= 0 && file.charAt(ipos) != '.' && file.charAt(ipos) != File.separatorChar; --ipos) {
        }
        if (ipos > 0 && file.charAt(ipos) == '.') {
            rslt[2] = file.substring(ipos + 1);
        }
        if (ipos < 0) {
            rslt[1] = file;
            return rslt;
        }
        int epos = ipos--;
        while (ipos >= 0 && file.charAt(ipos) != File.separatorChar) {
            --ipos;
        }
        if (ipos > 0) {
            rslt[0] = file.substring(0, ipos);
            if (ipos + 1 < epos) {
                rslt[1] = file.substring(ipos + 1, epos);
            } else {
                rslt[1] = rslt[2];
                rslt[2] = null;
            }
        } else {
            rslt[1] = file.substring(0, epos);
        }
        return rslt;
    }

    public static String getBaseName(String file) {
        String[] s = Paths.splitFile(file);
        return s[1];
    }

    public static String getFullPath(String file) {
        try {
            File tmp = Path.of(file, new String[0]).toFile();
            return Paths.splitFile(tmp.getCanonicalPath())[0];
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String concatenate(String root, String folder) {
        StringBuilder builder = new StringBuilder();
        if (root != null) {
            builder.append(root);
            if (root.charAt(root.length() - 1) != File.separatorChar && folder != null) {
                builder.append(File.separatorChar);
            }
        }
        if (folder != null) {
            builder.append(folder);
        }
        return builder.toString();
    }

    public static String getDefaultHome() {
        String parent = System.getenv("HOMESHARE");
        if (parent != null) {
            return parent;
        }
        parent = System.getenv("USERPROFILE");
        if (parent != null) {
            return parent;
        }
        return ".";
    }

    private static String fileFromId(Id id) {
        int n = id.getCount();
        switch (n) {
            case 0: {
                return DEF_FILE;
            }
            case 1: {
                return id.get(0);
            }
        }
        String result = Paths.concatenate(id.get(0), id.get(1));
        for (int i = 2; i < n; ++i) {
            result = Paths.concatenate(result, id.get(i));
        }
        return result;
    }

    private static String fileFromId(String folder, Id id) {
        return Paths.concatenate(folder, Paths.fileFromId(id));
    }

    public static String fileFromContext(String folder, Object context) {
        if (context == null) {
            return Paths.folder(folder);
        }
        if (context instanceof Id) {
            Id id = (Id)context;
            return Paths.fileFromId(Paths.folder(folder), (Id)context);
        }
        return Paths.concatenate(Paths.folder(folder), context.toString());
    }

    public static String folderFromContext(String folder, Object context) {
        File Folder;
        String nfolder = Paths.folder(folder);
        if (context != null && context instanceof Id) {
            Id parent = (Id)context;
            for (int i = 0; i < parent.getCount(); ++i) {
                nfolder = Paths.concatenate(nfolder, parent.get(i));
            }
        }
        if (!(Folder = Path.of(nfolder, new String[0]).toFile()).exists()) {
            Folder.mkdirs();
        }
        return nfolder;
    }

    public static File folderFromContext(File folder, Object context) {
        File nfolder = Paths.folder(folder);
        if (context != null && context instanceof Id) {
            Id parent = (Id)context;
            for (int i = 0; i < parent.getCount(); ++i) {
                nfolder = nfolder.toPath().resolve(parent.get(i)).toFile();
            }
        }
        if (!nfolder.exists()) {
            nfolder.mkdirs();
        }
        return nfolder;
    }

    public static String folder(String folder) {
        if (folder == null || folder.length() == 0) {
            return DEF_FOLDER;
        }
        return folder;
    }

    public static File folder(File folder) {
        if (folder == null || !folder.isDirectory()) {
            return Path.of(DEF_FOLDER, new String[0]).toFile();
        }
        return folder;
    }

    @Generated
    private Paths() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

