## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE  # Set to FALSE since these are 'shiny' examples
)

## ----setup--------------------------------------------------------------------
# library(linkeR)
# library(shiny)
# library(leaflet)
# library(DT)

## ----basic-example------------------------------------------------------------
# library(shiny)
# library(leaflet)
# library(DT)
# library(linkeR)
# 
# # Sample data with shared IDs
# sample_data <- data.frame(
#   id = 1:10,
#   name = paste("Location", 1:10),
#   latitude = runif(10, 40.7, 40.8),
#   longitude = runif(10, -111.95, -111.85),
#   value = runif(10, 100, 1000)
# )
# 
# ui <- fluidPage(
#   titlePanel("Basic linkeR Example"),
# 
#   fluidRow(
#     column(6,
#       h4("Map"),
#       leafletOutput("my_map")
#     ),
#     column(6,
#       h4("Table"),
#       DTOutput("my_table")
#     )
#   )
# )
# 
# server <- function(input, output, session) {
# 
#   # Create reactive data
#   my_data <- reactive({ sample_data })
# 
#   # Render components
#   output$my_map <- renderLeaflet({
#     leaflet(my_data()) %>%
#       addTiles() %>%
#       addMarkers(
#         lng = ~longitude,
#         lat = ~latitude,
#         layerId = ~id,  # Critical: this must match your shared_id_column
#         popup = ~paste("Name:", name)
#       )
#   })
# 
#   output$my_table <- renderDT({
#     datatable(
#       my_data()[, c("name", "value")],
#       selection = "single",
#       rownames = FALSE
#     )
#   })
# 
#   # Set up linking - this is all you need!
#   link_plots(
#     session,
#     my_map = my_data,      # component_name = reactive_data
#     my_table = my_data,    # component_name = reactive_data
#     shared_id_column = "id"  # column that links the components
#   )
# }
# 
# shinyApp(ui, server)

