/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.regarima.OrderSpec;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AutoModelSpec
implements Validatable<AutoModelSpec> {
    public static final AutoModelSpec DEFAULT_DISABLED = (AutoModelSpec)AutoModelSpec.builder().build();
    public static final AutoModelSpec DEFAULT_ENABLED = (AutoModelSpec)AutoModelSpec.builder().enabled(true).build();
    public static final double DEF_LJUNGBOX = 0.95;
    public static final double DEF_TSIG = 1.0;
    public static final double DEF_PREDCV = 0.14286;
    public static final double DEF_UBFINAL = 1.05;
    public static final double DEF_UB1 = 1.0309278350515465;
    public static final double DEF_UB2 = 1.1363636363636365;
    public static final double DEF_CANCEL = 0.1;
    public static final double DEF_FCT = 1.0126582278481011;
    public static final boolean DEF_ACCEPTDEF = false;
    public static final boolean DEF_MIXED = true;
    public static final boolean DEF_BALANCED = false;
    public static final boolean DEF_HR = false;
    private final boolean enabled;
    private final OrderSpec diff;
    private final OrderSpec order;
    private final boolean acceptDefault;
    private final boolean mixed;
    private final boolean balanced;
    private final boolean hannanRissannen;
    private final double cancel;
    private final double percentRSE;
    private final double ljungBoxLimit;
    private final double predcv;
    private final double ub1;
    private final double ub2;
    private final double ubfinal;
    private final double armaSignificance;

    public static Builder builder() {
        return new Builder().enabled(false).acceptDefault(false).mixed(true).balanced(false).hannanRissannen(false).cancel(0.1).percentRSE(1.0126582278481011).ljungBoxLimit(0.95).predcv(0.14286).armaSignificance(1.0).ub1(1.0309278350515465).ub2(1.1363636363636365).ubfinal(1.05);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_ENABLED);
    }

    public AutoModelSpec validate() throws IllegalArgumentException {
        if (this.armaSignificance < 0.5) {
            throw new IllegalArgumentException("Arma T-value limit must be greater than .5");
        }
        if (this.percentRSE < 1.0) {
            throw new IllegalArgumentException("Must be greater than .5");
        }
        if (this.predcv < 0.05 || this.predcv > 0.3) {
            throw new IllegalArgumentException("Percent reduction of critical value must be in [0.05, .3]");
        }
        if (this.ub1 <= 1.0) {
            throw new IllegalArgumentException("Initial unit root limit must be less than 1");
        }
        if (this.ub2 <= 1.0) {
            throw new IllegalArgumentException("Final unit root limit must be less than 1");
        }
        if (this.cancel < 0.0 || this.cancel > 0.2) {
            throw new IllegalArgumentException("Cancelation limit must be in [0, .2]");
        }
        if (this.ubfinal < 1.0) {
            throw new IllegalArgumentException("Unit root limit must be greater than 1");
        }
        return this;
    }

    @Generated
    AutoModelSpec(boolean enabled, OrderSpec diff, OrderSpec order, boolean acceptDefault, boolean mixed, boolean balanced, boolean hannanRissannen, double cancel, double percentRSE, double ljungBoxLimit, double predcv, double ub1, double ub2, double ubfinal, double armaSignificance) {
        this.enabled = enabled;
        this.diff = diff;
        this.order = order;
        this.acceptDefault = acceptDefault;
        this.mixed = mixed;
        this.balanced = balanced;
        this.hannanRissannen = hannanRissannen;
        this.cancel = cancel;
        this.percentRSE = percentRSE;
        this.ljungBoxLimit = ljungBoxLimit;
        this.predcv = predcv;
        this.ub1 = ub1;
        this.ub2 = ub2;
        this.ubfinal = ubfinal;
        this.armaSignificance = armaSignificance;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().enabled(this.enabled).diff(this.diff).order(this.order).acceptDefault(this.acceptDefault).mixed(this.mixed).balanced(this.balanced).hannanRissannen(this.hannanRissannen).cancel(this.cancel).percentRSE(this.percentRSE).ljungBoxLimit(this.ljungBoxLimit).predcv(this.predcv).ub1(this.ub1).ub2(this.ub2).ubfinal(this.ubfinal).armaSignificance(this.armaSignificance);
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public OrderSpec getDiff() {
        return this.diff;
    }

    @Generated
    public OrderSpec getOrder() {
        return this.order;
    }

    @Generated
    public boolean isAcceptDefault() {
        return this.acceptDefault;
    }

    @Generated
    public boolean isMixed() {
        return this.mixed;
    }

    @Generated
    public boolean isBalanced() {
        return this.balanced;
    }

    @Generated
    public boolean isHannanRissannen() {
        return this.hannanRissannen;
    }

    @Generated
    public double getCancel() {
        return this.cancel;
    }

    @Generated
    public double getPercentRSE() {
        return this.percentRSE;
    }

    @Generated
    public double getLjungBoxLimit() {
        return this.ljungBoxLimit;
    }

    @Generated
    public double getPredcv() {
        return this.predcv;
    }

    @Generated
    public double getUb1() {
        return this.ub1;
    }

    @Generated
    public double getUb2() {
        return this.ub2;
    }

    @Generated
    public double getUbfinal() {
        return this.ubfinal;
    }

    @Generated
    public double getArmaSignificance() {
        return this.armaSignificance;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoModelSpec)) {
            return false;
        }
        AutoModelSpec other = (AutoModelSpec)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isAcceptDefault() != other.isAcceptDefault()) {
            return false;
        }
        if (this.isMixed() != other.isMixed()) {
            return false;
        }
        if (this.isBalanced() != other.isBalanced()) {
            return false;
        }
        if (this.isHannanRissannen() != other.isHannanRissannen()) {
            return false;
        }
        if (Double.compare(this.getCancel(), other.getCancel()) != 0) {
            return false;
        }
        if (Double.compare(this.getPercentRSE(), other.getPercentRSE()) != 0) {
            return false;
        }
        if (Double.compare(this.getLjungBoxLimit(), other.getLjungBoxLimit()) != 0) {
            return false;
        }
        if (Double.compare(this.getPredcv(), other.getPredcv()) != 0) {
            return false;
        }
        if (Double.compare(this.getUb1(), other.getUb1()) != 0) {
            return false;
        }
        if (Double.compare(this.getUb2(), other.getUb2()) != 0) {
            return false;
        }
        if (Double.compare(this.getUbfinal(), other.getUbfinal()) != 0) {
            return false;
        }
        if (Double.compare(this.getArmaSignificance(), other.getArmaSignificance()) != 0) {
            return false;
        }
        OrderSpec this$diff = this.getDiff();
        OrderSpec other$diff = other.getDiff();
        if (this$diff == null ? other$diff != null : !((Object)this$diff).equals(other$diff)) {
            return false;
        }
        OrderSpec this$order = this.getOrder();
        OrderSpec other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !((Object)this$order).equals(other$order));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isAcceptDefault() ? 79 : 97);
        result = result * 59 + (this.isMixed() ? 79 : 97);
        result = result * 59 + (this.isBalanced() ? 79 : 97);
        result = result * 59 + (this.isHannanRissannen() ? 79 : 97);
        long $cancel = Double.doubleToLongBits(this.getCancel());
        result = result * 59 + (int)($cancel >>> 32 ^ $cancel);
        long $percentRSE = Double.doubleToLongBits(this.getPercentRSE());
        result = result * 59 + (int)($percentRSE >>> 32 ^ $percentRSE);
        long $ljungBoxLimit = Double.doubleToLongBits(this.getLjungBoxLimit());
        result = result * 59 + (int)($ljungBoxLimit >>> 32 ^ $ljungBoxLimit);
        long $predcv = Double.doubleToLongBits(this.getPredcv());
        result = result * 59 + (int)($predcv >>> 32 ^ $predcv);
        long $ub1 = Double.doubleToLongBits(this.getUb1());
        result = result * 59 + (int)($ub1 >>> 32 ^ $ub1);
        long $ub2 = Double.doubleToLongBits(this.getUb2());
        result = result * 59 + (int)($ub2 >>> 32 ^ $ub2);
        long $ubfinal = Double.doubleToLongBits(this.getUbfinal());
        result = result * 59 + (int)($ubfinal >>> 32 ^ $ubfinal);
        long $armaSignificance = Double.doubleToLongBits(this.getArmaSignificance());
        result = result * 59 + (int)($armaSignificance >>> 32 ^ $armaSignificance);
        OrderSpec $diff = this.getDiff();
        result = result * 59 + ($diff == null ? 43 : ((Object)$diff).hashCode());
        OrderSpec $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "AutoModelSpec(enabled=" + this.isEnabled() + ", diff=" + String.valueOf(this.getDiff()) + ", order=" + String.valueOf(this.getOrder()) + ", acceptDefault=" + this.isAcceptDefault() + ", mixed=" + this.isMixed() + ", balanced=" + this.isBalanced() + ", hannanRissannen=" + this.isHannanRissannen() + ", cancel=" + this.getCancel() + ", percentRSE=" + this.getPercentRSE() + ", ljungBoxLimit=" + this.getLjungBoxLimit() + ", predcv=" + this.getPredcv() + ", ub1=" + this.getUb1() + ", ub2=" + this.getUb2() + ", ubfinal=" + this.getUbfinal() + ", armaSignificance=" + this.getArmaSignificance() + ")";
    }

    public static class Builder
    implements Validatable.Builder<AutoModelSpec> {
        @Generated
        private boolean enabled;
        @Generated
        private OrderSpec diff;
        @Generated
        private OrderSpec order;
        @Generated
        private boolean acceptDefault;
        @Generated
        private boolean mixed;
        @Generated
        private boolean balanced;
        @Generated
        private boolean hannanRissannen;
        @Generated
        private double cancel;
        @Generated
        private double percentRSE;
        @Generated
        private double ljungBoxLimit;
        @Generated
        private double predcv;
        @Generated
        private double ub1;
        @Generated
        private double ub2;
        @Generated
        private double ubfinal;
        @Generated
        private double armaSignificance;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public @NonNull Builder diff(OrderSpec diff) {
            this.diff = diff;
            return this;
        }

        @Generated
        public @NonNull Builder order(OrderSpec order) {
            this.order = order;
            return this;
        }

        @Generated
        public @NonNull Builder acceptDefault(boolean acceptDefault) {
            this.acceptDefault = acceptDefault;
            return this;
        }

        @Generated
        public @NonNull Builder mixed(boolean mixed) {
            this.mixed = mixed;
            return this;
        }

        @Generated
        public @NonNull Builder balanced(boolean balanced) {
            this.balanced = balanced;
            return this;
        }

        @Generated
        public @NonNull Builder hannanRissannen(boolean hannanRissannen) {
            this.hannanRissannen = hannanRissannen;
            return this;
        }

        @Generated
        public @NonNull Builder cancel(double cancel) {
            this.cancel = cancel;
            return this;
        }

        @Generated
        public @NonNull Builder percentRSE(double percentRSE) {
            this.percentRSE = percentRSE;
            return this;
        }

        @Generated
        public @NonNull Builder ljungBoxLimit(double ljungBoxLimit) {
            this.ljungBoxLimit = ljungBoxLimit;
            return this;
        }

        @Generated
        public @NonNull Builder predcv(double predcv) {
            this.predcv = predcv;
            return this;
        }

        @Generated
        public @NonNull Builder ub1(double ub1) {
            this.ub1 = ub1;
            return this;
        }

        @Generated
        public @NonNull Builder ub2(double ub2) {
            this.ub2 = ub2;
            return this;
        }

        @Generated
        public @NonNull Builder ubfinal(double ubfinal) {
            this.ubfinal = ubfinal;
            return this;
        }

        @Generated
        public @NonNull Builder armaSignificance(double armaSignificance) {
            this.armaSignificance = armaSignificance;
            return this;
        }

        @Generated
        public @NonNull AutoModelSpec buildWithoutValidation() {
            return new AutoModelSpec(this.enabled, this.diff, this.order, this.acceptDefault, this.mixed, this.balanced, this.hannanRissannen, this.cancel, this.percentRSE, this.ljungBoxLimit, this.predcv, this.ub1, this.ub2, this.ubfinal, this.armaSignificance);
        }

        @Generated
        public @NonNull String toString() {
            return "AutoModelSpec.Builder(enabled=" + this.enabled + ", diff=" + String.valueOf(this.diff) + ", order=" + String.valueOf(this.order) + ", acceptDefault=" + this.acceptDefault + ", mixed=" + this.mixed + ", balanced=" + this.balanced + ", hannanRissannen=" + this.hannanRissannen + ", cancel=" + this.cancel + ", percentRSE=" + this.percentRSE + ", ljungBoxLimit=" + this.ljungBoxLimit + ", predcv=" + this.predcv + ", ub1=" + this.ub1 + ", ub2=" + this.ub2 + ", ubfinal=" + this.ubfinal + ", armaSignificance=" + this.armaSignificance + ")";
        }
    }
}

