## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
library(lifepack)

## ----example------------------------------------------------------------------



Lambda <- function(x) {

  A <- matrix(0, 3, 3)
  

  A[1, 2] <- (0.0004 + 10^(4.54 + 0.06*(x+30)-10))*ifelse(x <= 35, 1, 0)
  A[1,3]  <- A[1,2]
  A[2,1] <- 2.0058 * exp(-0.117*(x+30)) * ifelse(x <= 35,1,0)
  A[2,3] <- A[1,3]*(1+ifelse(x <= 35,1,0))

  row_sums <- rowSums(A)
  diag(A) <- -row_sums
  
  return(A)
}


R <- function(x, mu) {
  if (x <= 35) {
    return(diag(c(-mu , 400000, 0)))
  } else {
    return(diag(c(400000, 400000,0)))
  }
}

dR <- function(x, mu) {
  if (x <= 35) {
    return(diag(c(-1, 0,0)))
  } else {
    return(diag(c(0,0,0)))
  }
}

rentefun <- function(x) { 0.01 + 0.001 * x }  # Dynamic interest rate


prodint(Lambda, 0,80, 1000)

reserve(0, 80, Lambda, R, mu = 200000, r = 0.01, n = 1000)

sreserve(0,80, Lambda, R, mu=200000, r = rentefun, 1000)
equiv_premium(0, 1, Lambda, R, dR, mu = 0.05, r = 0.03, n = 1000)

