/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class WeightedSsf<S extends ISsf>
implements ISsf {
    private final S ssf_;
    private final double[] w_;

    public WeightedSsf(double[] w, S ssf) {
        this.ssf_ = ssf;
        this.w_ = w;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.ssf_.diffuseConstraints(b);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.ssf_.fullQ(pos, qm.extract(1, qm.getRowsCount(), 1, qm.getColumnsCount()));
    }

    public S getInternalSsf() {
        return this.ssf_;
    }

    @Override
    public int getNonStationaryDim() {
        return this.ssf_.getNonStationaryDim();
    }

    @Override
    public int getStateDim() {
        return this.ssf_.getStateDim();
    }

    @Override
    public int getTransitionResCount() {
        return this.ssf_.getTransitionResCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.ssf_.getTransitionResDim();
    }

    public double[] getWeights() {
        return this.w_;
    }

    @Override
    public boolean hasR() {
        return this.ssf_.hasR();
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return this.ssf_.hasTransitionRes(pos);
    }

    @Override
    public boolean hasW() {
        return this.ssf_.hasW();
    }

    @Override
    public boolean isDiffuse() {
        return this.ssf_.isDiffuse();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return this.ssf_.isTransitionResidualTimeInvariant();
    }

    @Override
    public boolean isValid() {
        return this.ssf_.isValid();
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        DataBlock kc = k.deepClone();
        double w = this.weight(pos);
        kc.mul(w);
        this.ssf_.L(pos, kc, lm);
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.ssf_.Pf0(pf0);
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.ssf_.Pi0(pi0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        this.ssf_.Q(pos, qm);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        if (this.ssf_.hasR()) {
            this.ssf_.R(pos, rv);
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.ssf_.T(pos, tr);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        this.ssf_.TVT(pos, vm);
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        double w = this.weight(pos);
        this.ssf_.VpZdZ(pos, vm, w * w * d);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        this.ssf_.W(pos, wv);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        double w = this.weight(pos);
        this.ssf_.XpZd(pos, x, w * d);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        this.ssf_.XT(pos, x);
    }

    @Override
    public void Z(int pos, DataBlock z) {
        this.ssf_.Z(pos, z);
        z.mul(this.weight(pos));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        double w = this.weight(pos);
        DataBlockIterator c = m.columns();
        DataBlock col = c.getData();
        do {
            x.set(c.getPosition(), w * this.ssf_.ZX(pos, col));
        } while (c.next());
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double w = this.weight(pos);
        return w * w * this.ssf_.ZVZ(pos, vm);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return this.mweight(pos, this.ssf_.ZX(pos, x));
    }

    private double mweight(int pos, double m) {
        return this.w_ == null ? m : this.w_[pos] * m;
    }

    private double weight(int pos) {
        return this.w_ == null ? 1.0 : this.w_[pos];
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.ssf_.TX(pos, x);
    }
}

