/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.github.javacliparser.IntOption;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;
import moa.evaluation.BasicClassificationPerformanceEvaluator;

public class WindowClassificationPerformanceEvaluator
extends BasicClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window", 1000);

    @Override
    protected BasicClassificationPerformanceEvaluator.Estimator newEstimator() {
        return new WindowEstimator(this.widthOption.getValue());
    }

    @Override
    public ImmutableCapabilities defineImmutableCapabilities() {
        if (this.getClass() == WindowClassificationPerformanceEvaluator.class) {
            return new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
        }
        return new ImmutableCapabilities(Capability.VIEW_STANDARD);
    }

    public class WindowEstimator
    implements BasicClassificationPerformanceEvaluator.Estimator {
        protected double[] window;
        protected int posWindow;
        protected int lenWindow;
        protected int SizeWindow;
        protected double sum;
        protected double qtyNaNs;

        public WindowEstimator(int sizeWindow) {
            this.window = new double[sizeWindow];
            this.SizeWindow = sizeWindow;
            this.posWindow = 0;
            this.lenWindow = 0;
        }

        @Override
        public void add(double value) {
            double forget = this.window[this.posWindow];
            if (!Double.isNaN(forget)) {
                this.sum -= forget;
            } else {
                this.qtyNaNs -= 1.0;
            }
            if (!Double.isNaN(value)) {
                this.sum += value;
            } else {
                this.qtyNaNs += 1.0;
            }
            this.window[this.posWindow] = value;
            ++this.posWindow;
            if (this.posWindow == this.SizeWindow) {
                this.posWindow = 0;
            }
            if (this.lenWindow < this.SizeWindow) {
                ++this.lenWindow;
            }
        }

        @Override
        public double estimation() {
            return this.sum / ((double)this.lenWindow - this.qtyNaNs);
        }
    }
}

