/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleTranslationTable;
import org.biojava.bio.symbol.Symbol;

public class SimpleReversibleTranslationTable
extends SimpleTranslationTable
implements ReversibleTranslationTable,
Serializable {
    private Map revMap;

    public SimpleReversibleTranslationTable(FiniteAlphabet finiteAlphabet, FiniteAlphabet finiteAlphabet2) throws IllegalAlphabetException {
        super(finiteAlphabet, finiteAlphabet2);
        if (finiteAlphabet.size() != finiteAlphabet2.size()) {
            throw new IllegalAlphabetException("Couldn't create translation table as the alphabets were different sizes: " + finiteAlphabet.size() + ":" + finiteAlphabet.getName() + finiteAlphabet2.size() + ":" + finiteAlphabet2.getName());
        }
        this.revMap = new HashMap();
    }

    public void setTranslation(AtomicSymbol atomicSymbol, AtomicSymbol atomicSymbol2) throws IllegalSymbolException {
        super.setTranslation(atomicSymbol, atomicSymbol2);
        this.revMap.put(atomicSymbol2, atomicSymbol);
    }

    public Symbol untranslate(Symbol symbol) throws IllegalSymbolException {
        Symbol symbol2 = (Symbol)this.revMap.get(symbol);
        if (symbol2 == null) {
            if (symbol2 instanceof AtomicSymbol) {
                this.getTargetAlphabet().validate(symbol);
                throw new IllegalSymbolException("Unable to map " + symbol.getName());
            }
            HashSet<Symbol> hashSet = new HashSet<Symbol>();
            Iterator iterator = ((FiniteAlphabet)symbol2.getMatches()).iterator();
            while (iterator.hasNext()) {
                Symbol symbol3 = (Symbol)iterator.next();
                hashSet.add(this.untranslate(symbol3));
            }
            symbol2 = this.getSourceAlphabet().getAmbiguity(hashSet);
        }
        return symbol2;
    }
}

