/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.CrossProductSymbolNameParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

class InfiniteCrossProductAlphabet
implements Alphabet,
Serializable {
    private final List alphas;
    private char tokenSeed = (char)65;

    InfiniteCrossProductAlphabet(List list) {
        this.alphas = list;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public boolean contains(Symbol symbol) {
        if (!(symbol instanceof AtomicSymbol)) {
            Alphabet alphabet = symbol.getMatches();
            if (alphabet instanceof FiniteAlphabet) {
                Iterator iterator = ((FiniteAlphabet)alphabet).iterator();
                while (iterator.hasNext()) {
                    if (this.contains((Symbol)iterator.next())) continue;
                    return false;
                }
                return true;
            }
            throw new BioError("Problem: Can't work out if I contain ambiguity symbol " + symbol.getName());
        }
        AtomicSymbol atomicSymbol = (AtomicSymbol)symbol;
        List list = atomicSymbol.getSymbols();
        if (list.size() != this.alphas.size()) {
            return false;
        }
        Iterator iterator = this.alphas.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Symbol symbol2;
            Alphabet alphabet = (Alphabet)iterator.next();
            if (alphabet.contains(symbol2 = (Symbol)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public List getAlphabets() {
        return this.alphas;
    }

    public Symbol getAmbiguity(Set set) {
        throw new BioError("Not implemented yet");
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < this.alphas.size()) {
            Alphabet alphabet = (Alphabet)this.alphas.get(n);
            stringBuffer.append(alphabet.getName());
            if (n < this.alphas.size() - 1) {
                stringBuffer.append(" x ");
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public SymbolParser getParser(String string) throws NoSuchElementException, BioException {
        if (string == "name") {
            return new CrossProductSymbolNameParser(this);
        }
        throw new NoSuchElementException("No parser for " + string + " is defined for " + this.getName());
    }

    public Symbol getSymbol(List list) throws IllegalSymbolException {
        if (list.size() != this.alphas.size()) {
            throw new IllegalSymbolException("List of symbols is the wrong length (" + this.alphas.size() + ":" + list.size() + ")");
        }
        Iterator iterator = this.alphas.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            AtomicSymbol atomicSymbol;
            Alphabet alphabet = (Alphabet)iterator.next();
            if (alphabet.contains(atomicSymbol = (AtomicSymbol)iterator2.next())) continue;
            throw new IllegalSymbolException("CrossProductAlphabet " + this.getName() + " does not accept " + list + " as symbol " + atomicSymbol.getName() + " is not a member of the alphabet " + alphabet.getName());
        }
        return AlphabetManager.createSymbol('?', Annotation.EMPTY_ANNOTATION, list, (Alphabet)this);
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void validate(Symbol symbol) throws IllegalSymbolException {
        if (!this.contains(symbol)) {
            throw new IllegalSymbolException("CrossProductAlphabet " + this.getName() + " does not accept " + symbol.getName() + " as it is not an instance of CrossProductSymbol or " + " an AmbiguitySymbol over a subset of symbols in this alphabet.");
        }
    }
}

