/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.FlatModel;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleStatePath;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public abstract class DP {
    private MarkovModel model;
    private State[] states;
    private int[][] forwardTransitions;
    private int[][] backwardTransitions;
    private int dotStatesIndex;
    private int lockCount = 0;
    private Map forwardTransitionScores;
    private Map backwardTransitionScores;
    private final ChangeListener UPDATER = new ChangeListener(){

        public void postChange(ChangeEvent changeEvent) {
            if (changeEvent.getType() == MarkovModel.ARCHITECTURE || changeEvent.getType() == MarkovModel.PARAMETER) {
                DP.this.update();
            }
        }

        public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
        }
    };

    public DP(MarkovModel markovModel) throws IllegalSymbolException, IllegalTransitionException, BioException {
        this.model = markovModel;
        this.forwardTransitionScores = new HashMap();
        this.backwardTransitionScores = new HashMap();
        this.update();
        markovModel.addChangeListener(this.UPDATER);
    }

    public abstract double backward(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix backwardMatrix(SymbolList[] var1, DPMatrix var2, ScoreType var3) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix backwardMatrix(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public static double[][] backwardTransitionScores(MarkovModel markovModel, State[] stateArray, int[][] nArray, ScoreType scoreType) throws IllegalSymbolException {
        int n = stateArray.length;
        double[][] dArray = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            dArray[n2] = new double[nArray[n2].length];
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                try {
                    dArray[n2][n3] = Math.log(scoreType.calculateScore(markovModel.getWeights(state), stateArray[nArray[n2][n3]]));
                }
                catch (IllegalSymbolException illegalSymbolException) {
                    throw new BioError(illegalSymbolException, "Transition listed in transitions array has dissapeared");
                }
                ++n3;
            }
            ++n2;
        }
        return dArray;
    }

    public static int[][] backwardTransitions(MarkovModel markovModel, State[] stateArray) throws IllegalSymbolException {
        int n = stateArray.length;
        int[][] nArray = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            int[] nArray2 = new int[n];
            int n3 = 0;
            FiniteAlphabet finiteAlphabet = markovModel.transitionsFrom(stateArray[n2]);
            int n4 = 0;
            while (n4 < n) {
                if (finiteAlphabet.contains(stateArray[n4])) {
                    nArray2[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray3 = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                nArray3[n5] = nArray2[n5];
                ++n5;
            }
            nArray[n2] = nArray3;
            ++n2;
        }
        return nArray;
    }

    public static MarkovModel flatView(MarkovModel markovModel) throws IllegalAlphabetException, IllegalSymbolException {
        Iterator iterator = markovModel.stateAlphabet().iterator();
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            if (state instanceof DotState || state instanceof EmissionState) continue;
            return new FlatModel(markovModel);
        }
        return markovModel;
    }

    public abstract double forward(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix forwardMatrix(SymbolList[] var1, DPMatrix var2, ScoreType var3) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix forwardMatrix(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public static double[][] forwardTransitionScores(MarkovModel markovModel, State[] stateArray, int[][] nArray, ScoreType scoreType) throws IllegalSymbolException {
        int n = stateArray.length;
        double[][] dArray = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            dArray[n2] = new double[nArray[n2].length];
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                try {
                    dArray[n2][n3] = Math.log(scoreType.calculateScore(markovModel.getWeights(stateArray[nArray[n2][n3]]), state));
                }
                catch (IllegalSymbolException illegalSymbolException) {
                    throw new BioError(illegalSymbolException, "Transition listed in transitions array has dissapeared.");
                }
                ++n3;
            }
            ++n2;
        }
        return dArray;
    }

    public static int[][] forwardTransitions(MarkovModel markovModel, State[] stateArray) throws IllegalSymbolException {
        int n = stateArray.length;
        int[][] nArray = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            int[] nArray2 = new int[n];
            int n3 = 0;
            FiniteAlphabet finiteAlphabet = markovModel.transitionsTo(stateArray[n2]);
            int n4 = 0;
            while (n4 < n) {
                if (finiteAlphabet.contains(stateArray[n4])) {
                    nArray2[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray3 = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                nArray3[n5] = nArray2[n5];
                ++n5;
            }
            nArray[n2] = nArray3;
            ++n2;
        }
        return nArray;
    }

    public DPMatrix forwardsBackwards(SymbolList[] symbolListArray, ScoreType scoreType) throws BioException {
        try {
            System.out.println("Making backward matrix");
            final DPMatrix dPMatrix = this.backwardMatrix(symbolListArray, scoreType);
            System.out.println("Making forward matrix");
            final DPMatrix dPMatrix2 = this.forwardMatrix(symbolListArray, scoreType);
            System.out.println("Making forward/backward matrix");
            return new DPMatrix(){

                public double getCell(int[] nArray) {
                    return dPMatrix2.getCell(nArray) + dPMatrix.getCell(nArray);
                }

                public double getScore() {
                    return dPMatrix2.getScore();
                }

                public MarkovModel model() {
                    return dPMatrix2.model();
                }

                public State[] states() {
                    return dPMatrix2.states();
                }

                public SymbolList[] symList() {
                    return dPMatrix2.symList();
                }
            };
        }
        catch (Exception exception) {
            throw new BioException(exception, "Couldn't build forwards-backwards matrix");
        }
    }

    public StatePath generate(int n) throws IllegalSymbolException, BioException {
        Changeable changeable;
        Changeable changeable2;
        Symbol symbol;
        Changeable changeable3;
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        ArrayList<State> arrayList2 = new ArrayList<State>();
        ArrayList<DoubleAlphabet.DoubleSymbol> arrayList3 = new ArrayList<DoubleAlphabet.DoubleSymbol>();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = n;
        State state = (State)this.model.getWeights(this.model.magicalState()).sampleSymbol();
        Distribution distribution = this.model.getWeights(state);
        try {
            d2 += distribution.getWeight(state);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Transition returned from sampleTransition is invalid");
        }
        DoubleAlphabet doubleAlphabet = DoubleAlphabet.getInstance();
        if (state instanceof EmissionState) {
            changeable3 = (EmissionState)state;
            symbol = changeable3.getDistribution().sampleSymbol();
            arrayList2.add(state);
            arrayList.add(symbol);
            arrayList3.add(doubleAlphabet.getSymbol(d2 += changeable3.getDistribution().getWeight(symbol)));
            d += d2;
            d2 = 0.0;
            --n2;
        }
        while (n2 != 0) {
            changeable3 = null;
            changeable2 = this.model.getWeights(state);
            while ((changeable3 = (State)changeable2.sampleSymbol()) == this.model.magicalState() && n2 > 0) {
            }
            try {
                d2 += changeable2.getWeight((Symbol)changeable3);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Transition returned from sampleTransition is invalid");
            }
            if (changeable3 == this.model.magicalState()) break;
            if (changeable3 instanceof EmissionState) {
                changeable = changeable3;
                symbol = changeable.getDistribution().sampleSymbol();
                arrayList2.add((State)changeable3);
                arrayList.add(symbol);
                arrayList3.add(doubleAlphabet.getSymbol(d2 += changeable.getDistribution().getWeight(symbol)));
                d += d2;
                d2 = 0.0;
                --n2;
            }
            state = changeable3;
        }
        changeable3 = new SimpleSymbolList(this.model.emissionAlphabet(), arrayList);
        changeable2 = new SimpleSymbolList(this.model.stateAlphabet(), arrayList2);
        changeable = new SimpleSymbolList(doubleAlphabet, arrayList3);
        return new SimpleStatePath(d, (SymbolList)changeable3, (SymbolList)changeable2, new SimpleSymbolList(doubleAlphabet, arrayList3));
    }

    public double[][] getBackwardTransitionScores(ScoreType scoreType) {
        double[][] dArray = (double[][])this.backwardTransitionScores.get(scoreType);
        if (dArray == null) {
            try {
                dArray = DP.backwardTransitionScores(this.getModel(), this.getStates(), this.backwardTransitions, scoreType);
                this.backwardTransitionScores.put(scoreType, dArray);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Inconsistency in model");
            }
        }
        return dArray;
    }

    public int[][] getBackwardTransitions() {
        return this.backwardTransitions;
    }

    public int getDotStatesIndex() {
        return this.dotStatesIndex;
    }

    public double[][] getForwardTransitionScores(ScoreType scoreType) {
        double[][] dArray = (double[][])this.forwardTransitionScores.get(scoreType);
        if (dArray == null) {
            try {
                dArray = DP.forwardTransitionScores(this.getModel(), this.getStates(), this.forwardTransitions, scoreType);
                this.forwardTransitionScores.put(scoreType, dArray);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Inconsistency in model");
            }
        }
        return dArray;
    }

    public int[][] getForwardTransitions() {
        return this.forwardTransitions;
    }

    public MarkovModel getModel() {
        return this.model;
    }

    public State[] getStates() {
        return this.states;
    }

    public void lockModel() {
        if (this.lockCount++ == 0) {
            this.getModel().addChangeListener(ChangeListener.ALWAYS_VETO);
        }
    }

    public static double scoreWeightMatrix(WeightMatrix weightMatrix, SymbolList symbolList, int n) throws IllegalSymbolException {
        double d = 0.0;
        int n2 = weightMatrix.columns();
        int n3 = 0;
        while (n3 < n2) {
            d += Math.log(weightMatrix.getColumn(n3).getWeight(symbolList.symbolAt(n3 + n)));
            ++n3;
        }
        return d;
    }

    public static State[] stateList(MarkovModel markovModel) throws IllegalSymbolException, IllegalTransitionException, BioException {
        Object object;
        Object object2;
        FiniteAlphabet finiteAlphabet = markovModel.stateAlphabet();
        ArrayList arrayList = new ArrayList();
        class Org_biojava_bio_dp_DP$3 {
            /* synthetic */ Org_biojava_bio_dp_DP$3() {
            }
        }
        HMMOrderByTransition hMMOrderByTransition = new HMMOrderByTransition(null, markovModel);
        LinkedList linkedList = new LinkedList();
        Iterator iterator = finiteAlphabet.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof EmissionState) {
                arrayList.add(object2);
                continue;
            }
            ListIterator listIterator = linkedList.listIterator();
            int n = -1;
            while (listIterator.hasNext() && n == -1) {
                object = listIterator.next();
                if (hMMOrderByTransition.compare(object2, object) != HMMOrderByTransition.LESS_THAN) continue;
                n = listIterator.nextIndex() - 1;
            }
            if (n >= 0) {
                linkedList.add(n, object2);
                continue;
            }
            linkedList.add(object2);
        }
        object2 = new State[arrayList.size() + linkedList.size()];
        int n = 0;
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            object = (EmissionState)iterator2.next();
            int[] nArray = object.getAdvance();
            if (nArray.length != markovModel.heads()) {
                throw new BioException("State " + object.getName() + " advances " + nArray.length + " heads. " + " however, the model " + markovModel.stateAlphabet().getName() + " advances " + markovModel.heads() + " heads.");
            }
            int n2 = 0;
            while (nArray != null && n2 < nArray.length) {
                if (nArray[n2] != 0) {
                    nArray = null;
                }
                ++n2;
            }
            if (nArray != null) {
                throw new Error("State " + object.getName() + " has advance " + nArray);
            }
            object2[n++] = object;
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            object2[n++] = (State)object.next();
        }
        return object2;
    }

    public void unlockModel() {
        if (--this.lockCount == 0) {
            this.getModel().removeChangeListener(ChangeListener.ALWAYS_VETO);
        }
    }

    public void update() {
        try {
            this.states = DP.stateList(this.model);
            this.forwardTransitions = DP.forwardTransitions(this.model, this.states);
            this.forwardTransitionScores.clear();
            this.backwardTransitions = DP.backwardTransitions(this.model, this.states);
            this.backwardTransitionScores.clear();
            int n = 0;
            while (n < this.states.length) {
                if (!(this.states[n] instanceof EmissionState)) break;
                ++n;
            }
            this.dotStatesIndex = n;
        }
        catch (Exception exception) {
            throw new BioError(exception, "Something is seriously wrong with the DP code");
        }
    }

    public abstract StatePath viterbi(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalArgumentException, IllegalAlphabetException, IllegalTransitionException;

    public static class ReverseIterator
    implements Iterator,
    Serializable {
        private SymbolList sym;
        private int index;

        public ReverseIterator(SymbolList symbolList) {
            this.sym = symbolList;
            this.index = symbolList.length();
        }

        public boolean hasNext() {
            return this.index > 0;
        }

        public Object next() {
            return this.sym.symbolAt(this.index--);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("This itterator can not cause modifications");
        }
    }

    private static class HMMOrderByTransition {
        public static final Object GREATER_THAN = new Object();
        public static final Object LESS_THAN = new Object();
        public static final Object EQUAL = new Object();
        public static final Object DISJOINT = new Object();
        private MarkovModel mm;

        /* synthetic */ HMMOrderByTransition(3 var1_1, MarkovModel markovModel) {
            this(markovModel);
        }

        private HMMOrderByTransition(MarkovModel markovModel) {
            this.mm = markovModel;
        }

        public Object compare(Object object, Object object2) throws IllegalTransitionException, IllegalSymbolException {
            if (object == object2) {
                return EQUAL;
            }
            State state = (State)object;
            State state2 = (State)object2;
            if (this.transitionsTo(state, state2)) {
                return LESS_THAN;
            }
            if (this.transitionsTo(state2, state)) {
                return GREATER_THAN;
            }
            return DISJOINT;
        }

        private boolean transitionsTo(State state, State state2) throws IllegalTransitionException, IllegalSymbolException {
            HashSet<State> hashSet = new HashSet<State>();
            HashSet hashSet2 = new HashSet(this.mm.transitionsFrom(state).symbols().toList());
            while (hashSet2.size() > 0) {
                HashSet<State> hashSet3 = new HashSet<State>();
                Iterator iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    State state3 = (State)iterator.next();
                    if (state3 instanceof EmissionState) continue;
                    if (state3 == state) {
                        throw new IllegalTransitionException(state, state, "Loop in dot states.");
                    }
                    if (state3 == state2) {
                        return true;
                    }
                    Iterator iterator2 = this.mm.transitionsFrom(state3).iterator();
                    while (iterator2.hasNext()) {
                        State state4 = (State)iterator2.next();
                        if (hashSet2.contains(state4) || hashSet.contains(state4)) continue;
                        hashSet3.add(state4);
                    }
                    hashSet.add(state3);
                }
                hashSet2 = hashSet3;
            }
            return false;
        }
    }
}

