/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.symbol.RangeLocation;

public class LayeredRenderer {
    public static final LayeredRenderer INSTANCE = new LayeredRenderer();

    public double getDepth(List list, RangeLocation rangeLocation, List list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + list.size() + ":" + list2.size());
        }
        double d = 0.0;
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            SequenceRenderContext sequenceRenderContext = (SequenceRenderContext)iterator.next();
            SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator2.next();
            d += sequenceRenderer.getDepth(sequenceRenderContext, rangeLocation);
        }
        return d;
    }

    public double getMinimumLeader(List list, RangeLocation rangeLocation, List list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + list.size() + ":" + list2.size());
        }
        double d = 0.0;
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            SequenceRenderContext sequenceRenderContext = (SequenceRenderContext)iterator.next();
            SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator2.next();
            d = Math.max(d, sequenceRenderer.getMinimumLeader(sequenceRenderContext, rangeLocation));
        }
        return d;
    }

    public double getMinimumTrailer(List list, RangeLocation rangeLocation, List list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + list.size() + ":" + list2.size());
        }
        double d = 0.0;
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            SequenceRenderContext sequenceRenderContext = (SequenceRenderContext)iterator.next();
            SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator2.next();
            d = Math.max(d, sequenceRenderer.getMinimumTrailer(sequenceRenderContext, rangeLocation));
        }
        return d;
    }

    public void paint(Graphics2D graphics2D, List list, RangeLocation rangeLocation, List list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + list.size() + ":" + list2.size());
        }
        double d = 0.0;
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        while (iterator.hasNext() && iterator2.hasNext()) {
            SequenceRenderContext sequenceRenderContext = (SequenceRenderContext)iterator.next();
            SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator2.next();
            int n = sequenceRenderContext.getDirection();
            double d2 = sequenceRenderer.getDepth(sequenceRenderContext, rangeLocation);
            double d3 = sequenceRenderContext.sequenceToGraphics(rangeLocation.getMin()) - sequenceRenderer.getMinimumLeader(sequenceRenderContext, rangeLocation);
            double d4 = sequenceRenderContext.sequenceToGraphics(rangeLocation.getMax()) + sequenceRenderer.getMinimumTrailer(sequenceRenderContext, rangeLocation);
            if (n == 0) {
                double_.setFrame(d3, 0.0, d4 - d3, d2);
                graphics2D.translate(0.0, d);
            } else {
                double_.setFrame(0.0, d3, d2, d4 - d3);
                graphics2D.translate(d, 0.0);
            }
            Shape shape = graphics2D.getClip();
            graphics2D.clip(double_);
            sequenceRenderer.paint(graphics2D, sequenceRenderContext, rangeLocation);
            graphics2D.setClip(shape);
            if (n == 0) {
                graphics2D.translate(0.0, -d);
            } else {
                graphics2D.translate(-d, 0.0);
            }
            d += sequenceRenderer.getDepth(sequenceRenderContext, rangeLocation);
        }
    }

    public SequenceViewerEvent processMouseEvent(List list, MouseEvent mouseEvent, List list2, RangeLocation rangeLocation, List list3) {
        if (list.size() != list3.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + list.size() + ":" + list3.size());
        }
        double d = 0.0;
        Iterator iterator = list.iterator();
        Iterator iterator2 = list3.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            SequenceRenderContext sequenceRenderContext = (SequenceRenderContext)iterator.next();
            SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator2.next();
            double d2 = sequenceRenderer.getDepth(sequenceRenderContext, rangeLocation);
            SequenceViewerEvent sequenceViewerEvent = null;
            if (sequenceRenderContext.getDirection() == 0) {
                if ((double)mouseEvent.getY() >= d && (double)mouseEvent.getY() < d + d2) {
                    mouseEvent.translatePoint(0, (int)(-d));
                    sequenceViewerEvent = sequenceRenderer.processMouseEvent(sequenceRenderContext, mouseEvent, list2, rangeLocation);
                    mouseEvent.translatePoint(0, (int)d);
                }
            } else if ((double)mouseEvent.getX() >= d && (double)mouseEvent.getX() < d + d2) {
                mouseEvent.translatePoint((int)(-d), 0);
                sequenceViewerEvent = sequenceRenderer.processMouseEvent(sequenceRenderContext, mouseEvent, list2, rangeLocation);
                mouseEvent.translatePoint((int)d, 0);
            }
            if (sequenceViewerEvent != null) {
                return sequenceViewerEvent;
            }
            d += d2;
        }
        return null;
    }
}

