###################################################
### chunk number 1: Setting
###################################################
#line 100 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
  options(width=65)
  set.seed(123)


###################################################
### chunk number 2: LoadLib
###################################################
#line 107 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
library(nlcv)


###################################################
### chunk number 3: Simulation
###################################################
#line 115 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
EsetRandom <- simulateData(nCols = 40, nRows = 1000, nEffectRows = 0, nNoEffectCols = 0)


###################################################
### chunk number 4: Simulation
###################################################
#line 120 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
EsetStrongSignal <- simulateData(nCols = 40, nRows = 1000, nEffectRows = 10, nNoEffectCols = 0,
		betweenClassDifference = 3, withinClassSd = 0.5)


###################################################
### chunk number 5: Simulation
###################################################
#line 126 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
EsetWeakSignal <- simulateData(nCols = 40, nRows = 1000, nEffectRows = 5, nNoEffectCols = 0,
		betweenClassDifference = 1, withinClassSd = 0.6)


###################################################
### chunk number 6: Simulation
###################################################
#line 134 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
EsetStrongHeteroSignal <- simulateData(nCols = 40, nRows = 1000, nEffectRows = 5, nNoEffectCols = 5,
		betweenClassDifference = 3, withinClassSd = 0.5)


###################################################
### chunk number 7: Simulation
###################################################
#line 141 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
EsetWeakHeteroSignal <- simulateData(nCols = 40, nRows = 1000, nEffectRows = 5, nNoEffectCols = 5,
		betweenClassDifference = 1, withinClassSd = 0.6)


###################################################
### chunk number 8: Simulation
###################################################
#line 158 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
		geneX <- 1
		myData <- EsetStrongHeteroSignal
		xx <- pData(myData)$type
		yy <- exprs(myData)[geneX,]
		myTitle <- rownames(exprs(myData))[geneX]
	pdf(file = "./graphs/plotGeneSHS.pdf")
		boxplot(yy~xx,col='grey',xlab='',ylab='', main = myTitle, axes=FALSE)
		text(xx,yy,labels=colnames(exprs(myData)),col='blue',pos=4,cex=0.7)
		axis(1, at=1:2, labels=levels(xx));axis(2, las=2)
	dev.off()


###################################################
### chunk number 9: nlcv eval=FALSE
###################################################
## #line 184 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
##   nlcvTT_SS <- nlcv(EsetStrongSignal, classVar = "type", nRuns = 2, fsMethod = "t.test", verbose = TRUE)


###################################################
### chunk number 10: nlcv load_objects_20runs
###################################################
#line 191 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
  # No Signal - Random data
  data("nlcvRF_R"); data("nlcvTT_R")
  # Strong Signal
  data("nlcvRF_SS"); data("nlcvTT_SS")
  # Weak Signal
  data("nlcvRF_WS"); data("nlcvTT_WS")
  # Strong, heterogeneous Signal
  data("nlcvRF_SHS"); data("nlcvTT_SHS")
  # Weak, heterogeneous Signal
  data("nlcvRF_WHS"); data("nlcvTT_WHS")


###################################################
### chunk number 11: nlcv run_objects_20runs
###################################################
#line 204 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
#	# Sidenote:  nlcvRF_SS (loaded in the previous chunk) was obtained with following code
#	nlcvRF_SS <- nlcv(EsetStrongSignal, classVar = "type", nRuns = 20, fsMethod = "randomForest", verbose = TRUE)
#	save(nlcvRF_SS, file = "nlcvRF_SS.rda")
#	nlcvTT_SS <- nlcv(EsetStrongSignal, classVar = "type", nRuns = 20, fsMethod = "t.test", verbose = TRUE)
#	save(nlcvTT_SS, file = "nlcvTT_SS.rda")
#	
#	Similarly for any other dataset, like EsetWeakSignal, WeakHeteroSignal, StrongHeteroSignal and EsetRandom


###################################################
### chunk number 12: mcrPlot_RandomData
###################################################
#line 221 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
# plot MCR versus number of features
pdf(file = "./graphs/mcrPlot_nlcv_R.pdf", width = 10, height = 5)
  layout(matrix(1:4, ncol = 2), height = c(6, 1, 6, 1))
  mcrPlot_RF_R <- mcrPlot(nlcvRF_R, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'RF selection')
  mcrPlot_TT_R <- mcrPlot(nlcvTT_R, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'T selection')
  layout(1)
dev.off()


###################################################
### chunk number 13: scoresPlot_RandomData
###################################################
#line 252 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
pdf(file = "./graphs/ScoresPlot_nlcv_R.pdf", width = 10, height = 6)
scoresPlot(nlcvRF_R, "randomForest", 5)
dev.off()


###################################################
### chunk number 14: selGenes
###################################################
#line 269 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvRF_R, n = 10)
xtable(outtable, label = "tab:selGenes_R",
		caption="Top 10 features across all runs of the nested loop cross-validation.")


###################################################
### chunk number 15: Simulation
###################################################
#line 281 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
		geneX <- 1
		myData <- EsetStrongSignal
		xx <- pData(myData)$type
		yy <- exprs(myData)[geneX,]
		myTitle <- rownames(exprs(myData))[geneX]
	pdf(file = "./graphs/plotGeneSS.pdf")
	boxplot(yy~xx,col='grey',xlab='',ylab='', main = myTitle, axes=FALSE)
	text(xx,yy,labels=colnames(exprs(myData)),col='blue',pos=4,cex=0.7)
	axis(1, at=1:2, labels=levels(xx));axis(2, las=2)
		dev.off()


###################################################
### chunk number 16: RandomData
###################################################
#line 304 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
# plot MCR versus number of features
pdf(file = "./graphs/mcrPlot_nlcv_SS.pdf", width = 10, height = 5)
  layout(matrix(1:4, ncol = 2), height = c(6, 1, 6, 1))
  mcrPlot_SSF_SS <- mcrPlot(nlcvRF_SS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'RF selection')
  mcrPlot_TT_SS <- mcrPlot(nlcvTT_SS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'T selection')
dev.off()


###################################################
### chunk number 17: RandomData
###################################################
#line 324 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
pdf(file = "./graphs/ScoresPlot_nlcv_SS.pdf", width = 10, height = 6)
scoresPlot(nlcvRF_SS, "randomForest", 5)
dev.off()


###################################################
### chunk number 18: selGenes
###################################################
#line 341 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvRF_SS, n = 12)
xtable(outtable, label = "tab:selGenes_SS",
		caption="Top 20 features across all runs of the nested loop cross-validation.")


###################################################
### chunk number 19: Simulation
###################################################
#line 353 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
		geneX <- 1
		myData <- EsetWeakSignal
		xx <- pData(myData)$type
		yy <- exprs(myData)[geneX,]
		myTitle <- rownames(exprs(myData))[geneX]
	pdf(file = "./graphs/plotGeneWS.pdf")
	boxplot(yy~xx,col='grey',xlab='',ylab='', main = myTitle, axes=FALSE)
	text(xx,yy,labels=colnames(exprs(myData)),col='blue',pos=4,cex=0.7)
	axis(1, at=1:2, labels=levels(xx));axis(2, las=2)
		dev.off()


###################################################
### chunk number 20: RandomData
###################################################
#line 379 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
# plot MCR versus number of features
pdf(file = "./graphs/mcrPlot_nlcv_WS.pdf", width = 10, height = 5)
  layout(matrix(1:4, ncol = 2), height = c(6, 1, 6, 1))
  mcrPlot_WSF_WS <- mcrPlot(nlcvRF_WS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'RF selection')
  mcrPlot_TT_WS <- mcrPlot(nlcvTT_WS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'T selection')
dev.off()


###################################################
### chunk number 21: ScoresPlot_nlcv_WS
###################################################
#line 401 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
  pdf(file = "./graphs/ScoresPlot_nlcv_WS.pdf", width = 10, height = 6)
    scoresPlot(nlcvRF_WS, "svm", 7)
  dev.off()


###################################################
### chunk number 22: selGenesNlcvTT_WS
###################################################
#line 419 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvTT_WS, n = 7)
xtable(outtable, label = "tab:selGenes_WS1",
		caption="Top 20 features selected with t-test across all runs of the nested loop cross-validation.")


###################################################
### chunk number 23: selGenesNlcvRF_WS
###################################################
#line 425 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvRF_WS, n = 7)
xtable(outtable, label = "tab:selGenes_WS2",
		caption="Top 20 features selected with RF variable importance across all runs of the nested loop cross-validation.")


###################################################
### chunk number 24: Simulation
###################################################
#line 436 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
		geneX <- 1
		myData <- EsetStrongHeteroSignal
		xx <- pData(myData)$type
		yy <- exprs(myData)[geneX,]
		myTitle <- rownames(exprs(myData))[geneX]
	pdf(file = "./graphs/plotGeneSHS.pdf")
	boxplot(yy~xx,col='grey',xlab='',ylab='', main = myTitle, axes=FALSE)
	text(xx,yy,labels=colnames(exprs(myData)),col='blue',pos=4,cex=0.7)
	axis(1, at=1:2, labels=levels(xx));axis(2, las=2)
		dev.off()


###################################################
### chunk number 25: mcrPlot_nlcv_SHS
###################################################
#line 463 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
# plot MCR versus number of features
pdf(file = "./graphs/mcrPlot_nlcv_SHS.pdf", width = 10, height = 5)
  layout(matrix(1:4, ncol = 2), height = c(6, 1, 6, 1))
  mcrPlot_SHSF_SHS <- mcrPlot(nlcvRF_SHS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'RF selection')
  mcrPlot_TT_SHS <- mcrPlot(nlcvTT_SHS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'T selection')
dev.off()


###################################################
### chunk number 26: scoresPlots
###################################################
#line 485 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
pdf(file = "./graphs/ScoresPlot_nlcv_SHS.pdf", width = 10, height = 6)
  scoresPlot(nlcvTT_SHS, "pam", 7)
dev.off()
pdf(file = "./graphs/ScoresPlot_nlcv_SHS2.pdf", width = 10, height = 6)
  scoresPlot(nlcvTT_SHS, "randomForest", 7)
dev.off()
pdf(file = "./graphs/ScoresPlot_nlcv_SHS3.pdf", width = 10, height = 6)
  scoresPlot(nlcvRF_SHS, "randomForest", 7)
dev.off()


###################################################
### chunk number 27: selGenes
###################################################
#line 531 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvTT_SHS, n = 7)
xtable(outtable, label = "tab:selGenes_SHS1",
		caption="Top 20 features selected with t-test across all runs of the nested loop cross-validation.")


###################################################
### chunk number 28: selGenes
###################################################
#line 537 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvRF_SHS, n = 7)
xtable(outtable, label = "tab:selGenes_SHS2",
		caption="Top 20 features selected with RF variable importance across all runs of the nested loop cross-validation.")


###################################################
### chunk number 29: Simulation
###################################################
#line 549 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"

geneX <- 1:4
myData <- EsetWeakHeteroSignal
xx <- pData(myData)$type
pdf(file = "./graphs/plotGeneWHS.pdf")
par(mfrow=c(2,2))
for (i in 1:4){
	yy <- exprs(myData)[geneX[i],]
	myTitle <- rownames(exprs(myData))[geneX[i]]
boxplot(yy~xx,col='grey',xlab='',ylab='', main = myTitle, axes=FALSE)
	text(xx,yy,labels=colnames(exprs(myData)),col='blue',pos=4,cex=0.85)
	axis(1, at=1:2, labels=levels(xx));axis(2, las=2)
}
par(mfrow=c(1,1))
		dev.off()


###################################################
### chunk number 30: RandomData
###################################################
#line 579 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
# plot MCR versus number of features
pdf(file = "./graphs/mcrPlot_nlcv_WHS.pdf", width = 10, height = 5)
  layout(matrix(1:4, ncol = 2), height = c(6, 1, 6, 1))
  mcrPlot_WHSF_WHS <- mcrPlot(nlcvRF_WHS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'RF selection')
  mcrPlot_TT_WHS <- mcrPlot(nlcvTT_WHS, plot = TRUE, optimalDots = TRUE, layout = FALSE, main = 'T selection')
dev.off()


###################################################
### chunk number 31: RandomData
###################################################
#line 609 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
pdf(file = "./graphs/ScoresPlot_nlcv_WHS.pdf", width = 10, height = 6)
scoresPlot(nlcvTT_WHS, "pam", 2)
dev.off()
pdf(file = "./graphs/ScoresPlot_nlcv_WHS0.pdf", width = 10, height = 6)
scoresPlot(nlcvTT_WHS, "pam", 10)
dev.off()
pdf(file = "./graphs/ScoresPlot_nlcv_WHS2.pdf", width = 10, height = 6)
scoresPlot(nlcvTT_WHS, "randomForest", 15)
dev.off()
pdf(file = "./graphs/ScoresPlot_nlcv_WHS3.pdf", width = 10, height = 6)
scoresPlot(nlcvRF_WHS, "randomForest", 5)
dev.off()


###################################################
### chunk number 32: selGenes
###################################################
#line 666 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvTT_WHS, n = 10)
xtable(outtable, label = "tab:selGenes_WHS1",
		caption="Top 20 features selected with t-test across all runs of the nested loop cross-validation.")


###################################################
### chunk number 33: selGenes
###################################################
#line 672 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
outtable <- topTable(nlcvRF_WHS, n = 10)
xtable(outtable, label = "tab:selGenes_WHS2",
		caption="Top 20 features selected with RF variable importance across all runs of the nested loop cross-validation.")


###################################################
### chunk number 34: sessionInfo
###################################################
#line 682 "R:/tmp/RtmpyO5BtW/R.INSTALLd5a6a99/nlcv/inst/doc/nlcv.Rnw"
  toLatex(sessionInfo())


