### Name: var.add.ncdf
### Title: Add New netCDF Variable to Existing File
### Aliases: var.add.ncdf
### Keywords: utilities

### ** Examples

#===========================================================================
# PART 1.  MAKE A TEST NETCDF FILE THAT WE WILL ADD A VARIABLE TO IN PART 2.
#===========================================================================

#----------------
# Make dimensions
#----------------
xvals <- 1:360
yvals <- -90:90

nx <- length(xvals)
ny <- length(yvals)

xdim <- dim.def.ncdf( 'Lon', 'degreesE', xvals )
ydim <- dim.def.ncdf( 'Lat', 'degreesE', yvals )
tdim <- dim.def.ncdf( 'Time', 'days since 1900-01-01', 0, unlim=TRUE )

#---------
# Make var
#---------
mv <- 1.e30     # missing value
var_temp <- var.def.ncdf( 'Temperature', 'K', list(xdim,ydim,tdim), mv )

#---------------------
# Make new output file
#---------------------
output_fname <- 'test_real3d.nc'
ncid_new <- create.ncdf( output_fname, list(var_temp))

#-------------------------------
# Put some test data in the file
#-------------------------------
data_temp <- array(0.,dim=c(nx,ny,1))
for( j in 1:ny )
for( i in 1:nx )
        data_temp[i,j,1] <- sin(i/10)*sin(j/10)

put.var.ncdf( ncid_new, var_temp, data_temp, start=c(1,1,1), count=c(nx,ny,1))

#--------------------------
# Close our new output file
#--------------------------
close.ncdf( ncid_new )

#===========================================================================
# PART 2.  ADD A NEW VARIABLE TO THE FILE
#===========================================================================

#---------------------------------------------------
# Open the existing file we're going to add a var to
#---------------------------------------------------
ncid_old <- open.ncdf( output_fname, write=TRUE )

#------------------------------------------------------------------
# Make a NEW variable to put into the file.  Have this new variable
# use the same dimensions already in the file
#------------------------------------------------------------------
xdim2 <- ncid_old$dim[['Lon']]
ydim2 <- ncid_old$dim[['Lat']]
tdim2 <- ncid_old$dim[['Time']]
mv2 <- 1.e30
var_q <- var.def.ncdf( 'Humidity', 'g/kg', list(xdim2,ydim2,tdim2), mv2 )

ncid_old <- var.add.ncdf( ncid_old, var_q )     # NOTE this returns a modified netcdf file handle 

#-------------------------------------------------------------------
# Make a DIFFERENT new var that will be added to the file.  This var
# uses a dim that does NOT already exist in the file.
#-------------------------------------------------------------------
zdim   <- dim.def.ncdf( 'Level', 'hPa', seq(1000,100,by=-100))
var_cf <- var.def.ncdf( 'CloudFraction', 'percent', list(xdim2,ydim2,zdim,tdim2), mv2 )

ncid_old <- var.add.ncdf( ncid_old, var_cf )

print(ncid_old)

close.ncdf( ncid_old )



