### Name: set.missval.ncdf
### Title: Set the Missing Value Attribute For a netCDF Variable
### Aliases: set.missval.ncdf
### Keywords: utilities

### ** Examples

# Make an example netCDF file with a given missing value.  We will
# then change the missing value in the file using set.missval.ncdf.

origMissVal <- -1.
dimX   <- dim.def.ncdf( "X", "meters", 1:7 )
varAlt <- var.def.ncdf( "Altitude", "km", dimX, origMissVal )
ncnew  <- create.ncdf( "transect.nc", varAlt )
data <- c(10.,2.,NA,1.,7.,NA,8.)
put.var.ncdf( ncnew, varAlt, data )
close.ncdf(ncnew)

# At this point, the actual data values in the netCDF
# file will be: 10 2 -1 1 7 -1 8
# because the "NA" values were filled with the missing
# value, -1.  Also, the missing_value attribute of variable
# "varAlt" will be equal to -1.

# Now change the missing value to something else.  Remember
# we have to open the file as writable to be able to change
# the missing value on disk!

newMissVal <- 999.9
nc <- open.ncdf( "transect.nc", write=TRUE )
varname <- "Altitude"
data <- get.var.ncdf( nc, varname )  # data now has: 10., 2., NA, 1., 7., NA, 8.
print(data)
set.missval.ncdf( nc, varname, newMissVal )
put.var.ncdf( nc, varname, data )
close.ncdf(nc)

# Now, the actual data values in the netCDF file will be:
# 10 2 999.9 1 7 999.9 8
# and the variables "missing_value" attributre will be 999.9

# **NOTE** that we had to explicitly read in the data and write
# it out again in order for the on-disk missing values in the
# data array to change!  The on-disk missing_value attribute for
# the variable is set automatically by this function, but it is 
# up to you whether or not you want to read in all the files 
# data and change the values to the new missing value.



