### Name: open.ncdf
### Title: Open a netCDF File
### Aliases: open.ncdf
### Keywords: utilities

### ** Examples

# Define an integer dimension 
dimState <- dim.def.ncdf( "StateNo", "count", 1:50 )

# Make an integer variable.  Note that an integer variable can have
# a double precision dimension, or vice versa; there is no fixed
# relationship between the precision of the dimension and that of the
# associated variable.  We just make an integer variable here for
# illustration purposes.
varPop <- var.def.ncdf("Pop", "count", dimState, -1, 
        longname="Population", prec="integer")

# Create a netCDF file with this variable
ncnew <- create.ncdf( "states_population.nc", varPop )

# Write some values to this variable on disk.
popAlabama <- 4447100
put.var.ncdf( ncnew, varPop, popAlabama, start=1, count=1 )

# Add source info metadata to file
att.put.ncdf( ncnew, 0, "source", "Census 2000 from census bureau web site")

close.ncdf(ncnew)

# Now open the file and read its data
ncold <- open.ncdf("states_population.nc")
data <- get.var.ncdf(ncold)
print("here is the data in the file:")
print(data)
close.ncdf( ncold )



