### Name: dim.def.ncdf
### Title: Define a netCDF Dimension
### Aliases: dim.def.ncdf
### Keywords: utilities

### ** Examples

# Define some straightforward dimensions
x <- dim.def.ncdf( "Lon", "degreesE", 0.5:359.5)
y <- dim.def.ncdf( "Lat", "degreesN", as.double(-89:89))
t <- dim.def.ncdf( "Time", "days since 1900-01-01", 1:10, unlim=TRUE)

# Make a variable with those dimensions.  Note order: time is LAST
salinity <- var.def.ncdf("Salinity",    "ppt",  list(x,y,t), 1.e30 )

# Create a netCDF file with this variable
ncnew <- create.ncdf( "salinity.nc", salinity )

close.ncdf(ncnew)

# Now, illustrate some manipulations of the dim.ncdf object.
filename <- "salinity.nc"
nc <- open.ncdf( filename )
print(paste("File",filename,"contains",nc$ndims,"dimensions"))
for( i in 1:nc$ndims ) {
        print(paste("Here is information about dimension number",i,":"))
        d <- nc$dim[[i]]
        print(paste("    Name  :",d$name))
        print(paste("    Units :",d$units))
        print(paste("    Length:",d$len))
        print("    Values:")
        print(d$vals)
        print(paste("    Unlimited:",d$unlim))
        }



