### Name: put.var.ncdf
### Title: Write data to a netCDF file
### Aliases: put.var.ncdf
### Keywords: utilities

### ** Examples

# Make a few dimensions we can use
nx <- 3
ny <- 4
nt <- 5
xvals <- (1:nx)*100.
dimX <- dim.def.ncdf( "X", "meters", xvals )
dimY <- dim.def.ncdf( "Y", "meters", (1:ny)*100. )
dimT <- dim.def.ncdf( "Time", "seconds", (1:nt)/100., unlim=TRUE )

# Make varables of various dimensionality, for illustration purposes
mv <- 1.e30             # missing value to use
var1d <- var.def.ncdf( "var1d", "units", dimX, mv )
var2d <- var.def.ncdf( "var2d", "units", list(dimX,dimY), mv )
var3d <- var.def.ncdf( "var3d", "units", list(dimX,dimY,dimT), mv )

# Create the test file
nc <- create.ncdf( "writevals.nc", list(var1d,var2d,var3d) )

# Write some data to the file
data1d <- runif(nx)
put.var.ncdf( nc, var1d, data1d )       # no start or count: write all values
put.var.ncdf( nc, var1d, 27.5, start=3, count=1 ) # Write a value to the third slot

data2d <- runif(nx*ny)
put.var.ncdf( nc, var2d, data2d )       # no start or count: write all values
# Write a 1-d slice to the 2d var
put.var.ncdf( nc, var2d, data1d, start=c(1,2), count=c(nx,1) )  
# Note how "-1" in the count means "the whole dimension length", 
# which equals nx in this case
put.var.ncdf( nc, var2d, data1d, start=c(1,3), count=c(-1,1) )  

# The 3-d variable has an unlimited dimension.  We will loop over the timesteps,
# writing one 2-d slice per timestep.
for( i in 1:nt) 
        put.var.ncdf( nc, var3d, data2d, start=c(1,1,i), count=c(-1,-1,1) )

close.ncdf(nc)

#----------------------------------------------------------------------
# Illustrate creating a character type variable
#----------------------------------------------------------------------
cnames   <- c("red", "orange", "green", "yellow", "puce", "colorwithverylongname" )
nstrings <- length(cnames)

#--------------------------------------------------------------
# Make dimensions. Setting "dimnchar" to have a length of 12
# means that the maximum color name
# length can be 12.  Longer names will be truncated to this.
#--------------------------------------------------------------
dimnchar   <- dim.def.ncdf("nchar",   "", 1:12 )
dimcolorno <- dim.def.ncdf("colorno", "", 1:nstrings )

varcolors  <- var.def.ncdf("colors", "", list(dimnchar, dimcolorno), 
                        NA, prec="char" )

ncid <- create.ncdf( "colornames.nc", list(varcolors) )

put.var.ncdf( ncid, "colors", cnames )

close.ncdf( ncid )



