### Name: getLongestSubstring
### Title: Compute longest repeated or common substring in a SuffixTree
### Aliases: getLongestSubstring getLongestSubstring,character-method
###   getLongestSubstring,StringSet-method
###   getLongestSubstring,SuffixTree-method getLongestCommonSubstring
###   getLongestRepeatedSubstring
### Keywords: IO

### ** Examples


 els = c("aaabbbaaabbb", "aaa", "aabb")
  # "aaabbb"
 getLongestRepeatedSubstring(els)

  # "aa" 
 getLongestCommonSubstring(els)
  # Same call but with the geneal getLongestSubstring() function.
 getLongestSubstring(els, repeated = FALSE)

 
  words = c("stemming", "boing", "springs")
  tree = SuffixTree(words)

    # The longest common or repeated substring for these is the same - "ing"
    # Longest repeated substring
 getLongestRepeatedSubstring(tree)

    # Longest common substring.
 getLongestCommonSubstring(tree)

 # Find the repeated substring. 
 # Note it finds aaaa twice in the second string aaaax and xaaaa
 # where x is an arbitrary character, admittedly also a.
getLongestRepeatedSubstring(c("aaa sdsd", "aaaaa", "xyz"))


  # This returns "aa" which is repeated as subsequences 1:2 and 2:3,
  # i.e. repeating the use of the middle "a"
getLongestRepeatedSubstring("aaa")

 # Get the return value as a StringSet
set = getLongestSubstring(tree, asCharacter = FALSE)
length(set)

 # The word mississipi and the same word backword and we can find the
 # longest palindrome.  Taken from the Perl module Tree::Suffix by Gray

 # First, a function to reverse the order of the characters in each word
 reverseWord = function(word)
                  sapply(strsplit(word, ""), function(x) paste(rev(x), collapse = ""))

 # Just check it does it correctly, round trip the word
"mississippi" == reverseWord(reverseWord("mississippi"))

  # We get "ississi 
 getLongestSubstring(c("mississippi", reverseWord("mississippi")), TRUE, c(0, 0))


 # just of the word itself.
 #   "issi"
getLongestSubstring("mississippi", TRUE, c(0, 0))

# Longest repeated substring is esday
getLongestSubstring(c("Monday", "Tuesday", "Wednesday"), TRUE)

# Longest common substring is day
getLongestSubstring(c("Monday", "Tuesday", "Wednesday"), FALSE)

  # We get the common prefix as the longest substring
  # [1] "ABCDEF_"
 getLongestSubstring(paste("ABCDEF_", c("Monday", "Tuesday", "Wednesday"), sep = ""), TRUE, c(0, 0))


 # The names of enumerated constants in Microsoft Word's
 # scripting interface.  We want to find the common prefix.

enumNames = c('wdSummaryModeHighlight',
              'wdSummaryModeHideAllButSummary',
              'wdSummaryModeInsert',
              'wdSummaryModeCreateNew')

 # common substring
x = getLongestCommonSubstring(enumNames)

x == "wdSummaryMode"

 # longest repeated substring
 # This is "wdSummaryModeHi" shared by the first two elements.

x = getLongestSubstring(enumNames)

x == "wdSummaryModeHi"

# A series of examples of repeated substrings within a single string

 # "first a"
getLongestSubstring("first and first again and again")

 # [1] "first " " again"
getLongestSubstring("first then first again and again")

 # [1] "first " " again"
getLongestSubstring(c("first then first again and again", "first"))

 # This finds " again and again" 
getLongestSubstring(c("first then first again and again", "Or again and again"))


  # We take this very long place name in New Zealand and find the
  # repeated substrings.
  # "ata" "aka" "ang" "mat" "tan" "nga" 
  nzPlaceName = "Taumatawhakatangihangakoauauotamateaturipukakapikimaungahoronukupokaiwhenuakitanatahu"
  getLongestRepeatedSubstring(nzPlaceName)




