### Name: dbNextResult-methods
### Title: Fetch Next Result Set from Multiple Statements or Stored
###   Procedures
### Aliases: dbNextResult-methods dbNextResult,MySQLConnection-method
###   dbMoreResults-methods dbMoreResults,MySQLConnection-method
### Keywords: methods methods interface database

### ** Examples
## Not run: 
##D con <- dbConnect(MySQL(), 
##D           dbname = "rs-dbi", 
##D           client.flag=CLIENT\_MULTI\_STATEMENTS)
##D sql.script <- paste(
##D    "select * from abc",
##D    "select * def", 
##D    collapse = ";")
##D 
##D rs1 <- dbSendQuery(con, sql.script)
##D data1 <- fetch(rs1, n = -1)
##D 
##D if(dbMoreResults(con)){
##D    rs2 <- dbNextResult(con)
##D    ## you could use dbHasCompleted(rs2) to determine whether
##D    ## rs2 is a select-like that generates output or not.
##D    data2 <- fetch(rs2, n = -1)   
##D    }
## End(Not run)



