### Name: xmlNamespace
### Title: Retrieve the namespace value of an XML node.
### Aliases: xmlNamespace xmlNamespace.XMLNode xmlNamespace.XMLInternalNode
###   xmlNamespace.character XMLNamespace-class
### Keywords: file

### ** Examples

  doc <- xmlTreeParse(system.file("exampleData", "job.xml", package="XML"))
  xmlNamespace(xmlRoot(doc))
  xmlNamespace(xmlRoot(doc)[[1]][[1]])

  doc <- xmlInternalTreeParse(system.file("exampleData", "job.xml", package="XML"))
     # Since the first node is a comment, get the sibling.
  xmlNamespace(getSibling(xmlRoot(doc)))
  xmlNamespace(getSibling(xmlRoot(doc))[[1]][[1]])

  node <- xmlNode("arg", xmlNode("name", "foo"), namespace="R")
  xmlNamespace(node)



