### Name: MySQL
### Title: Instantiate a MySQL client from the current R session
### Aliases: MySQL
### Keywords: interface database

### ** Examples
## Not run: 
##D # create a MySQL instance and create one connection.
##D > m <- dbDriver("MySQL")
##D <MySQLDriver:(4378)>
##D 
##D # open the connection using user, passsword, etc., as
##D # specified in the "[iptraffic]" section of the 
##D # configuration file \file{\$HOME/.my.cnf}
##D > con <- dbConnect(m, group = "iptraffic")
##D > rs <- dbSendQuery(con, "select * from HTTP_ACCESS where IP_ADDRESS = '127.0.0.1'")
##D > df <- fetch(rs, n = 50)
##D > dbHasCompleted(rs)
##D [1] FALSE
##D > df2 <- fetch(rs, n = -1)
##D > dbHasCompleted(rs)
##D [1] TRUE
##D > dbClearResult(rs)
##D > dim(dbGetQuery(con, "show tables"))
##D [1] 74   1
##D > dbListTables(con)    
## End(Not run)



