### Name: logitboost
### Title: LogitBoost
### Aliases: logitboost
### Keywords: classif

### ** Examples

data(leukemia)

## Dividing the leukemia dataset into training and test data
xlearn <- leukemia.x[c(1:20, 34:38),]
ylearn <- leukemia.y[c(1:20, 34:38)]
xtest  <- leukemia.x[21:33,]
ytest  <- leukemia.y[21:33]

## An example without stopping parameter estimation
fit <- logitboost(xlearn, ylearn, xtest, mfinal=100, presel=75, verbose=TRUE)
summarize(fit, ytest)

## Now with stopping parameter estimation by 4-fold cross validation
fit <- logitboost(xlearn, ylearn, xtest, mfinal=100, pre=75, esti=4, verb=TRUE)
summarize(fit, ytest)


