### Name: xmlAttrs
### Title: Get the list of attributes of an XML node.
### Aliases: xmlAttrs xmlAttrs<- xmlAttrs.XMLElementDef xmlAttrs<-,XMLNode
###   xmlAttrs<-,XMLInternalNode xmlAttrs<-,XMLNode-method
###   xmlAttrs<-,XMLInternalElementNode-method xmlAttrs.XMLNode
###   xmlAttrs.XMLInternalNode
### Keywords: IO file

### ** Examples

 fileName <- system.file("exampleData", "mtcars.xml", package="XML") 
 doc <- xmlTreeParse(fileName)

 xmlAttrs(xmlRoot(doc))

 xmlAttrs(xmlRoot(doc)[["variables"]])

 doc <- xmlTreeParse(fileName, useInternalNodes = TRUE)
 d = xmlRoot(doc)
   # skip over the comment
 d = XML:::getNextSibling(d)

 xmlAttrs(d)
 xmlAttrs(d) <- c(name = "Motor Trend fuel consumption data",
                  author = "Motor Trends")
 xmlAttrs(d)

   # clear all the attributes and then set new ones.
 removeAttributes(d)
 xmlAttrs(d) <- c(name = "Motor Trend fuel consumption data",
                  author = "Motor Trends")



