### Name: hsahomologyDATA
### Title: Genes that are Homologous to Homo sapiens
### Aliases: hsahomologyDATA
### Keywords: datasets

### ** Examples

    require("annotate") || stop("annotate unavailable")
    # Convert homologyDATA to a list
    xx <- as.list(hsahomologyDATA)

    if(length(xx) > 0){
        # Gets the homology data for the first key of hsahomologyDATA
        homodata <- xx[[1]]
        # Gets the organism name, LocusLink id, internal HomoloGene id,
        # GenBank accession number, type of similarity, percent
        # similarity, and URL for percent similarity for the first
        # homoData object in the list obtained previously
        homodata[[1]][["homoOrg"]]
        homodata[[1]][["homoHGID"]]
        homodata[[1]][["homoType"]]
        homodata[[1]][["homoPS"]]
        homodata[[1]][["homoURL"]]
        # Gets the values for more than one keys
        xx[1:3]
    }



