/*
 * Decompiled with CFR 0.152.
 */
package dcw.sarks;

import dcw.sarks.Sarks;
import dcw.sarks.SarksUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;

public class SarksMain {
    public static void sarkselect(String string, String string2, int[] nArray, int[] nArray2, double[] dArray, int n, Integer n2, double d, String string3, Integer n3, Long l) throws Exception {
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if (nArray2 == null) {
            nArray2 = new int[]{0};
        }
        if (dArray == null) {
            dArray = new double[]{Double.NEGATIVE_INFINITY};
        }
        if (n2 == null) {
            n2 = 12;
        }
        if (n3 == null) {
            n3 = 1;
        }
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        for (int n4 : nArray) {
            for (int n5 : nArray2) {
                for (double d2 : dArray) {
                    HashMap<String, Number> hashMap = new HashMap<String, Number>();
                    hashMap.put("halfWindow", n4);
                    hashMap.put("minGini", d2);
                    hashMap.put("spatialLength", n5);
                    hashMap.put("minSpatialGini", d2);
                    arrayList.add(hashMap);
                }
            }
        }
        Object object = new Sarks(string, string2, (Integer)((HashMap)arrayList.get(0)).get("halfWindow"), (Integer)((HashMap)arrayList.get(0)).get("spatialLength"), n3, false);
        ArrayList<Float[][]> arrayList2 = ((Sarks)object).permutationDistribution((Integer)n, arrayList, l);
        new File(string3).mkdirs();
        Sarks.printPermDists(arrayList, arrayList2, string3 + "permdists");
        Float[][] floatArray = SarksUtilities.thresholdsFromPermutations(arrayList2, d);
        Sarks.printThresholds(arrayList, floatArray, string3);
        ArrayList<ArrayList<Integer>> arrayList3 = ((Sarks)object).filter(arrayList, floatArray, (Boolean)true);
        ((Sarks)object).printPeaks(arrayList, floatArray, arrayList3, string3, n2);
        ArrayList<ArrayList<int[]>> arrayList4 = ((Sarks)object).multiMergeKmerIntervals(arrayList3, floatArray, arrayList, n2);
        ((Sarks)object).printMergedSubPeaks(arrayList, floatArray, arrayList4, string3, n2);
    }

    public static ArrayList<HashMap> readThresholds(String string) throws Exception {
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            String[] stringArray = string2.split("\t");
            hashMap.put("halfWindow", Integer.parseInt(stringArray[0]));
            hashMap.put("minGini", Double.parseDouble(stringArray[1]));
            hashMap.put("spatialLength", Integer.parseInt(stringArray[2]));
            if (stringArray[3].equals("null")) {
                hashMap.put("minSpatialGini", null);
            } else {
                hashMap.put("minSpatialGini", Double.parseDouble(stringArray[3]));
            }
            if (stringArray[4].equals("null")) {
                hashMap.put("theta", null);
            } else {
                hashMap.put("theta", Float.valueOf(Float.parseFloat(stringArray[4])));
            }
            if (stringArray[5].equals("null")) {
                hashMap.put("spatialTheta", null);
            } else {
                hashMap.put("spatialTheta", Float.valueOf(Float.parseFloat(stringArray[5])));
            }
            arrayList.add(hashMap);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return arrayList;
    }

    public static int sarkstest(String string, String string2, String string3, int n, String string4, Integer n2, Long l) throws Exception {
        if (!string4.endsWith("/")) {
            string4 = string4 + "/";
        }
        if (n2 == null) {
            n2 = 1;
        }
        ArrayList<HashMap> arrayList = SarksMain.readThresholds(string3);
        Float[][] floatArray = new Float[arrayList.size()][2];
        for (int i = 0; i < floatArray.length; ++i) {
            floatArray[i][0] = (Float)arrayList.get(i).get("theta");
            floatArray[i][1] = (Float)arrayList.get(i).get("spatialTheta");
        }
        Sarks sarks = new Sarks(string, string2, (Integer)arrayList.get(0).get("halfWindow"), (Integer)arrayList.get(0).get("spatialLength"), n2, false);
        ArrayList<Float[][]> arrayList2 = sarks.permutationDistribution((Integer)n, arrayList, l);
        new File(string4).mkdirs();
        Sarks.printPermDists(arrayList, arrayList2, string4 + "test_permdists");
        return SarksUtilities.falsePositives(arrayList2, floatArray);
    }

    public static String helpMessage(String string) {
        if (string == null) {
            return "sarks (Suffix Array Kernel Smoothing)\n  https://academic.oup.com/bioinformatics/article/35/20/3944/5418797\n  https://github.com/denniscwylie/sarks\n\nusage: java [jvm options] -jar sarks.jar <command> [arguments]\n\nCommands:\n  select    main step for motif discovery\n  test      estimate false positive rate associated with\n            motif set determined by select command\n";
        }
        if (string.equals("select")) {
            return "usage:\njava [jvm options] -jar sarks.jar select [-h] [-f FASTA] [-s SCORES]\n                                         [-w HALFWINDOW] [-l SPATIALLENGTH]\n                                         [-g MINGINI] [-r REPS] [-z NSIGMA]\n                                         [-e SEED] [-t NTHREADS] [-o OUTDIR]\n\nrequired arguments:\n  -f, --fasta FILE        input fasta file containing sequences to analyze\n                          (can be gzipped)\n  -s, --scores FILE       input scores tsv file:\n                          col1=seqids, col2=numeric scores\n                          (can be gzipped)\n  -w, --halfwindow INT    half window width (kappa) for first smoothing pass,\n                          can supply multiple values using commas (no spaces)\n  -o, --outdir DIR        output directory be created/overwritten\n\noptional arguments:\n  -l, --spatiallength INT spatial smoothing length (lambda), can supply\n                          multiple values using commas (no spaces)\n                          [default 0]\n  -g, --mingini FLOAT     parameter for calculation of Gini filter (gamma),\n                          can supply multiple values using commas (no spaces)\n                          [default 1.1]\n  -r, --reps INT          number R of permutations used to set significance\n                          thresholds  [default 100]\n  -z, --nsigma FLOAT      multiple z of standard deviations above mean (of\n                          max smoothed suffix scores obtained after randomly\n                          permuting sequence scores) defining threshold\n                          (Section S2.6, Eq (S24-S25) of paper)\n                          [default 4.0]\n  -e, --seed INT          seed for random number generator\n  -t, --threads INT       number of threads to use for permutational analyses\n                          [default 1]\n  -h, --help              show this help message and exit\n";
        }
        if (string.equals("test")) {
            return "usage:\njava [jvm options] -jar sarks.jar test [-h] [-f FASTA] [-s SCORES]\n                                       [-i INDIR] [-r REPS]\n                                       [-e SEED] [-t NTHREADS]\n\nrequired arguments:\n  -f, --fasta FILE        input fasta file containing sequences to analyze\n                          (can be gzipped)\n  -s, --scores FILE       input scores tsv file:\n                          col1=seqids, col2=numeric scores\n                          (can be gzipped)\n  -i, --indir DIR         input directory for test command is output directory\n                          from select command\n\noptional arguments:\n  -r, --reps INT          number R_2 of permutations used to test\n                          significance thresholds  [default 100]\n  -e, --seed INT          seed for random number generator;\n                          should NOT be the same seed as was used\n                          in select command used to generate input directory\n  -t, --threads INT       number of threads to use during permutational analyses\n                          [default 1]\n  -h, --help              show this help message and exit\n";
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println(SarksMain.helpMessage(null));
            System.exit(0);
        }
        String string = stringArray[0].toLowerCase();
        String string2 = null;
        if (string.equalsIgnoreCase("-h") || string.equalsIgnoreCase("--help")) {
            System.out.println(SarksMain.helpMessage(null));
            System.exit(0);
        }
        if (stringArray.length <= 2 && (stringArray.length == 1 || stringArray[1].equalsIgnoreCase("-h") || stringArray[1].equalsIgnoreCase("--help"))) {
            System.out.println(SarksMain.helpMessage(string));
            System.exit(0);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("spatialLength", 0);
        hashMap.put("minGini", Float.valueOf(1.1f));
        hashMap.put("reps", 100);
        hashMap.put("nSigma", 4.0);
        for (String string3 : stringArray) {
            int n;
            Object[] objectArray;
            String[] stringArray2;
            if (string3.startsWith("-")) {
                string2 = string3;
                while (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                }
                continue;
            }
            if (string2 == null) continue;
            String string4 = string2.toLowerCase();
            if (string4.equals("w") || string4.equals("halfwindow") || string4.equals("l") || string4.equals("spatiallength")) {
                stringArray2 = string3.split(",");
                objectArray = new int[stringArray2.length];
                for (n = 0; n < stringArray2.length; ++n) {
                    objectArray[n] = Integer.parseInt(stringArray2[n]);
                }
                if (string4.equals("w") || string4.equals("halfwindow")) {
                    hashMap.put("halfWindow", objectArray);
                    continue;
                }
                if (!string4.equals("l") && !string4.equals("spatiallength")) continue;
                hashMap.put("spatialLength", objectArray);
                continue;
            }
            if (string4.equals("g") || string4.equals("mingini")) {
                stringArray2 = string3.split(",");
                objectArray = new double[stringArray2.length];
                for (n = 0; n < stringArray2.length; ++n) {
                    objectArray[n] = (int)Double.parseDouble(stringArray2[n]);
                }
                hashMap.put("minGini", objectArray);
                continue;
            }
            if (string4.equals("i") || string4.equals("indir")) {
                hashMap.put("inDir", string3);
                continue;
            }
            if (string4.equals("f") || string4.equals("fasta")) {
                hashMap.put("fasta", string3);
                continue;
            }
            if (string4.equals("s") || string4.equals("scores")) {
                hashMap.put("scoreFile", string3);
                continue;
            }
            if (string4.equals("r") || string4.equals("reps")) {
                hashMap.put("reps", Integer.parseInt(string3));
                continue;
            }
            if (string4.equals("o") || string4.equals("outdir")) {
                hashMap.put("outDir", string3);
                continue;
            }
            if (string4.equals("z") || string4.equals("nsigma")) {
                hashMap.put("nSigma", Double.parseDouble(string3));
                continue;
            }
            if (string4.equals("e") || string4.equals("seed")) {
                hashMap.put("seed", Long.parseLong(string3));
                continue;
            }
            if (string4.equals("k") || string4.equals("kmax")) {
                hashMap.put("kMax", Integer.parseInt(string3));
                continue;
            }
            if (!string4.equals("t") && !string4.equals("threads") && !string4.equals("nthreads")) continue;
            hashMap.put("nThreads", Integer.parseInt(string3));
        }
        if (hashMap.get("fasta") == null || hashMap.get("scoreFile") == null) {
            System.out.println("Must specify -f FASTA and -s SCORES input files.");
            System.exit(-1);
        } else {
            if (!new File((String)hashMap.get("fasta")).exists()) {
                System.out.println((String)hashMap.get("fasta") + " not found.");
                System.exit(-1);
            }
            if (!new File((String)hashMap.get("scoreFile")).exists()) {
                System.out.println((String)hashMap.get("scoreFile") + " not found.");
                System.exit(-1);
            }
        }
        if (string.equals("select")) {
            SarksMain.sarkselect((String)hashMap.get("fasta"), (String)hashMap.get("scoreFile"), (int[])hashMap.get("halfWindow"), (int[])hashMap.get("spatialLength"), (double[])hashMap.get("minGini"), (Integer)hashMap.get("reps"), (Integer)hashMap.get("kMax"), (Double)hashMap.get("nSigma"), (String)hashMap.get("outDir"), (Integer)hashMap.get("nThreads"), (Long)hashMap.get("seed"));
        } else if (string.equals("test")) {
            Object object = (String)hashMap.get("inDir");
            if (!((String)object).endsWith("theta.tsv")) {
                if (!((String)object).endsWith("/")) {
                    object = (String)object + "/";
                }
                if (hashMap.get("outDir") == null) {
                    hashMap.put("outDir", object);
                }
                object = (String)object + "theta.tsv";
            }
            int n = SarksMain.sarkstest((String)hashMap.get("fasta"), (String)hashMap.get("scoreFile"), (String)object, (Integer)hashMap.get("reps"), (String)hashMap.get("outDir"), (Integer)hashMap.get("nThreads"), (Long)hashMap.get("seed"));
            System.out.println("" + n);
        }
    }
}

