/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleAssembly;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.genomic.Exon;
import org.biojava.bio.seq.genomic.SpliceVariant;
import org.biojava.bio.seq.impl.SimpleRNAFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class SimpleSpliceVariant
extends SimpleRNAFeature
implements SpliceVariant {
    static /* synthetic */ Class class$org$biojava$bio$seq$genomic$Exon;

    public SimpleSpliceVariant(Sequence sequence, FeatureHolder featureHolder, SpliceVariant.Template template) throws IllegalAlphabetException {
        super(sequence, featureHolder, template);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Sequence getRNA() {
        if (this.rna == null) {
            FeatureHolder featureHolder = this.filter(new FeatureFilter.ByClass(class$org$biojava$bio$seq$genomic$Exon != null ? class$org$biojava$bio$seq$genomic$Exon : (class$org$biojava$bio$seq$genomic$Exon = SimpleSpliceVariant.class$("org.biojava.bio.seq.genomic.Exon"))), false);
            Exon[] exonArray = new Exon[featureHolder.countFeatures()];
            int n = 0;
            Iterator iterator = featureHolder.features();
            while (iterator.hasNext()) {
                exonArray[n++] = (Exon)iterator.next();
            }
            Arrays.sort(exonArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Location location = (Location)object;
                    Location location2 = (Location)object2;
                    return location.getMin() - location2.getMin();
                }

                public boolean equals(Object object) {
                    return object == this;
                }
            });
            String string = String.valueOf(this.getType()) + "/" + this.getLocation();
            String string2 = String.valueOf(this.getSequence().getURN()) + "/" + string;
            SimpleAssembly simpleAssembly = new SimpleAssembly(string, string2);
            ComponentFeature.Template template = new ComponentFeature.Template();
            template.annotation = Annotation.EMPTY_ANNOTATION;
            template.strand = StrandedFeature.POSITIVE;
            int n2 = 0;
            n = 0;
            while (n < exonArray.length) {
                Sequence sequence = exonArray[n].getRNA();
                int n3 = sequence.length();
                template.componentSequence = sequence;
                template.componentLocation = new RangeLocation(1, n3);
                template.location = new RangeLocation(n2 + 1, n2 + n3);
                n2 += n3;
                try {
                    simpleAssembly.createFeature(template);
                }
                catch (BioException bioException) {
                    throw new BioError(bioException, "Assertion Failure: Could not splice exons together");
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError(changeVetoException, "Assertion Failure: Spliced exons could not be modified");
                }
                ++n;
            }
            this.rna = simpleAssembly;
        }
        return this.rna;
    }

    public Feature.Template makeTemplate() {
        SpliceVariant.Template template = new SpliceVariant.Template();
        this.fillTemplate(template);
        return template;
    }
}

