/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontend;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class FrontendFileReader {
    private JobFrontend myJobFrontend;
    private Map<Integer, FileHandler> myFileHandlerForFFD = new HashMap<Integer, FileHandler>();
    private int myNextFFD = 2;

    public FrontendFileReader(JobFrontend jobFrontend) {
        this.myJobFrontend = jobFrontend;
        this.myFileHandlerForFFD.put(1, new FileHandler(System.in));
    }

    public void inputFileOpen(JobBackendRef jobBackendRef, int n, File file) throws IOException {
        new FileHandler().inputFileOpen(jobBackendRef, n, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileRead(JobBackendRef jobBackendRef, int n, int n2) throws IOException {
        FileHandler fileHandler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            fileHandler = this.myFileHandlerForFFD.get(n);
        }
        if (fileHandler != null) {
            fileHandler.inputFileRead(jobBackendRef, n, n2);
        } else {
            jobBackendRef.inputFileReadResult(this.myJobFrontend, n, null, -1, new IOException("File closed, ffd=" + n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileSkip(JobBackendRef jobBackendRef, int n, long l) throws IOException {
        FileHandler fileHandler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            fileHandler = this.myFileHandlerForFFD.get(n);
        }
        if (fileHandler != null) {
            fileHandler.inputFileSkip(jobBackendRef, n, l);
        } else {
            jobBackendRef.inputFileSkipResult(this.myJobFrontend, n, 0L, new IOException("File closed, ffd=" + n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
        FileHandler fileHandler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            fileHandler = this.myFileHandlerForFFD.get(n);
        }
        if (fileHandler != null) {
            fileHandler.inputFileClose(jobBackendRef, n);
        } else {
            jobBackendRef.inputFileCloseResult(this.myJobFrontend, n, new IOException("File closed, ffd=" + n));
        }
    }

    private class FileHandler
    extends Thread {
        private LinkedBlockingQueue<Invocation> myQueue = new LinkedBlockingQueue();
        private InputStream myInputStream;
        private byte[] myBuffer = new byte[0];

        public FileHandler() {
            this.setDaemon(true);
            this.start();
        }

        public FileHandler(InputStream inputStream) {
            this.myInputStream = inputStream;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                while (this.myQueue.take().invoke()) {
                }
            }
            catch (Throwable throwable) {
                FrontendFileReader.this.myJobFrontend.terminateCancelJobOther(throwable);
            }
        }

        public void inputFileOpen(JobBackendRef jobBackendRef, int n, File file) {
            this.myQueue.offer(new InputFileOpenInvocation(jobBackendRef, n, file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileOpen(JobBackendRef jobBackendRef, int n, File file) throws IOException {
            int n2 = 0;
            IOException iOException = null;
            boolean bl = false;
            try {
                this.myInputStream = new FileInputStream(file);
                Map map = FrontendFileReader.this.myFileHandlerForFFD;
                synchronized (map) {
                    n2 = FrontendFileReader.this.myNextFFD++;
                    FrontendFileReader.this.myFileHandlerForFFD.put(n2, this);
                }
                bl = true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            jobBackendRef.inputFileOpenResult(FrontendFileReader.this.myJobFrontend, n, n2, iOException);
            return bl;
        }

        public void inputFileRead(JobBackendRef jobBackendRef, int n, int n2) {
            this.myQueue.offer(new InputFileReadInvocation(jobBackendRef, n, n2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileRead(JobBackendRef jobBackendRef, int n, int n2) throws IOException {
            int n3 = 0;
            IOException iOException = null;
            boolean bl = false;
            try {
                if (this.myBuffer.length < n2) {
                    this.myBuffer = new byte[n2];
                }
                n3 = this.myInputStream.read(this.myBuffer, 0, n2);
                bl = true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                try {
                    this.myInputStream.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                Map map = FrontendFileReader.this.myFileHandlerForFFD;
                synchronized (map) {
                    FrontendFileReader.this.myFileHandlerForFFD.remove(n);
                }
            }
            jobBackendRef.inputFileReadResult(FrontendFileReader.this.myJobFrontend, n, this.myBuffer, n3, iOException);
            return bl;
        }

        public void inputFileSkip(JobBackendRef jobBackendRef, int n, long l) {
            this.myQueue.offer(new InputFileSkipInvocation(jobBackendRef, n, l));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileSkip(JobBackendRef jobBackendRef, int n, long l) throws IOException {
            long l2 = 0L;
            IOException iOException = null;
            boolean bl = false;
            try {
                l2 = this.myInputStream.skip(l);
                bl = true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                try {
                    this.myInputStream.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                Map map = FrontendFileReader.this.myFileHandlerForFFD;
                synchronized (map) {
                    FrontendFileReader.this.myFileHandlerForFFD.remove(n);
                }
            }
            jobBackendRef.inputFileSkipResult(FrontendFileReader.this.myJobFrontend, n, l2, iOException);
            return bl;
        }

        public void inputFileClose(JobBackendRef jobBackendRef, int n) {
            this.myQueue.offer(new InputFileCloseInvocation(jobBackendRef, n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
            IOException iOException = null;
            try {
                this.myInputStream.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            Map map = FrontendFileReader.this.myFileHandlerForFFD;
            synchronized (map) {
                FrontendFileReader.this.myFileHandlerForFFD.remove(n);
            }
            jobBackendRef.inputFileCloseResult(FrontendFileReader.this.myJobFrontend, n, iOException);
            return false;
        }

        private class InputFileCloseInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;

            public InputFileCloseInvocation(JobBackendRef jobBackendRef, int n) {
                this.theJobBackend = jobBackendRef;
                this.ffd = n;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeInputFileClose(this.theJobBackend, this.ffd);
            }
        }

        private class InputFileSkipInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            private long len;

            public InputFileSkipInvocation(JobBackendRef jobBackendRef, int n, long l) {
                this.theJobBackend = jobBackendRef;
                this.ffd = n;
                this.len = l;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeInputFileSkip(this.theJobBackend, this.ffd, this.len);
            }
        }

        private class InputFileReadInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            private int len;

            public InputFileReadInvocation(JobBackendRef jobBackendRef, int n, int n2) {
                this.theJobBackend = jobBackendRef;
                this.ffd = n;
                this.len = n2;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeInputFileRead(this.theJobBackend, this.ffd, this.len);
            }
        }

        private class InputFileOpenInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int bfd;
            private File file;

            public InputFileOpenInvocation(JobBackendRef jobBackendRef, int n, File file) {
                this.theJobBackend = jobBackendRef;
                this.bfd = n;
                this.file = file;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeInputFileOpen(this.theJobBackend, this.bfd, this.file);
            }
        }

        private abstract class Invocation {
            private Invocation() {
            }

            public abstract boolean invoke() throws IOException;
        }
    }
}

