/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.WorkerForLoop;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.IOException;

public abstract class WorkerIntegerForLoop
extends WorkerForLoop {
    public IntegerSchedule schedule() {
        return IntegerSchedule.runtime();
    }

    public void start() throws Exception {
    }

    public void sendTaskInput(Range range, Comm comm, int n, int n2) throws IOException {
    }

    public void receiveTaskInput(Range range, Comm comm, int n, int n2) throws IOException {
    }

    public abstract void run(int var1, int var2) throws Exception;

    public void sendTaskOutput(Range range, Comm comm, int n, int n2) throws IOException {
    }

    public void receiveTaskOutput(Range range, Comm comm, int n, int n2) throws IOException {
    }

    public void finish() throws Exception {
    }

    public int tagOffset() {
        return Integer.MIN_VALUE;
    }

    void masterExecute(Range range) throws IOException {
        IntegerSchedule integerSchedule = this.schedule();
        if (integerSchedule.isFixedSchedule()) {
            this.masterExecuteFixed(range, integerSchedule);
        } else {
            this.masterExecuteNonFixed(range, integerSchedule);
        }
    }

    void masterExecuteFixed(Range range, IntegerSchedule integerSchedule) throws IOException {
        Range range2;
        int n;
        int n2 = this.myTeam.count;
        Comm comm = this.myTeam.comm;
        integerSchedule.start(n2, range);
        for (n = 0; n < n2; ++n) {
            range2 = integerSchedule.next(n);
            if (range2 == null) continue;
            this.sendTaskInput(range2, comm, this.myTeam.workerRank(n), this.tagFor(n));
        }
        integerSchedule.start(n2, range);
        for (n = 0; n < n2; ++n) {
            range2 = integerSchedule.next(n);
            if (range2 == null) continue;
            this.receiveTaskOutput(range2, comm, this.myTeam.workerRank(n), this.tagFor(n));
        }
    }

    void masterExecuteNonFixed(Range range, IntegerSchedule integerSchedule) throws IOException {
        int n;
        int n2;
        Range range2;
        int n3 = this.myTeam.count;
        integerSchedule.start(n3, range);
        int n4 = n3;
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        Range range3 = new Range(this.tagFor(0), this.tagFor(n3 - 1));
        Comm comm = this.myTeam.comm;
        for (int i = 0; i < n3; ++i) {
            range2 = integerSchedule.next(i);
            objectItemBuf.item = range2;
            objectItemBuf.reset();
            n2 = this.myTeam.workerRank(i);
            n = this.tagFor(i);
            comm.send(n2, n, objectItemBuf);
            if (range2 == null) {
                --n4;
                continue;
            }
            this.sendTaskInput(range2, comm, n2, n);
        }
        while (n4 > 0) {
            CommStatus commStatus = comm.receive(null, range3, objectItemBuf);
            range2 = (Range)objectItemBuf.item;
            n2 = commStatus.fromRank;
            n = commStatus.tag;
            int n5 = this.workerFor(n);
            this.receiveTaskOutput(range2, comm, n2, n);
            range2 = integerSchedule.next(n5);
            objectItemBuf.item = range2;
            objectItemBuf.reset();
            comm.send(n2, n, objectItemBuf);
            if (range2 == null) {
                --n4;
                continue;
            }
            this.sendTaskInput(range2, comm, n2, n);
        }
    }

    void workerExecute(int n, Range range) throws Exception {
        IntegerSchedule integerSchedule = this.schedule();
        if (integerSchedule.isFixedSchedule()) {
            integerSchedule.start(this.myTeam.count, range);
            this.workerExecuteFixed(integerSchedule.next(n), n);
        } else {
            this.workerExecuteNonFixed(n);
        }
    }

    void workerExecuteFixed(Range range, int n) throws Exception {
        this.start();
        if (range != null) {
            Comm comm = this.myTeam.comm;
            int n2 = this.myTeam.masterRank();
            int n3 = this.tagFor(n);
            this.receiveTaskInput(range, comm, n2, n3);
            this.run(range.lb(), range.ub());
            this.sendTaskOutput(range, comm, n2, n3);
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerExecuteNonFixed(int n) throws Exception {
        Comm comm = this.myTeam.comm;
        int n2 = this.myTeam.masterRank();
        int n3 = this.tagFor(n);
        this.start();
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        while (true) {
            comm.receive((Integer)n2, n3, objectItemBuf);
            Range range = (Range)objectItemBuf.item;
            if (range == null) break;
            this.receiveTaskInput(range, comm, n2, n3);
            this.run(range.lb(), range.ub());
            WorkerTeam workerTeam = this.myTeam;
            synchronized (workerTeam) {
                comm.send(n2, n3, objectItemBuf);
                this.sendTaskOutput(range, comm, n2, n3);
            }
        }
        this.finish();
    }

    private int tagFor(int n) {
        return n + this.tagOffset();
    }

    private int workerFor(int n) {
        return n - this.tagOffset();
    }
}

