/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.NetworkChannelReceiveThread;
import edu.rit.mp.NetworkChannelSendThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;

class NetworkChannel
extends Channel {
    private SocketChannel mySocketChannel;
    private int myFarChannelGroupId;
    private LinkedBlockingQueue<IORequest> myOutgoingQueue;
    private NetworkChannelSendThread myNetworkChannelSendThread;
    private NetworkChannelReceiveThread myNetworkChannelReceiveThread;

    NetworkChannel(ChannelGroup channelGroup, SocketChannel socketChannel, int n) {
        super(channelGroup);
        this.mySocketChannel = socketChannel;
        this.myFarChannelGroupId = n;
        this.myOutgoingQueue = new LinkedBlockingQueue();
    }

    public int nearEndChannelGroupId() {
        return this.myChannelGroup.myChannelGroupId;
    }

    public int farEndChannelGroupId() {
        return this.myFarChannelGroupId;
    }

    public InetSocketAddress nearEndAddress() {
        return (InetSocketAddress)this.mySocketChannel.socket().getLocalSocketAddress();
    }

    public InetSocketAddress farEndAddress() {
        return (InetSocketAddress)this.mySocketChannel.socket().getRemoteSocketAddress();
    }

    void start() {
        this.myNetworkChannelSendThread = new NetworkChannelSendThread(this, this.mySocketChannel, this.myOutgoingQueue);
        this.myNetworkChannelReceiveThread = new NetworkChannelReceiveThread(this, this.mySocketChannel);
    }

    synchronized void send(IORequest iORequest) throws IOException {
        if (this.myWriteState == 1) {
            throw new IOException("NetworkChannel.send(): Channel closed");
        }
        this.myOutgoingQueue.add(iORequest);
    }

    void subclassClose() {
        if (this.mySocketChannel != null) {
            try {
                this.mySocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.myNetworkChannelSendThread != null) {
            this.myNetworkChannelSendThread.interrupt();
        }
        if (this.myNetworkChannelReceiveThread != null) {
            this.myNetworkChannelReceiveThread.interrupt();
        }
        this.mySocketChannel = null;
        this.myOutgoingQueue = null;
        this.myNetworkChannelSendThread = null;
        this.myNetworkChannelReceiveThread = null;
    }

    synchronized void shutdownInput() {
        this.myReadState = 1;
        this.myNetworkChannelReceiveThread = null;
    }
}

