/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.antimatter;

import edu.rit.mp.DoubleBuf;
import edu.rit.pj.BarrierAction;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Random;
import edu.rit.util.Range;
import edu.rit.vector.Vector2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class AntiprotonHyb {
    static final double QP = 3.0;
    static final double QT = 3.0;
    static final double DIAM = 2.0;
    static final double DIAM_OVER_2 = 1.0;
    static final Color BACKGROUND_COLOR = Color.black;
    static final Color ANTIPROTON_COLOR = Color.red;
    static Comm world;
    static int size;
    static int rank;
    static long seed;
    static int N;
    static double R;
    static int frames;
    static int steps;
    static double dt;
    static int W;
    static String file;
    static double onehalfdtsqr;
    static double QP_QP;
    static double QP_QT;
    static Comm p_comm;
    static int p_size;
    static int p_rank;
    static Range[] ranges;
    static Range myrange;
    static int mylb;
    static int myub;
    static int mylength;
    static Vector2D[] f;
    static Vector2D[] v;
    static Vector2D[] p;
    static DoubleBuf[] p_slices;
    static DoubleBuf myp_slice;
    static double scale;
    static Ellipse2D dot;
    static IndexColorModel colormodel;
    static BufferedImage image;
    static Graphics2D g2d;
    static StringBuilder filename;
    static ParallelTeam team;
    static ParallelRegion region;

    private AntiprotonHyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 8) {
            AntiprotonHyb.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Integer.parseInt(stringArray[1]);
        R = Double.parseDouble(stringArray[2]);
        frames = Integer.parseInt(stringArray[3]);
        steps = Integer.parseInt(stringArray[4]);
        dt = Double.parseDouble(stringArray[5]);
        W = Integer.parseInt(stringArray[6]);
        file = stringArray[7];
        onehalfdtsqr = 0.5 * dt * dt;
        QP_QP = 9.0;
        QP_QT = 9.0 * (double)N;
        p_comm = world.createComm(rank <= size - 2);
        if (rank <= size - 2) {
            AntiprotonHyb.computePositions();
        } else {
            AntiprotonHyb.computeVisualizations();
        }
        System.out.println((l += System.currentTimeMillis()) + " msec " + rank);
    }

    private static void computePositions() throws Exception {
        int n;
        p_size = p_comm.size();
        p_rank = p_comm.rank();
        Random random = Random.getInstance(seed);
        ranges = new Range(0, N - 1).subranges(p_size);
        myrange = ranges[p_rank];
        mylb = myrange.lb();
        myub = myrange.ub();
        mylength = myrange.length();
        f = new Vector2D[mylength];
        v = new Vector2D[mylength];
        for (n = 0; n < mylength; ++n) {
            AntiprotonHyb.f[n] = new Vector2D();
            AntiprotonHyb.v[n] = new Vector2D();
        }
        p = new Vector2D[N];
        for (n = 0; n < N; ++n) {
            AntiprotonHyb.p[n] = new Vector2D((0.9 * random.nextDouble() + 0.05) * R, (0.9 * random.nextDouble() + 0.05) * R);
        }
        p_slices = Vector2D.doubleSliceBuffers(p, ranges);
        myp_slice = p_slices[p_rank];
        team = new ParallelTeam();
        region = new ParallelRegion(){

            public void run() throws Exception {
                this.execute(mylb, myub, new IntegerForLoop(){

                    public void run(int n, int n2) throws Exception {
                        Vector2D vector2D;
                        Vector2D vector2D2;
                        int n3;
                        Vector2D vector2D3 = new Vector2D();
                        for (n3 = n; n3 <= n2; ++n3) {
                            double d;
                            Vector2D vector2D4;
                            int n4;
                            vector2D2 = f[n3 - mylb];
                            vector2D = p[n3];
                            for (n4 = 0; n4 < n3; ++n4) {
                                vector2D4 = p[n4];
                                vector2D3.assign(vector2D);
                                vector2D3.sub(vector2D4);
                                d = vector2D3.mag();
                                vector2D3.mul(QP_QP / (d * d * d));
                                vector2D2.add(vector2D3);
                            }
                            for (n4 = n3 + 1; n4 < N; ++n4) {
                                vector2D4 = p[n4];
                                vector2D3.assign(vector2D);
                                vector2D3.sub(vector2D4);
                                d = vector2D3.mag();
                                vector2D3.mul(QP_QP / (d * d * d));
                                vector2D2.add(vector2D3);
                            }
                        }
                        for (n3 = n; n3 <= n2; ++n3) {
                            vector2D2 = f[n3 - mylb];
                            vector2D = p[n3];
                            double d = vector2D.x;
                            double d2 = d * d;
                            double d3 = vector2D.x - R;
                            double d4 = d3 * d3;
                            double d5 = vector2D.y;
                            double d6 = d5 * d5;
                            vector2D2.x += QP_QT * (1.0 / Math.sqrt(d4 + d6) - 1.0 / Math.sqrt(d2 + d6));
                            vector2D2.y += QP_QT / d5 * (-d3 / Math.sqrt(d4 + d6) + d / Math.sqrt(d2 + d6));
                            d5 = vector2D.y - R;
                            d6 = d5 * d5;
                            vector2D2.x += QP_QT * (1.0 / Math.sqrt(d4 + d6) - 1.0 / Math.sqrt(d2 + d6));
                            vector2D2.y += QP_QT / d5 * (-d3 / Math.sqrt(d4 + d6) + d / Math.sqrt(d2 + d6));
                            double d7 = vector2D.y;
                            double d8 = d7 * d7;
                            double d9 = vector2D.y - R;
                            double d10 = d9 * d9;
                            double d11 = vector2D.x;
                            double d12 = d11 * d11;
                            vector2D2.y += QP_QT * (1.0 / Math.sqrt(d10 + d12) - 1.0 / Math.sqrt(d8 + d12));
                            vector2D2.x += QP_QT / d11 * (-d9 / Math.sqrt(d10 + d12) + d7 / Math.sqrt(d8 + d12));
                            d11 = vector2D.x - R;
                            d12 = d11 * d11;
                            vector2D2.y += QP_QT * (1.0 / Math.sqrt(d10 + d12) - 1.0 / Math.sqrt(d8 + d12));
                            vector2D2.x += QP_QT / d11 * (-d9 / Math.sqrt(d10 + d12) + d7 / Math.sqrt(d8 + d12));
                        }
                    }
                });
                this.execute(mylb, myub, new IntegerForLoop(){

                    public void run(int n, int n2) throws Exception {
                        Vector2D vector2D = new Vector2D();
                        for (int i = n; i <= n2; ++i) {
                            Vector2D vector2D2 = f[i - mylb];
                            Vector2D vector2D3 = v[i - mylb];
                            Vector2D vector2D4 = p[i];
                            vector2D.assign(vector2D3);
                            vector2D4.add(vector2D.mul(dt));
                            vector2D.assign(vector2D2);
                            vector2D4.add(vector2D.mul(onehalfdtsqr));
                            vector2D.assign(vector2D2);
                            vector2D3.add(vector2D.mul(dt));
                            vector2D2.clear();
                        }
                    }
                }, BarrierAction.NO_WAIT);
            }
        };
        world.gather(size - 1, myp_slice, null);
        for (n = 1; n <= frames; ++n) {
            for (int i = 0; i < steps; ++i) {
                team.execute(region);
                p_comm.allGather(myp_slice, p_slices);
            }
            world.gather(size - 1, myp_slice, null);
        }
    }

    private static void computeVisualizations() throws Exception {
        int n;
        p = new Vector2D[N];
        for (int i = 0; i < N; ++i) {
            AntiprotonHyb.p[i] = new Vector2D();
        }
        ranges = new Range[size];
        Range range = new Range(0, N - 1);
        for (int i = 0; i <= size - 2; ++i) {
            AntiprotonHyb.ranges[i] = range.subrange(size - 1, i);
        }
        AntiprotonHyb.ranges[AntiprotonHyb.size - 1] = new Range();
        p_slices = Vector2D.doubleSliceBuffers(p, ranges);
        myp_slice = p_slices[size - 1];
        scale = (double)W / R;
        dot = new Ellipse2D.Double();
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray[n] = (byte)n;
        }
        colormodel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        image = new BufferedImage(W, W, 13, colormodel);
        g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        for (n = 0; n <= frames; ++n) {
            world.gather(size - 1, myp_slice, p_slices);
            g2d.setColor(BACKGROUND_COLOR);
            g2d.fillRect(0, 0, W, W);
            g2d.setColor(ANTIPROTON_COLOR);
            for (int i = 0; i < N; ++i) {
                dot.setFrame(scale * AntiprotonHyb.p[i].x - 1.0, scale * AntiprotonHyb.p[i].y - 1.0, 2.0, 2.0);
                g2d.fill(dot);
            }
            filename.setLength(0);
            filename.append(n);
            while (filename.length() < 4) {
                filename.insert(0, '0');
            }
            filename.insert(0, '_');
            filename.insert(0, file);
            filename.append(".png");
            ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(new FileOutputStream(filename.toString())));
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> edu.rit.hyb.antimatter.AntiprotonHyb <seed> <N> <R> <frames> <steps> <dt> <W> <file>");
        System.err.println("<Kp> = Number of parallel processes (>= 2)");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of antiprotons");
        System.err.println("<R> = Size of antiproton trap");
        System.err.println("<frames> = Number of visualization frames");
        System.err.println("<steps> = Number of time steps per frame");
        System.err.println("<dt> = Size of time step");
        System.err.println("<W> = Size of frame, <W>x<W> pixels");
        System.err.println("<file> = Frame file names: \"<file>_0000.png\", etc.");
        System.exit(1);
    }

    static {
        filename = new StringBuilder();
    }
}

