/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.impl.InternalUtils;

public class TransitiveGraph {
    private Map<DataSource, Set<Path>> sourceMap = new HashMap<DataSource, Set<Path>>();
    private Map<DataSource, Set<Path>> targetMap = new HashMap<DataSource, Set<Path>>();

    public TransitiveGraph(List<IDMapper> gdbs) throws IDMapperException {
        Set<Path> openSet = this.getDirectPaths(gdbs);
        this.indexPaths(openSet);
        while (openSet.size() > 0) {
            openSet = this.getPathExtensions(openSet);
        }
    }

    private Set<Path> getPathExtensions(Set<Path> openSet) {
        HashSet<Path> result = new HashSet<Path>();
        Iterator<Path> i = openSet.iterator();
        while (i.hasNext()) {
            Path path = i.next();
            i.remove();
            Set<Path> extensions = this.findValidExtensions(path);
            result.addAll(extensions);
        }
        this.indexPaths(result);
        return result;
    }

    private void indexPaths(Set<Path> set) {
        for (Path p : set) {
            DataSource source = p.getSource();
            DataSource target = p.getTarget();
            InternalUtils.multiMapPut(this.sourceMap, source, p);
            InternalUtils.multiMapPut(this.targetMap, target, p);
        }
    }

    private Set<Path> findValidExtensions(Path path) {
        HashSet<Path> result = new HashSet<Path>();
        DataSource lastElement = path.getTarget();
        for (Path extension : this.sourceMap.get(lastElement)) {
            if (!extension.isLoopFreeExtension(path)) continue;
            Path newPath = new Path(path, extension);
            result.add(newPath);
        }
        return result;
    }

    public void printMap(Map<DataSource, Set<Path>> map) {
        for (DataSource ds : map.keySet()) {
            Set<Path> collection = map.get(ds);
            System.out.println("DataSource: " + ds);
            System.out.println(" - " + collection + "\n");
        }
        System.out.println();
    }

    private Set<Path> getDirectPaths(List<IDMapper> gdbs) throws IDMapperException {
        HashSet<Path> result = new HashSet<Path>();
        for (IDMapper idm : gdbs) {
            if (idm == null || !idm.isConnected()) continue;
            IDMapperCapabilities capas = idm.getCapabilities();
            for (DataSource src : capas.getSupportedSrcDataSources()) {
                for (DataSource tgt : capas.getSupportedTgtDataSources()) {
                    if (!capas.isMappingSupported(src, tgt) || src == tgt) continue;
                    Edge edge = new Edge(src, tgt, idm);
                    Path path = new Path(edge);
                    result.add(path);
                }
            }
        }
        return result;
    }

    public boolean isTransitiveMappingSupported(DataSource src, DataSource tgt) throws IDMapperException {
        if (!this.sourceMap.containsKey(src) || !this.targetMap.containsKey(tgt)) {
            return false;
        }
        for (Path path : this.sourceMap.get(src)) {
            if (path.getTarget() != tgt) continue;
            return true;
        }
        return false;
    }

    public Set<Xref> mapIDtransitiveTargetted(Xref ref, Set<DataSource> dsFilter) throws IDMapperException {
        DataSource srcDs = ref.getDataSource();
        HashSet<Xref> result = new HashSet<Xref>();
        for (DataSource tgtDs : this.targetMap.keySet()) {
            for (Path path : this.targetMap.get(tgtDs)) {
                DataSource pathSource = path.getSource();
                DataSource pathTarget = path.getTarget();
                if (pathSource != srcDs || tgtDs != pathTarget || !dsFilter.contains(pathTarget)) continue;
                for (Xref j : this.mapID(ref, path)) {
                    if (!dsFilter.contains(j.getDataSource())) continue;
                    result.add(j);
                }
            }
        }
        return result;
    }

    public Set<Xref> mapIDtransitiveUntargetted(Xref ref) throws IDMapperException {
        HashSet<Xref> result = new HashSet<Xref>();
        DataSource dataSource = ref.getDataSource();
        if (!this.sourceMap.containsKey(dataSource)) {
            return result;
        }
        for (Path path : this.sourceMap.get(dataSource)) {
            if (path.size() <= 0) continue;
            for (Xref j : this.mapID(ref, path)) {
                result.add(j);
            }
        }
        return result;
    }

    private Set<Xref> mapID(Xref xref, Path path) throws IDMapperException {
        Set<Xref> result = new HashSet<Xref>();
        if (path == null || path.size() <= 0) {
            return result;
        }
        Edge e = path.get(0);
        result = e.label.mapID(xref, e.target);
        for (int i = 1; i < path.size(); ++i) {
            e = path.get(i);
            if (e == null || e.source == null || e.target == null || e.label == null) {
                throw new IDMapperException();
            }
            if (!e.label.isConnected()) {
                return new HashSet<Xref>();
            }
            Map<Xref, Set<Xref>> tmp = e.label.mapID(result, e.target);
            result.clear();
            for (Xref key : tmp.keySet()) {
                result.addAll((Collection<Xref>)tmp.get(key));
            }
        }
        return result;
    }

    private class Path {
        private final List<Edge> delegate = new ArrayList<Edge>();
        private final Set<IDMapper> mappers = new HashSet<IDMapper>();

        Path(Edge first) {
            this.delegate.add(first);
            this.mappers.add(first.label);
        }

        Path(Path p, Path q) {
            this.delegate.addAll(p.delegate);
            this.delegate.addAll(q.delegate);
            for (Edge e : p.delegate) {
                this.mappers.add(e.label);
            }
            for (Edge e : q.delegate) {
                this.mappers.add(e.label);
            }
        }

        public DataSource getSource() {
            return this.delegate.get((int)0).source;
        }

        public DataSource getTarget() {
            return this.delegate.get((int)(this.delegate.size() - 1)).target;
        }

        protected boolean isLoopFreeExtension(Path other) {
            for (IDMapper m : other.mappers) {
                if (!this.mappers.contains(m)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String returnValue = "";
            if (!this.delegate.isEmpty()) {
                returnValue = returnValue + this.get((int)0).source;
            }
            for (Edge e : this.delegate) {
                returnValue = returnValue + e;
            }
            return returnValue;
        }

        public int hashCode() {
            int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31};
            int result = 0;
            for (int i = 0; i < this.size(); ++i) {
                result += primes[i % primes.length] * this.get(i).hashCode();
            }
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Path)) {
                return false;
            }
            Path path = (Path)other;
            if (this.size() != path.size()) {
                return false;
            }
            boolean returnValue = true;
            for (int i = 0; i < this.size(); ++i) {
                Edge myEdge = this.get(i);
                Edge otherEdge = path.get(i);
                if (myEdge.source == otherEdge.source && myEdge.target == otherEdge.target && myEdge.label == otherEdge.label) continue;
                returnValue = false;
                break;
            }
            return returnValue;
        }

        private Edge get(int i) {
            return this.delegate.get(i);
        }

        private int size() {
            return this.delegate.size();
        }
    }

    private class Edge {
        public DataSource source;
        public DataSource target;
        public IDMapper label;

        public Edge(DataSource source, DataSource target, IDMapper label) {
            this.source = source;
            this.target = target;
            this.label = label;
        }

        public String toString() {
            return " -> " + this.target;
        }

        public int hashCode() {
            return 3 * (this.source.hashCode() + this.target.hashCode()) + 5 * this.label.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge e = (Edge)o;
            return this.label == e.label && this.source == e.source && this.target == e.target || this.label == e.label && this.source == e.target && this.target == e.source;
        }
    }
}

