/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.EmbedConnection;

abstract class ConnectionChild {
    EmbedConnection localConn;
    private LanguageConnectionContext lcc;
    final InternalDriver factory;
    private Calendar cal;

    ConnectionChild(EmbedConnection embedConnection) {
        this.localConn = embedConnection;
        this.factory = embedConnection.getLocalDriver();
    }

    final EmbedConnection getEmbedConnection() {
        return this.localConn;
    }

    final Object getConnectionSynchronization() {
        return this.localConn.getConnectionSynchronization();
    }

    final SQLException handleException(Throwable throwable) throws SQLException {
        return this.localConn.handleException(throwable);
    }

    final void needCommit() {
        this.localConn.needCommit();
    }

    final void commitIfNeeded() throws SQLException {
        this.localConn.commitIfNeeded();
    }

    final void commitIfAutoCommit() throws SQLException {
        this.localConn.commitIfAutoCommit();
    }

    final void setupContextStack() throws SQLException {
        this.localConn.setupContextStack();
    }

    final void restoreContextStack() throws SQLException {
        this.localConn.restoreContextStack();
    }

    Calendar getCal() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    static SQLException newSQLException(String string, Object ... objectArray) {
        return EmbedConnection.newSQLException(string, objectArray);
    }

    protected static void restoreIntrFlagIfSeen(boolean bl, EmbedConnection embedConnection) {
        if (bl) {
            InterruptStatus.restoreIntrFlagIfSeen(ConnectionChild.getLCC(embedConnection));
        } else {
            InterruptStatus.restoreIntrFlagIfSeen();
        }
    }

    LanguageConnectionContext getLanguageConnectionContext(EmbedConnection embedConnection) {
        if (this.lcc == null) {
            this.lcc = ConnectionChild.getLCC(embedConnection);
        }
        return this.lcc;
    }

    static LanguageConnectionContext getLCC(final EmbedConnection embedConnection) {
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return embedConnection.getLanguageConnection();
            }
        });
    }
}

