/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.shared.common.error.StandardException;

public class PermDescriptor
extends PermissionsDescriptor
implements Provider {
    public static final String SEQUENCE_TYPE = "SEQUENCE";
    public static final String UDT_TYPE = "TYPE";
    public static final String AGGREGATE_TYPE = "DERBY AGGREGATE";
    public static final String USAGE_PRIV = "USAGE";
    private String objectType;
    private UUID permObjectId;
    private String permission;
    private boolean grantable;

    public PermDescriptor(DataDictionary dataDictionary, UUID uUID, String string, UUID uUID2, String string2, String string3, String string4, boolean bl) {
        super(dataDictionary, string4, string3);
        this.setUUID(uUID);
        this.objectType = string;
        this.permObjectId = uUID2;
        this.permission = string2;
        this.grantable = bl;
    }

    public PermDescriptor(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        this(dataDictionary, uUID, null, null, null, null, null, false);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public UUID getPermObjectId() {
        return this.permObjectId;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isGrantable() {
        return this.grantable;
    }

    @Override
    public int getCatalogNumber() {
        return 21;
    }

    public String toString() {
        return "";
    }

    public boolean equals(Object object) {
        if (!(object instanceof PermDescriptor)) {
            return false;
        }
        PermDescriptor permDescriptor = (PermDescriptor)object;
        return super.keyEquals(permDescriptor) && this.permObjectId.equals(permDescriptor.permObjectId);
    }

    public int hashCode() {
        return super.keyHashCode() + this.permObjectId.hashCode();
    }

    @Override
    public boolean checkOwner(String string) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        PrivilegedSQLObject privilegedSQLObject = PermDescriptor.getProtectedObject(dataDictionary, this.permObjectId, this.objectType);
        return privilegedSQLObject.getSchemaDescriptor().getAuthorizationId().equals(string);
    }

    public static PrivilegedSQLObject getProtectedObject(DataDictionary dataDictionary, UUID uUID, String string) throws StandardException {
        if (SEQUENCE_TYPE.equals(string)) {
            return dataDictionary.getSequenceDescriptor(uUID);
        }
        if (AGGREGATE_TYPE.equals(string)) {
            return dataDictionary.getAliasDescriptor(uUID);
        }
        if (UDT_TYPE.equals(string)) {
            return dataDictionary.getAliasDescriptor(uUID);
        }
        throw StandardException.newException((String)"XSCB3.S", (Object[])new Object[0]);
    }

    @Override
    public String getObjectName() {
        try {
            DataDictionary dataDictionary = this.getDataDictionary();
            PrivilegedSQLObject privilegedSQLObject = PermDescriptor.getProtectedObject(dataDictionary, this.permObjectId, this.objectType);
            return privilegedSQLObject.getName();
        }
        catch (StandardException standardException) {
            return this.objectType;
        }
    }

    @Override
    public String getClassType() {
        return "Perm";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(473);
    }
}

