/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.NoSuchElementException;
import org.biojava.stats.svm.SVMKernel;

public class SVMRegressionModel {
    private SVMKernel kernel;
    private double threshold;
    private double[][] kvals;
    private Object[] vectors;
    private double[] alphas;
    private double[] alphaStars;
    private int size;

    public SVMRegressionModel() {
        this(100);
    }

    public SVMRegressionModel(int n) {
        this.vectors = new Object[n];
        this.alphas = new double[n];
        this.alphaStars = new double[n];
        this.size = 0;
    }

    public void addVector(Object object) {
        this.addVector(object, 0.0, 0.0);
    }

    public void addVector(Object object, double d, double d2) {
        if (this.size + 1 >= this.vectors.length) {
            Object[] objectArray = new Object[this.vectors.length * 2];
            System.arraycopy(this.vectors, 0, objectArray, 0, this.size);
            this.vectors = objectArray;
            double[] dArray = new double[this.alphas.length * 2];
            System.arraycopy(this.alphas, 0, dArray, 0, this.size);
            this.alphas = dArray;
            double[] dArray2 = new double[this.alphaStars.length * 2];
            System.arraycopy(this.alphaStars, 0, dArray2, 0, this.size);
        }
        this.vectors[this.size] = object;
        this.alphas[this.size] = d;
        this.alphaStars[this.size] = d2;
        ++this.size;
    }

    public void calcKernel() {
        this.kvals = new double[this.size][this.size];
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < n) {
                double d = this.kernel.evaluate(this.vectors[n], this.vectors[n2]);
                this.kvals[n2][n] = d;
                this.kvals[n][n2] = d;
                ++n2;
            }
            this.kvals[n][n] = this.kernel.evaluate(this.vectors[n], this.vectors[n]);
            System.out.print(".");
            ++n;
        }
    }

    public double classify(Object object) {
        double d = 0.0;
        int n = 0;
        while (n < this.size) {
            double d2 = this.alphas[n] - this.alphaStars[n];
            if (d2 != 0.0) {
                d += d2 * this.kernel.evaluate(this.vectors[n], object);
            }
            ++n;
        }
        return d + this.threshold;
    }

    public double getAlpha(int n) {
        if (n >= this.size) {
            throw new NoSuchElementException();
        }
        System.out.println("retrieving alpha " + n + "=" + this.alphas[n]);
        return this.alphas[n];
    }

    public double getAlphaStar(int n) {
        if (n >= this.size) {
            throw new NoSuchElementException();
        }
        System.out.println("retrieving alpha* " + n + "=" + this.alphaStars[n]);
        return this.alphaStars[n];
    }

    public SVMKernel getKernel() {
        return this.kernel;
    }

    public double getKernelValue(int n, int n2) {
        return this.kvals[n][n2];
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Object getVector(int n) {
        if (n >= this.size) {
            throw new NoSuchElementException();
        }
        return this.vectors[n];
    }

    public double internalClassify(int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.size) {
            double d2 = this.alphas[n2] - this.alphaStars[n2];
            d += d2 * this.kvals[n2][n];
            ++n2;
        }
        return d + this.threshold;
    }

    public void setAlpha(int n, double d) {
        if (n >= this.size) {
            throw new NoSuchElementException();
        }
        this.alphas[n] = d;
        System.out.println("setting alpha " + n + "=" + this.alphas[n]);
    }

    public void setAlphaStar(int n, double d) {
        if (n >= this.size) {
            throw new NoSuchElementException();
        }
        this.alphaStars[n] = d;
        System.out.println("setting alpha* " + n + "=" + this.alphaStars[n]);
    }

    public void setKernel(SVMKernel sVMKernel) {
        this.kernel = sVMKernel;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public int size() {
        return this.size;
    }
}

