/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.ScopeFilter;
import org.apache.derby.iapi.sql.compile.VisitableFilter;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class DeleteNode
extends DMLModStatementNode {
    private static final String COLUMNNAME = "###RowLocationToDelete";
    private boolean deferred;
    private FromTable targetTable;
    private FormatableBitSet readColsBitSet;
    private ConstantAction[] dependentConstantActions;
    private boolean cascadeDelete;
    private StatementNode[] dependentNodes;

    DeleteNode(TableName tableName, ResultSetNode resultSetNode, MatchingClauseNode matchingClauseNode, ContextManager contextManager) {
        super(resultSetNode, matchingClauseNode, contextManager);
        this.targetTableName = tableName;
    }

    @Override
    String statementToString() {
        return "DELETE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(0);
        try {
            int n;
            Object object;
            FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            ResultColumn resultColumn = null;
            TableName tableName = null;
            CurrentOfNode currentOfNode = null;
            IgnoreFilter ignoreFilter = new IgnoreFilter();
            this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
            DataDictionary dataDictionary = this.getDataDictionary();
            if (!this.inMatchingClause()) {
                super.bindTables(dataDictionary);
            }
            SelectNode selectNode = (SelectNode)this.resultSet;
            this.targetTable = (FromTable)selectNode.fromList.elementAt(0);
            if (this.targetTable instanceof CurrentOfNode) {
                currentOfNode = (CurrentOfNode)this.targetTable;
                TableName tableName2 = tableName = this.inMatchingClause() ? this.targetTableName : currentOfNode.getBaseCursorTargetTableName();
            }
            if (this.targetTable instanceof FromVTI) {
                this.targetVTI = (FromVTI)this.targetTable;
                this.targetVTI.setTarget();
            } else if (this.targetTableName == null) {
                this.targetTableName = tableName;
            } else if (tableName != null && !this.targetTableName.equals(tableName)) {
                throw StandardException.newException((String)"42X28", (Object[])new Object[]{this.targetTableName, currentOfNode.getCursorName()});
            }
            this.verifyTargetTable();
            if (this.targetTable instanceof FromVTI) {
                this.getResultColumnList();
                this.resultColumnList = this.targetTable.getResultColumnsForList(null, this.resultColumnList, null);
                this.resultSet.setResultColumns(this.resultColumnList);
            } else {
                int n2;
                this.resultColumnList = new ResultColumnList(this.getContextManager());
                object = this.getResultColumnList(this.resultColumnList);
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor);
                this.resultColumnList = ((FromBaseTable)object).addColsToList(this.resultColumnList, this.readColsBitSet);
                n = this.targetTableDescriptor.getMaxColumnID();
                for (n2 = 1; n2 <= n && this.readColsBitSet.get(n2); ++n2) {
                }
                if (n2 > n) {
                    this.readColsBitSet = null;
                }
                CurrentRowLocationNode currentRowLocationNode = new CurrentRowLocationNode(this.getContextManager());
                resultColumn = new ResultColumn(COLUMNNAME, (ValueNode)currentRowLocationNode, this.getContextManager());
                resultColumn.markGenerated();
                this.resultColumnList.addResultColumn(resultColumn);
                this.correlateAddedColumns(this.resultColumnList, this.targetTable);
                ResultColumnList resultColumnList = this.resultSet.getResultColumns();
                if (resultColumnList != null) {
                    resultColumnList.appendResultColumns(this.resultColumnList, false);
                    this.resultColumnList = resultColumnList;
                }
                this.resultSet.setResultColumns(this.resultColumnList);
            }
            this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
            object = new ScopeFilter(this.getCompilerContext(), "whereScope", 1);
            this.getCompilerContext().addPrivilegeFilter((VisitableFilter)object);
            super.bindExpressions();
            this.getCompilerContext().removePrivilegeFilter((VisitableFilter)object);
            this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
            if (!(this.targetTable instanceof FromVTI)) {
                resultColumn.bindResultColumnToExpression();
                this.bindConstraints(dataDictionary, this.getOptimizerFactory(), this.targetTableDescriptor, null, this.resultColumnList, null, this.readColsBitSet, true, new boolean[1]);
                if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                    this.deferred = true;
                }
            } else {
                this.deferred = VTIDeferModPolicy.deferIt(3, this.targetVTI, null, selectNode.getWhereClause());
            }
            if (this.fkTableNames != null) {
                String string = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                if (!this.isDependentTable) {
                    this.dependentTables = new HashSet();
                }
                if (this.dependentTables.add(string)) {
                    this.cascadeDelete = true;
                    n = this.fkTableNames.length;
                    this.dependentNodes = new StatementNode[n];
                    for (int i = 0; i < n; ++i) {
                        this.dependentNodes[i] = this.getDependentTableNode(this.fkSchemaNames[i], this.fkTableNames[i], this.fkRefActions[i], this.fkColDescriptors[i]);
                        this.dependentNodes[i].bindStatement();
                    }
                }
            } else if (this.isDependentTable) {
                String string = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                this.dependentTables.add(string);
            }
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
            this.getCompilerContext().popCurrentPrivType();
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
    }

    @Override
    int getPrivType() {
        return 4;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            int n = this.resultSet.updateTargetLockMode();
            long l = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
            for (int i = 0; i < staticCompiledOpenConglomInfoArray.length; ++i) {
                staticCompiledOpenConglomInfoArray[i] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[i]);
            }
            if (this.targetTableDescriptor.getLockGranularity() == 'T') {
                n = 7;
            }
            ResultDescription resultDescription = null;
            if (this.isDependentTable) {
                resultDescription = this.makeResultDescription();
            }
            return this.getGenericConstantActionFactory().getDeleteConstantAction(l, this.targetTableDescriptor.getTableType(), transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.deferred, false, this.targetTableDescriptor.getUUID(), n, null, null, null, 0L, null, null, resultDescription, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), DeleteNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), null, this.resultSet.isOneRowResultSet(), this.dependentConstantActions, this.inMatchingClause());
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(3, this.deferred);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        String string;
        int n2;
        String string2;
        this.generateCodeForTemporaryTable(activationClassBuilder);
        if (!this.isDependentTable) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.newRowLocationScanResultSetName();
        if (this.inMatchingClause()) {
            this.matchingClause.generateResultSetField(activationClassBuilder, methodBuilder);
        } else {
            this.resultSet.generate(activationClassBuilder, methodBuilder);
        }
        if (this.targetTableDescriptor != null) {
            activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", activationClassBuilder.getRowLocationScanResultSetName());
            if (this.cascadeDelete || this.isDependentTable) {
                string2 = "getDeleteCascadeResultSet";
                n2 = 4;
            } else {
                string2 = "getDeleteResultSet";
                n2 = 1;
            }
        } else {
            n2 = 1;
            string2 = "getDeleteVTIResultSet";
        }
        if (this.isDependentTable) {
            methodBuilder.push(activationClassBuilder.addItem(this.makeConstantAction()));
        } else if (this.cascadeDelete) {
            methodBuilder.push(-1);
        }
        String string3 = "org.apache.derby.iapi.sql.ResultSet[]";
        if (this.cascadeDelete) {
            string = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            LocalField localField = activationClassBuilder.newFieldDeclaration(2, string3);
            methodBuilder.pushNewArray("org.apache.derby.iapi.sql.ResultSet", this.dependentNodes.length);
            methodBuilder.setField(localField);
            for (int i = 0; i < this.dependentNodes.length; ++i) {
                this.dependentNodes[i].setRefActionInfo(this.fkIndexConglomNumbers[i], this.fkColArrays[i], string, true);
                methodBuilder.getField(localField);
                if (methodBuilder.statementNumHitLimit(10)) {
                    MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun("org.apache.derby.iapi.sql.ResultSet", 2);
                    this.dependentNodes[i].generate(activationClassBuilder, methodBuilder2);
                    methodBuilder2.methodReturn();
                    methodBuilder2.complete();
                    methodBuilder.pushThis();
                    methodBuilder.callMethod((short)182, null, methodBuilder2.getName(), "org.apache.derby.iapi.sql.ResultSet", 0);
                } else {
                    this.dependentNodes[i].generate(activationClassBuilder, methodBuilder);
                }
                methodBuilder.setArrayElement(i);
            }
            methodBuilder.getField(localField);
        } else if (this.isDependentTable) {
            methodBuilder.pushNull(string3);
        }
        if (this.cascadeDelete || this.isDependentTable) {
            string = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            methodBuilder.push(string);
        }
        methodBuilder.callMethod((short)185, null, string2, "org.apache.derby.iapi.sql.ResultSet", n2);
        if (!this.isDependentTable && this.cascadeDelete && (n = activationClassBuilder.getRowCount()) > 0) {
            MethodBuilder methodBuilder3 = activationClassBuilder.getConstructor();
            methodBuilder3.pushThis();
            methodBuilder3.pushNewArray("org.apache.derby.iapi.sql.execute.CursorResultSet", n);
            methodBuilder3.putField("org.apache.derby.impl.sql.execute.BaseActivation", "raParentResultSets", "org.apache.derby.iapi.sql.execute.CursorResultSet[]");
            methodBuilder3.endStatement();
        }
    }

    @Override
    protected final int getStatementType() {
        return 4;
    }

    public FormatableBitSet getReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        boolean[] blArray = new boolean[]{this.requiresDeferredProcessing()};
        ArrayList<ConglomerateDescriptor> arrayList = new ArrayList<ConglomerateDescriptor>();
        this.relevantTriggers = new TriggerDescriptorList();
        FormatableBitSet formatableBitSet = DeleteNode.getDeleteReadMap(tableDescriptor, arrayList, this.relevantTriggers, blArray);
        this.markAffectedIndexes(arrayList);
        this.adjustDeferredFlag(blArray[0]);
        return formatableBitSet;
    }

    private StatementNode getDependentTableNode(String string, String string2, int n, ColumnDescriptorList columnDescriptorList) throws StandardException {
        DMLModStatementNode dMLModStatementNode = null;
        if (n == 0) {
            dMLModStatementNode = this.getEmptyDeleteNode(string, string2);
        }
        if (n == 3) {
            dMLModStatementNode = this.getEmptyUpdateNode(string, string2, columnDescriptorList);
        }
        if (dMLModStatementNode != null) {
            dMLModStatementNode.isDependentTable = true;
            dMLModStatementNode.dependentTables = this.dependentTables;
        }
        return dMLModStatementNode;
    }

    private DeleteNode getEmptyDeleteNode(String string, String string2) throws StandardException {
        ValueNode valueNode = null;
        TableName tableName = new TableName(string, string2, this.getContextManager());
        FromList fromList = new FromList(this.getContextManager());
        FromBaseTable fromBaseTable = new FromBaseTable(tableName, null, 2, null, this.getContextManager());
        FormatableProperties formatableProperties = new FormatableProperties();
        formatableProperties.put("index", "null");
        fromBaseTable.setTableProperties(formatableProperties);
        fromList.addFromTable(fromBaseTable);
        SelectNode selectNode = new SelectNode(null, fromList, valueNode, null, null, null, null, this.getContextManager());
        return new DeleteNode(tableName, selectNode, null, this.getContextManager());
    }

    private UpdateNode getEmptyUpdateNode(String string, String string2, ColumnDescriptorList columnDescriptorList) throws StandardException {
        ValueNode valueNode = null;
        TableName tableName = new TableName(string, string2, this.getContextManager());
        FromList fromList = new FromList(this.getContextManager());
        FromBaseTable fromBaseTable = new FromBaseTable(tableName, null, 2, null, this.getContextManager());
        FormatableProperties formatableProperties = new FormatableProperties();
        formatableProperties.put("index", "null");
        fromBaseTable.setTableProperties(formatableProperties);
        fromList.addFromTable(fromBaseTable);
        SelectNode selectNode = new SelectNode(this.getSetClause(columnDescriptorList), fromList, valueNode, null, null, null, null, this.getContextManager());
        return new UpdateNode(tableName, selectNode, null, this.getContextManager());
    }

    private ResultColumnList getSetClause(ColumnDescriptorList columnDescriptorList) throws StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        UntypedNullConstantNode untypedNullConstantNode = new UntypedNullConstantNode(this.getContextManager());
        for (int i = 0; i < columnDescriptorList.size(); ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            if (!columnDescriptor.getType().isNullable()) continue;
            ResultColumn resultColumn = new ResultColumn(columnDescriptor, (ValueNode)untypedNullConstantNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        IgnoreFilter ignoreFilter = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
        if (this.cascadeDelete) {
            for (int i = 0; i < this.dependentNodes.length; ++i) {
                this.dependentNodes[i].optimizeStatement();
            }
        }
        super.optimizeStatement();
        this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
    }

    private static FormatableBitSet getDeleteReadMap(TableDescriptor tableDescriptor, List<ConglomerateDescriptor> list, TriggerDescriptorList triggerDescriptorList, boolean[] blArray) throws StandardException {
        int n = tableDescriptor.getMaxColumnID();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n + 1);
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, null, formatableBitSet, list);
        tableDescriptor.getAllRelevantTriggers(4, null, triggerDescriptorList);
        if (triggerDescriptorList.size() > 0) {
            blArray[0] = true;
            boolean bl = false;
            for (TriggerDescriptor triggerDescriptor : triggerDescriptorList) {
                if (!triggerDescriptor.getReferencingNew() && !triggerDescriptor.getReferencingOld()) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (int i = 1; i <= n; ++i) {
                    formatableBitSet.set(i);
                }
            }
        }
        return formatableBitSet;
    }

    private void correlateAddedColumns(ResultColumnList resultColumnList, FromTable fromTable) throws StandardException {
        String string = fromTable.getCorrelationName();
        if (string == null) {
            return;
        }
        TableName tableName = this.makeTableName(null, string);
        for (ResultColumn resultColumn : resultColumnList) {
            ValueNode valueNode = resultColumn.getExpression();
            if (valueNode == null || !(valueNode instanceof ColumnReference)) continue;
            ColumnReference columnReference = (ColumnReference)valueNode;
            columnReference.setQualifiedTableName(tableName);
        }
    }
}

