## ----deps, message=FALSE, warning=FALSE---------------------------------------
library(VisiumIO)
library(OSTA.data)
library(DropletUtils)
library(SpatialExperimentIO)

## ----list---------------------------------------------------------------------
OSTA.data_list()

## ----load---------------------------------------------------------------------
id <- "Xenium_HumanColon_Oliveira"
pa <- OSTA.data_load(id)
basename(pa)

## ----uzip---------------------------------------------------------------------
# create temporary directory
dir.create(td <- tempfile())
unzip(pa, exdir=td) # unzip
list.files(td) # list files

## ----xen----------------------------------------------------------------------
(spe <- readXeniumSXE(td))

## ----cos----------------------------------------------------------------------
# retrieval
id <- "CosMx1k_MouseBrain1"
pa <- OSTA.data_load(id, mol=FALSE)
dir.create(td <- tempfile())
unzip(pa, exdir=td)
# importing
(spe <- readCosmxSXE(td, addTx=FALSE))

## ----vis----------------------------------------------------------------------
# retrieval
id <- "Visium_HumanColon_Oliveira"
pa <- OSTA.data_load(id)
dir.create(td <- tempfile())
unzip(pa, exdir=td)
# importing
obj <- TENxVisium(
    spacerangerOut=td, 
    images="lowres", 
    format="h5")
(spe <- import(obj))

## ----vhd----------------------------------------------------------------------
# retrieval
id <- "VisiumHD_HumanColon_Oliveira"
pa <- OSTA.data_load(id)
dir.create(td <- tempfile())
unzip(pa, exdir=td)
# importing
obj <- TENxVisiumHD(
    spacerangerOut=td, 
    images="lowres", 
    format="h5")
(spe <- import(obj))

## ----sce----------------------------------------------------------------------
# retrieval
id <- "Chromium_HumanBreast_Janesick"
pa <- OSTA.data_load(id)
dir.create(td <- tempfile())
unzip(pa, exdir=td)
# importing
h5 <- list.files(td, "h5$", full.names=TRUE)
(sce <- read10xCounts(h5))

## ----si-----------------------------------------------------------------------
sessionInfo()

