/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleLatex
implements Command {
    private static final Pattern2 pattern = Pattern2.cmpile("^(\\<latex\\>(.+?)\\</latex\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleLatex() {
    }

    public static Command create() {
        return new CommandCreoleLatex();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String latex = m.group(2);
        stripe.addMath(ScientificEquationSafe.fromLatex(latex));
        return line.substring(m.group(1).length());
    }
}

