﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sesv2/SESV2_EXPORTS.h>
#include <aws/sesv2/model/Tag.h>
#include <aws/sesv2/model/Topic.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SESV2 {
namespace Model {
class GetContactListResult {
 public:
  AWS_SESV2_API GetContactListResult() = default;
  AWS_SESV2_API GetContactListResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SESV2_API GetContactListResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the contact list.</p>
   */
  inline const Aws::String& GetContactListName() const { return m_contactListName; }
  template <typename ContactListNameT = Aws::String>
  void SetContactListName(ContactListNameT&& value) {
    m_contactListNameHasBeenSet = true;
    m_contactListName = std::forward<ContactListNameT>(value);
  }
  template <typename ContactListNameT = Aws::String>
  GetContactListResult& WithContactListName(ContactListNameT&& value) {
    SetContactListName(std::forward<ContactListNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An interest group, theme, or label within a list. A contact list can have
   * multiple topics.</p>
   */
  inline const Aws::Vector<Topic>& GetTopics() const { return m_topics; }
  template <typename TopicsT = Aws::Vector<Topic>>
  void SetTopics(TopicsT&& value) {
    m_topicsHasBeenSet = true;
    m_topics = std::forward<TopicsT>(value);
  }
  template <typename TopicsT = Aws::Vector<Topic>>
  GetContactListResult& WithTopics(TopicsT&& value) {
    SetTopics(std::forward<TopicsT>(value));
    return *this;
  }
  template <typename TopicsT = Topic>
  GetContactListResult& AddTopics(TopicsT&& value) {
    m_topicsHasBeenSet = true;
    m_topics.emplace_back(std::forward<TopicsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of what the contact list is about.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetContactListResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp noting when the contact list was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTimestamp() const { return m_createdTimestamp; }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  void SetCreatedTimestamp(CreatedTimestampT&& value) {
    m_createdTimestampHasBeenSet = true;
    m_createdTimestamp = std::forward<CreatedTimestampT>(value);
  }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  GetContactListResult& WithCreatedTimestamp(CreatedTimestampT&& value) {
    SetCreatedTimestamp(std::forward<CreatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp noting the last time the contact list was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedTimestamp() const { return m_lastUpdatedTimestamp; }
  template <typename LastUpdatedTimestampT = Aws::Utils::DateTime>
  void SetLastUpdatedTimestamp(LastUpdatedTimestampT&& value) {
    m_lastUpdatedTimestampHasBeenSet = true;
    m_lastUpdatedTimestamp = std::forward<LastUpdatedTimestampT>(value);
  }
  template <typename LastUpdatedTimestampT = Aws::Utils::DateTime>
  GetContactListResult& WithLastUpdatedTimestamp(LastUpdatedTimestampT&& value) {
    SetLastUpdatedTimestamp(std::forward<LastUpdatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags associated with a contact list.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  GetContactListResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  GetContactListResult& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetContactListResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_contactListName;

  Aws::Vector<Topic> m_topics;

  Aws::String m_description;

  Aws::Utils::DateTime m_createdTimestamp{};

  Aws::Utils::DateTime m_lastUpdatedTimestamp{};

  Aws::Vector<Tag> m_tags;

  Aws::String m_requestId;
  bool m_contactListNameHasBeenSet = false;
  bool m_topicsHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_createdTimestampHasBeenSet = false;
  bool m_lastUpdatedTimestampHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SESV2
}  // namespace Aws
