﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/evidently/CloudWatchEvidently_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchEvidently {
namespace Model {

/**
 * <p>A structure that defines one treatment in an experiment. A treatment is a
 * variation of the feature that you are including in the experiment.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/TreatmentConfig">AWS
 * API Reference</a></p>
 */
class TreatmentConfig {
 public:
  AWS_CLOUDWATCHEVIDENTLY_API TreatmentConfig() = default;
  AWS_CLOUDWATCHEVIDENTLY_API TreatmentConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVIDENTLY_API TreatmentConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVIDENTLY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A description for this treatment.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  TreatmentConfig& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The feature that this experiment is testing.</p>
   */
  inline const Aws::String& GetFeature() const { return m_feature; }
  inline bool FeatureHasBeenSet() const { return m_featureHasBeenSet; }
  template <typename FeatureT = Aws::String>
  void SetFeature(FeatureT&& value) {
    m_featureHasBeenSet = true;
    m_feature = std::forward<FeatureT>(value);
  }
  template <typename FeatureT = Aws::String>
  TreatmentConfig& WithFeature(FeatureT&& value) {
    SetFeature(std::forward<FeatureT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A name for this treatment.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  TreatmentConfig& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the variation to use as this treatment in the experiment.</p>
   */
  inline const Aws::String& GetVariation() const { return m_variation; }
  inline bool VariationHasBeenSet() const { return m_variationHasBeenSet; }
  template <typename VariationT = Aws::String>
  void SetVariation(VariationT&& value) {
    m_variationHasBeenSet = true;
    m_variation = std::forward<VariationT>(value);
  }
  template <typename VariationT = Aws::String>
  TreatmentConfig& WithVariation(VariationT&& value) {
    SetVariation(std::forward<VariationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  Aws::String m_feature;

  Aws::String m_name;

  Aws::String m_variation;
  bool m_descriptionHasBeenSet = false;
  bool m_featureHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_variationHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchEvidently
}  // namespace Aws
