'''OpenGL extension ANGLE.pack_reverse_row_order

This module customises the behaviour of the 
OpenGL.raw.GLES2.ANGLE.pack_reverse_row_order to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces a mechanism to allow reversing the order
	in which image rows are written into a pack destination. This
	effectively allows an application to flip the results of a ReadPixels
	in the y direction operation without having to render upside down.
	
	The coordinate system of OpenGL is vertically reversed in comparison to a
	number of other graphics systems such as native windowing APIs. Applications
	that perform ReadPixels may have to either render to an intermediate color
	buffer before calling ReadPixels or perform a flip in software after
	ReadPixels. In some systems the GL can perform the row reversal during
	ReadPixels without incurring additional cost.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ANGLE/pack_reverse_row_order.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.ANGLE.pack_reverse_row_order import *
from OpenGL.raw.GLES2.ANGLE.pack_reverse_row_order import _EXTENSION_NAME

def glInitPackReverseRowOrderANGLE():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION