searchState.loadedDescShard("kernel", 0, "The <code>kernel</code> crate.\nA module that is pinned and initialised in-place.\nThe top level entrypoint to implementing a kernel module.\nMetadata attached to a <code>Module</code> or <code>InPlaceModule</code>.\nThe name of the module as specified in the <code>module!</code> macro.\nEquivalent to <code>THIS_MODULE</code> in the C API.\nImplementation of the kernel’s memory allocation …\nAccess the raw pointer for this module.\nWrapper around <code>asm!</code> configured for use in the kernel.\nAbstractions for the auxiliary bus.\nCreate a auxiliary <code>IdTable</code> with its alias for modpost.\nCreates a new <code>BStr</code> from a string literal.\nTypes for working with the block layer.\nAsserts that a boolean expression is <code>true</code> at compile time.\nFails the build if the code path calling <code>build_error!</code> can …\nCreates a new <code>CStr</code> from a string literal.\nClock abstractions.\nconfigfs interface: Userspace-driven Kernel Object …\nDefine a list of configfs attributes statically.\nProduces a pointer to an object from a pointer to one of …\nGeneric CPU definitions.\nCPU frequency scaling.\nCPU Mask abstractions.\nCredentials management.\nReturns the currently running task.\n<code>std::dbg</code>, but using <code>pr_info</code> instead of <code>eprintln</code>.\nDeclare the DRM ioctls for a driver.\nDeclare the Rust entry point for a tracepoint.\nDefines getters for a <code>ListArcField</code>.\nPrints an alert-level message (level 1) prefixed with …\nPrints a critical-level message (level 2) prefixed with …\nPrints a debug-level message (level 7) prefixed with …\nPrints an emergency-level message (level 0) prefixed with …\nPrints an error-level message (level 3) prefixed with …\nPrints an info-level message (level 6) prefixed with …\nPrints a notice-level message (level 5) prefixed with …\nPrints a warning-level message (level 4) prefixed with …\nGeneric devices that are part of the kernel’s driver …\nGeneric implementation of device IDs.\nDevres abstraction\nDirect memory access (DMA).\nReads a field of an item from an allocated region of …\nWrites to a field of an item from an allocated region of …\nGeneric support for drivers of different buses (e.g., PCI, …\nDRM subsystem abstractions.\nKernel errors.\nAbstractions for the faux bus.\nFirmware abstraction\nA convenience alias for <code>core::format_args</code>.\nReturns the argument unchanged.\nCreates a <code>ThisModule</code> given the <code>THIS_MODULE</code> pointer.\nKernel file systems.\nDefines a global lock.\nImplement <code>core::ops::Deref</code> traits for allowed <code>DeviceContext</code>…\nImplement <code>core::convert::From</code>, such that all <code>&amp;Device&lt;Ctx&gt;</code> …\nUse to implement the <code>HasHrTimer&lt;T&gt;</code> trait.\nImplements the <code>HasListLinks</code> trait for the given type.\nImplements the <code>HasListLinks</code> and <code>HasSelfPtr</code> traits for the …\nUsed to safely implement the <code>HasWork&lt;T, ID&gt;</code> trait.\nDeclares that this type supports <code>ListArc</code>.\nImplements the <code>ListItem</code> trait for the given type.\nExtensions to the <code>pin-init</code> crate.\nCalled at module initialization time.\nCreates an initialiser for the module.\nCalls <code>U::from(self)</code>.\nMemory-mapped IO.\n<code>ioctl()</code> number definitions.\nLogic for static keys.\nCreate a <code>KVec</code> containing the arguments.\nA linked list implementation.\nMiscdevice support.\nMemory management.\nDeclares a kernel module that exposes a single auxiliary …\nCreate device table alias for modpost.\nDeclares a kernel module that exposes a single driver.\nCreate firmware .modinfo entries.\nDeclares a kernel module that exposes a single PCI driver.\nDeclares a kernel module that exposes a single platform …\nNetworking.\nCreates a <code>CondVar</code> initialiser with the given name and a …\nCreates a <code>Mutex</code> initialiser with the given name and a …\nCreates a <code>PollCondVar</code> initialiser with the given name and …\nCreates a <code>SpinLock</code> initialiser with the given name and a …\nCreates a <code>Work</code> initialiser with the given name and a …\nDevice Tree / Open Firmware abstractions.\nCreate an OF <code>IdTable</code> with an “alias” for modpost.\nOperating performance points.\nKernel page allocation and management.\nAbstractions for the PCI bus.\nCreate a PCI <code>IdTable</code> with its alias for modpost.\nPid namespaces.\nAbstractions for the platform bus.\nPrints an alert-level message (level 1).\nContinues a previous log message in the same line.\nPrints a critical-level message (level 2).\nPrints a debug-level message (level 7).\nPrints an emergency-level message (level 0).\nPrints an error-level message (level 3).\nPrints an info-level message (level 6).\nPrints a notice-level message (level 5).\nPrints a warning-level message (level 4).\nThe <code>kernel</code> prelude.\nPrinting facilities.\nRed-black trees.\nRevocable objects.\nLinux Security Modules (LSM).\nSeq file bindings.\nWrite to a <code>SeqFile</code> with the ordinary Rust formatting …\nCommonly used sizes.\nStatic assert (i.e. compile-time assert).\nBranch based on a static key.\nString representations.\nSynchronisation primitives.\nTasks (threads and processes).\nTime related primitives.\nLogic for tracepoints.\nTraits for transmuting types.\nConstruct an in-place fallible initializer for <code>struct</code>s.\nConstruct an in-place, fallible pinned initializer for …\nKernel types.\nSlices to user space memory regions.\nWork queues.\nXArray abstraction.\nIndicates an allocation error.\nThe kernel’s <code>Allocator</code> trait.\nFlags to be used when allocating memory.\nAllocate memory based on <code>layout</code> and <code>flags</code>.\nAllocator support.\nCheck whether <code>flags</code> is contained in <code>self</code>.\nAllocation flags.\nFree an existing memory allocation.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nImplementation of <code>Box</code>.\nImplementation of <code>Vec</code>.\nMemory layout.\nRe-allocate an existing memory allocation to satisfy the …\nThe kvmalloc kernel allocator.\nThe contiguous kernel allocator.\nThe virtually contiguous kernel allocator.\nReturns a <code>Layout</code> that makes <code>Kmalloc</code> fulfill the requested …\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nUsers can not sleep and need the allocation to succeed.\nTypical for kernel-internal allocations. The caller …\nThe same as <code>GFP_KERNEL</code>, except the allocation is accounted …\nFor kernel allocations that should not stall for direct …\nAllow the allocation to be in high memory.\nSuppresses allocation failure reports.\nZeroes out the allocated memory.\nThe kernel’s <code>Box</code> type – a heap allocation for a single …\nType alias for <code>Box</code> with a <code>Kmalloc</code> allocator.\nType alias for <code>Box</code> with a <code>KVmalloc</code> allocator.\nType alias for <code>Box</code> with a <code>Vmalloc</code> allocator.\nConverts a <code>Box&lt;MaybeUninit&lt;T&gt;, A&gt;</code> to a <code>Box&lt;T, A&gt;</code>.\nDrops the contents, but keeps the allocation.\nReturns the argument unchanged.\nCreates a new <code>Box&lt;T, A&gt;</code> from a raw pointer.\nCalls <code>U::from(self)</code>.\nMoves the <code>Box</code>’s value out of the <code>Box</code> and consumes the <code>Box</code>…\nConvert a <code>Box&lt;T,A&gt;</code> to a <code>Pin&lt;Box&lt;T,A&gt;&gt;</code>. If <code>T</code> does not …\nConsumes the <code>Box&lt;T, A&gt;</code> and returns a raw pointer.\nConsumes and leaks the <code>Box&lt;T, A&gt;</code> and returns a mutable …\nCreates a new <code>Box&lt;T, A&gt;</code> and initializes its contents with <code>x</code>…\nCreates a new <code>Box&lt;T, A&gt;</code> with uninitialized contents.\nConstructs a new <code>Pin&lt;Box&lt;T, A&gt;&gt;</code>. If <code>T</code> does not implement …\nWrites the value and converts to <code>Box&lt;T, A&gt;</code>.\nAn iterator that owns all items in a vector, but does not …\nThe value could not be inserted because the index is out …\nError type for <code>Vec::insert_within_capacity</code>.\nAn <code>Iterator</code> implementation for <code>Vec</code> that moves elements out …\nType alias for <code>Vec</code> with a <code>KVmalloc</code> allocator.\nType alias for <code>Vec</code> with a <code>Kmalloc</code> allocator.\nThe value could not be inserted because the vector is out …\nError type for <code>Vec::push_within_capacity</code>.\nError type for <code>Vec::remove</code>.\nType alias for <code>Vec</code> with a <code>Vmalloc</code> allocator.\nThe kernel’s <code>Vec</code> type.\nReturns a mutable raw pointer to the vector’s backing …\nReturns a mutable slice of the entire vector.\nReturns a raw pointer to the vector’s backing buffer, …\nReturns a slice of the entire vector.\nReturns the number of elements that can be stored within …\nClears the vector, removing all values.\nSame as <code>Iterator::collect</code> but specialized for <code>Vec</code>’s …\nTakes ownership of all items in this vector without …\nPushes clones of the elements of slice into the <code>Vec</code> …\nExtend the vector by <code>n</code> clones of <code>value</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreate a new <code>Vec&lt;T, A&gt;</code> and extend it by <code>n</code> clones of <code>value</code>.\nCreates a <code>Vec&lt;T, A&gt;</code> from a pointer, a length and a …\nIncrements <code>self.len</code> by <code>additional</code>.\nInserts an element at the given index in the <code>Vec</code> instance.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConsumes the <code>Vec&lt;T, A&gt;</code> and creates an <code>Iterator</code>, which …\nConsumes the <code>Vec&lt;T, A&gt;</code> and returns its raw components …\nReturns <code>true</code> if the vector contains no elements, <code>false</code> …\nReturns the number of elements stored within the vector.\nCreates a new, empty <code>Vec&lt;T, A&gt;</code>.\nExamples\nRemoves the last element from a vector and returns it, or …\nAppends an element to the back of the <code>Vec</code> instance.\nAppends an element to the back of the <code>Vec</code> instance without …\nRemoves the element at the given index.\nEnsures that the capacity exceeds the length by at least …\nResizes the <code>Vec</code> so that <code>len</code> is equal to <code>new_len</code>.\nRemoves all elements that don’t match the provided …\nExamples\nReturns a slice of <code>MaybeUninit&lt;T&gt;</code> for the remaining spare …\nShortens the vector, setting the length to <code>len</code> and drops …\nCreates a new <code>Vec</code> instance with at least the given …\nA layout for an array <code>[T; n]</code>.\nError when constructing an <code>ArrayLayout</code>.\nCreates a new layout for <code>[T; 0]</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns <code>true</code> when no array elements are represented by …\nReturns the number of array elements represented by this …\nCreates a new layout for <code>[T; len]</code>.\nCreates a new layout for <code>[T; len]</code>.\nAn adapter for the registration of auxiliary drivers.\nThe auxiliary device representation.\nAbstraction for <code>bindings::auxiliary_device_id</code>.\nThe auxiliary driver trait.\nThe table of device ids supported by the driver.\nThe type holding information about each device id …\nIdTable type for auxiliary drivers.\nThe registration of an auxiliary device.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the auxiliary device’ id.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreate and register a new auxiliary device.\nCreate a new <code>DeviceId</code> from name.\nReturns a reference to the parent <code>device::Device</code>, if any.\nAuxiliary driver probe.\nThis module provides types for implementing block drivers …\nIndicates if the <code>commit_rqs</code> method is overridden by the …\nIndicates if the <code>commit_rqs</code> method is overridden by the …\nIndicates if the <code>poll</code> method is overridden by the …\nIndicates if the <code>poll</code> method is overridden by the …\nIndicates if the <code>queue_rq</code> method is overridden by the …\nIndicates if the <code>queue_rq</code> method is overridden by the …\nImplement this trait to interface blk-mq as block devices.\nA wrapper around a blk-mq <code>struct request</code>. This represents …\nA wrapper for the C <code>struct blk_mq_tag_set</code>.\nA marker to prevent implementors from forgetting to use …\nCalled by the kernel to indicate that queued requests …\nNotify the block layer that the request has been completed …\nReturns the argument unchanged.\nReturns the argument unchanged.\nGeneric disk abstraction.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nTry to create a new tag set\nCalled by the kernel to poll the device for completed …\nCalled by the kernel to poll the device for completed …\nCalled by the kernel to queue a request with the driver. …\nA generic block device.\nA builder for <code>GenDisk</code>.\nBuild a new <code>GenDisk</code> and add it to the VFS.\nSet the capacity of the device to be built, in sectors …\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nSet the logical block size of the device to be built.\nCreate a new instance.\nSet the physical block size of the device to be built.\nSet the rotational media attribute for the device to be …\nA reference-counted clock.\nThe frequency unit.\nA reference-counted optional clock.\nGet the frequency in gigahertz\nGet the frequency in hertz\nGet the frequency in kilohertz\nGet the frequency in megahertz\nObtain the raw [<code>struct clk</code>] pointer.\nDisable the clock.\nDisable and unprepare the clock.\nEnable the clock.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreate a new instance from gigahertz (GHz)\nCreate a new instance from kilohertz (kHz)\nCreate a new instance from megahertz (MHz)\nGets <code>Clk</code> corresponding to a <code>Device</code> and a connection id.\nGets <code>OptionalClk</code> corresponding to a <code>Device</code> and a …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nPrepare the clock.\nPrepare and enable the clock.\nGet clock’s rate.\nSet clock’s rate.\nUnprepare the clock.\nA configfs attribute.\nA list of attributes.\nOperations supported by an attribute.\nThe child data object type.\nThe type of the object that contains the field that is …\nA configfs group.\nOperations implemented by configfs groups that can create …\nIndicates if the <code>drop_item</code> method is overridden by the …\nIndicates if the <code>make_group</code> method is overridden by the …\nIndicates if the <code>show</code> method is overridden by the …\nIndicates if the <code>store</code> method is overridden by the …\nTrait that allows offset calculations for structs that …\nA representation of the attributes that will appear in a …\nA configfs subsystem.\nA marker to prevent implementors from forgetting to use …\nA marker to prevent implementors from forgetting to use …\nReturn the address of the <code>Self</code> that <code>group</code> is embedded in.\nPrepares the group for removal from configfs.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturn the address of the <code>bindings::config_group</code> embedded …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates a new subgroup.\nCreate a new attribute.\nCreate an initializer for a <code>Subsystem</code>.\nCreate an initializer for a new group.\nRenders the value of an attribute.\nStores the value of an attribute.\nThe CPU ID.\nReturns CPU number.\nReturns the ID of the CPU the code is currently running on.\nReturns the argument unchanged.\nCreates a new instance of CPU’s device.\nCreates a new <code>CpuId</code> from the given <code>id</code>, checking that it is …\nCreates a new <code>CpuId</code> from the given <code>id</code> without checking …\nCreates a new <code>CpuId</code> from the given <code>id</code>, checking that it is …\nCreates a new <code>CpuId</code> from the given <code>id</code> without checking …\nCalls <code>U::from(self)</code>.\nReturns the maximum number of possible CPUs in the current …\nBoost support.\nSelect the closest frequency to the target.\nCPU frequency driver.\nDefault transition latency value in nanoseconds.\nDriver’s flags.\nIndicates if the <code>adjust_perf</code> method is overridden by the …\nIndicates if the <code>bios_limit</code> method is overridden by the …\nIndicates if the <code>exit</code> method is overridden by the …\nIndicates if the <code>fast_switch</code> method is overridden by the …\nIndicates if the <code>get</code> method is overridden by the …\nIndicates if the <code>get_intermediate</code> method is overridden by …\nIndicates if the <code>init</code> method is overridden by the …\nIndicates if the <code>offline</code> method is overridden by the …\nIndicates if the <code>online</code> method is overridden by the …\nIndicates if the <code>ready</code> method is overridden by the …\nIndicates if the <code>register_em</code> method is overridden by the …\nIndicates if the <code>resume</code> method is overridden by the …\nIndicates if the <code>setpolicy</code> method is overridden by the …\nIndicates if the <code>set_boost</code> method is overridden by the …\nIndicates if the <code>suspend</code> method is overridden by the …\nIndicates if the <code>target</code> method is overridden by the …\nIndicates if the <code>target_index</code> method is overridden by the …\nIndicates if the <code>target_intermediate</code> method is overridden …\nIndicates if the <code>update_limits</code> method is overridden by the …\nIndicates if the <code>verify</code> method is overridden by the …\nSelect the highest frequency below or at target.\nSelect the lowest frequency at or above target.\nDriver’s name.\nPolicy specific data.\nCPU frequency policy.\nPolicy data.\nCPU frequency driver Registration.\nCPU frequency selection relations.\nCPU frequency table.\nCPU frequency table owned and pinned in memory, created …\nCPU frequency table builder.\nThe frequency table index.\nA marker to prevent implementors from forgetting to use …\nAdds a new entry to the table.\nDriver’s <code>adjust_perf</code> callback.\nReturns a raw pointer to the underlying C …\nReturns the raw mutable pointer to the C …\nDriver’s <code>bios_limit</code> callback.\nReturns the primary CPU for the <code>Policy</code>.\nGets <code>cpumask::Cpumask</code> for a cpufreq <code>Policy</code>.\nReturns the current frequency for the <code>Policy</code>.\nReturns data at <code>index</code> in the <code>Table</code>.\nReturns the <code>Policy</code>’s private data.\nUnregisters with the cpufreq core.\nDriver’s <code>exit</code> callback.\nDriver’s <code>fast_switch</code> callback.\nReturns if fast switching of frequencies is possible or …\nCPU frequency driver flags.\nReturns flags at <code>index</code> in the <code>Table</code>.\nReturns frequency at <code>index</code> in the <code>Table</code>.\nReturns reference to the CPU frequency <code>Table</code> for the <code>Policy</code>…\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a reference to an existing C …\nCreates a reference to an existing <code>struct cpufreq_policy</code> …\nCreates a mutable reference to an existing …\nCreates a mutable reference to an existing …\nProvides a wrapper to the generic get routine.\nProvides a wrapper to the generic suspend routine.\nWrapper for <code>cpufreq_generic_frequency_table_verify</code>.\nDriver’s <code>get</code> callback.\nDriver’s <code>get_intermediate</code> callback.\nDriver’s <code>init</code> callback.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns the maximum frequency for the <code>Policy</code>.\nReturns the minimum frequency for the <code>Policy</code>.\nRegisters a CPU frequency driver with the cpufreq core.\nCreates an instance of <code>TableIndex</code>.\nCreates a new instance of <code>TableBuilder</code>.\nSame as <code>Registration::new</code>, but does not return a …\nDriver’s <code>offline</code> callback.\nDriver’s <code>online</code> callback.\nDriver’s <code>ready</code> callback.\nDriver’s <code>register_em</code> callback.\nProvides a wrapper to the register with energy model using …\nDriver’s <code>resume</code> callback.\nDriver’s <code>set_boost</code> callback.\nSets clock for the <code>Policy</code>.\nSets cpuinfo <code>max_freq</code>.\nSets cpuinfo <code>min_freq</code>.\nAllows / disallows frequency switching code to run on any …\nEnables / disables fast frequency switching.\nSets the CPU frequency <code>Table</code> for the <code>Policy</code>.\nSet the maximum frequency for the <code>Policy</code>.\nSet the minimum frequency for the <code>Policy</code>.\nSets the suspend frequency for the <code>Policy</code>.\nSet <code>transition_delay_us</code>, i.e. the minimum time between …\nSets transition latency (in nanoseconds) for the <code>Policy</code>.\nDriver’s <code>setpolicy</code> callback.\nDriver’s <code>suspend</code> callback.\nReturns the suspend frequency for the <code>Policy</code>.\nDriver’s <code>target</code> callback.\nDriver’s <code>target_index</code> callback.\nDriver’s <code>target_intermediate</code> callback.\nConsumes the <code>TableBuilder</code> and returns <code>TableBox</code>.\nDriver’s <code>update_limits</code> callback.\nDriver’s <code>verify</code> callback.\nAllows post-change notifications outside of the <code>target()</code> …\nPlatform where constants like <code>loops_per_jiffy</code> are …\nSupports multiple clock domains with per-policy governors …\nRegister driver as a thermal cooling device automatically.\nEnsure CPU starts at a valid frequency from the driver’s …\nDriver needs to update internal limits even if frequency …\nDisallow governors with <code>dynamic_switching</code> capability.\nA CPU Mask.\nA CPU Mask pointer.\nCreates a mutable reference to an existing <code>struct cpumask</code> …\nCreates a mutable reference to an existing …\nObtain the raw <code>struct cpumask</code> pointer.\nCreates a reference to an existing <code>struct cpumask</code> pointer.\nCreates a reference to an existing <code>struct cpumask_var_t</code> …\nClear <code>cpu</code> in the cpumask.\nCopy cpumask.\nChecks if cpumask is empty.\nReturns the argument unchanged.\nReturns the argument unchanged.\nChecks if cpumask is full.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates an instance of the <code>CpumaskVar</code>.\nCreates a zero-initialized instance of the <code>CpumaskVar</code>.\nSet <code>cpu</code> in the cpumask.\nSet all CPUs in the cpumask.\nTest <code>cpu</code> in the cpumask.\nClones cpumask.\nGet weight of the cpumask.\nWraps the kernel’s <code>struct cred</code>.\nReturns the effective UID of the given credential.\nReturns the argument unchanged.\nCreates a reference to a <code>Credential</code> from a valid pointer.\nGet the id for this security context.\nCalls <code>U::from(self)</code>.\nThe <code>Bound</code> context is the context of a bus specific device …\nThe <code>Core</code> context is the context of a bus specific device …\nA reference-counted device.\nMarker trait for the context of a bus specific device.\nThe <code>Normal</code> context is the context of a bus specific device …\nConvert a raw C <code>struct device</code> pointer to a <code>&amp;&#39;a Device</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a new reference-counted abstraction instance of an …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nPrints an alert-level message (level 1) prefixed with …\nPrints a critical-level message (level 2) prefixed with …\nPrints a debug-level message (level 7) prefixed with …\nPrints an emergency-level message (level 0) prefixed with …\nPrints an error-level message (level 3) prefixed with …\nPrints an info-level message (level 6) prefixed with …\nPrints a notice-level message (level 5) prefixed with …\nPrints a warning-level message (level 4) prefixed with …\nChecks if property is present or not.\nThe offset to the context/data field.\nA zero-terminated device id array, followed by context …\nA device id table.\nMarker trait to indicate a Rust device ID type represents …\nA zero-terminated device id array.\nThe raw type that holds the device id.\nObtain the pointer to the ID table.\nReturns the argument unchanged.\nReturns the argument unchanged.\nObtain the pointer to the bus specific device ID from an …\nThe index stored at <code>DRIVER_DATA_OFFSET</code> of the implementor …\nObtain the pointer to the driver-specific information from …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates a new instance of the array.\nReference to the contained <code>RawIdArray</code>.\nThis abstraction is meant to be used by subsystems to …\nObtain <code>&amp;&#39;a T</code>, bypassing the <code>Revocable</code>.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreates a new <code>Devres</code> instance of the given <code>data</code>. The <code>data</code> …\nSame as <code>Devres::new</code>, but does not return a <code>Devres</code> …\n<code>Devres</code> accessor for <code>Revocable::try_access</code>.\n<code>Devres</code> accessor for <code>Revocable::try_access_with</code>.\n<code>Devres</code> accessor for <code>Revocable::try_access_with_guard</code>.\nPossible attributes associated with a DMA mapping.\nAn abstraction of the <code>dma_alloc_coherent</code> API.\nAllocates a region of <code>size_of::&lt;T&gt; * count</code> of consistent …\nPerforms the same functionality as …\nDMA mapping attributes.\nCheck whether <code>flags</code> is contained in <code>self</code>.\nReturns a DMA handle which may given to the device as the …\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns the base address to the allocated region in the CPU…\nReturns the base address to the allocated region in the CPU…\nThis is a hint to the DMA-mapping subsystem that it’s …\nForces contiguous allocation of the buffer in physical …\nLets the platform to avoid creating a kernel virtual …\nThis tells the DMA-mapping subsystem to suppress …\nUsed to indicate that the buffer is fully accessible at an …\nAllows platform code to skip synchronization of the CPU …\nSpecifies that reads and writes to the mapping may be …\nSpecifies that writes to the mapping may be buffered to …\nThe bus independent adapter to match a drivers and a …\nThe type holding driver private data about each device id …\nThe type that holds information about the registration. …\nA <code>Registration</code> is a generic type that represents the …\nThe <code>RegistrationOps</code> trait serves as generic interface for …\nReturns the argument unchanged.\nReturns the driver’s private data from the matching …\nCalls <code>U::from(self)</code>.\nCreates a new instance of the registration object.\nThe <code>of::IdTable</code> of the corresponding driver.\nRegisters a driver.\nUnregisters a driver previously registered with …\nDRM device.\nDRM driver core.\nDRM File objects.\nDRM GEM API\nDRM IOCTL definitions.\nA typed DRM device with a specific <code>drm::Driver</code> …\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreate a new <code>drm::Device</code> for a <code>drm::Driver</code>.\nThe C callback operations for this memory manager.\nTrait for memory manager implementations. Implemented …\nInternal memory management operation set, normally created …\nContext data associated with the DRM driver\nThe DRM <code>Driver</code> trait.\nInformation data for a DRM Driver.\nThe type used to represent a DRM File (client)\nDriver metadata\nIOCTL list. See <code>kernel::drm::ioctl::declare_drm_ioctls!{}</code>.\nThe type used to manage memory for this driver.\nThe registration type of a <code>drm::Device</code>.\nA marker to prevent implementors from forgetting to use …\nDriver description.\nReturns a reference to the <code>Device</code> instance for this …\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nDriver major version.\nDriver minor version.\nDriver name.\nSame as [<code>Registration::new</code>}, but transfers ownership of …\nDriver patchlevel version.\nThe parent <code>Driver</code> implementation for this <code>DriverFile</code>.\nTrait that must be implemented by DRM drivers to represent …\nAn open DRM File.\nReturns the argument unchanged.\nReturn a pinned reference to the driver file structure.\nCalls <code>U::from(self)</code>.\nOpen a new file (called when a client opens the DRM …\nGEM object functions, which must be implemented by drivers.\nBase operations shared by all GEM object classes\nOwning driver for this type\nParent <code>Driver</code> for this object.\nTrait which must be implemented by drivers using base GEM …\nTrait that represents a GEM object subtype\nA base GEM object.\nThe size of this object’s structure.\nReturns a reference to the raw <code>drm_gem_object</code> structure, …\nConverts a pointer to a <code>struct drm_gem_object</code> into a …\nClose a handle to an existing object, associated with a …\nCreates a new handle for the object associated with a …\nCreates an mmap offset to map the object from userspace.\nReturns the <code>Device</code> that owns this GEM object.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nLooks up an object by its handle for a given <code>File</code>.\nCreate a new driver data object for a GEM object of a …\nCreate a new GEM object.\nOpen a new handle to an existing object, associated with a …\nReturns the size of the object in bytes.\nThis is for ioctl which are used for rendering, and …\nDescriptor type for DRM ioctls. Use the …\nConstruct a DRM ioctl number with no argument.\nConstruct a DRM ioctl number with a read-only argument.\nConstruct a DRM ioctl number with a write-only argument.\nConstruct a DRM ioctl number with a read-write argument.\nThis must be set for any ioctl which can change the …\nThis is used for all ioctl needed for rendering only, for …\nAnything that could potentially wreak a master file …\nContains the error value\nGeneric integer kernel error.\nContains the success value\nA <code>Result</code> with an <code>Error</code> error type.\nError message for calling a default function of a <code>#[vtable]</code>…\nContains the C-compatible error codes.\nReturns the argument unchanged.\nTransform a kernel “error pointer” to a normal pointer.\nCreates an <code>Error</code> from a kernel error code.\nCalls a closure returning a <code>crate::error::Result&lt;T&gt;</code> and …\nCalls <code>U::from(self)</code>.\nReturns a string representing the error, if one exists.\nReturns the kernel error code.\nReturns the error encoded as a pointer.\nConverts an integer as returned by a C kernel function to …\nArgument list too long.\nPermission denied.\nTry again.\nCookie is stale.\nBad file number.\nIllegal NFS file handle.\nType not supported by server.\nDevice or resource busy.\nNo child processes.\nMath argument out of domain of func.\nFile exists.\nBad address.\nFile too large.\nInterrupted system call.\nInvalid argument.\nI/O error.\niocb queued, will get completion event.\nIs a directory.\nRequest initiated, but will not complete before timeout.\nToo many open files.\nToo many links.\nFile table overflow.\nNo such device.\nNo such file or directory.\nExec format error.\nNFS file lock reclaim refused.\nNo ioctl command.\nOut of memory.\nParameter not supported.\nNo space left on device.\nBlock device required.\nNot a directory.\nOperation is not supported.\nUpdate synchronization mismatch.\nNot a typewriter.\nNo such device or address.\nOpen found a stale dentry.\nValue too large for defined data type.\nOperation not permitted.\nBroken pipe.\nDriver requests probe retry.\nMath result not representable.\nConflict with recalled state.\nRestart if no handler.\nSystem call was interrupted by a signal and will be …\nRestart the system call.\nRestart by calling sys_restart_syscall.\nRead-only file system.\nAn untranslatable error occurred.\nIllegal seek.\nNo such process.\nBuffer or request is too small.\nText file busy.\nCross-device link.\nThe registration of a faux device.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreate and register a new faux device with the given name.\nAbstraction around a C <code>struct firmware</code>.\nBuilder for firmware module info.\nBuild the byte array.\nReturn the length of the byte array to build.\nReturns the requested firmware as <code>&amp;[u8]</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreate an empty builder instance.\nPrepare the <code>ModInfoBuilder</code> for the next entry.\nPush an additional path component.\nSend a firmware request and wait for it. See also …\nSend a request for an optional firmware module. See also …\nReturns the size of the requested firmware in bytes.\nFiles and file descriptors.\nRepresents the <code>EBADF</code> error code.\nWraps the kernel’s <code>struct file</code>. Thread safe.\nA file descriptor reservation.\nWraps the kernel’s <code>struct file</code>. Not thread safe.\nReturns a raw pointer to the inner C struct.\nAssume that there are no active <code>fdget_pos</code> calls that …\nReturns the credentials of the task that originally opened …\nCommits the reservation.\nConstructs a new <code>struct file</code> wrapper from a file …\nFlags associated with a <code>File</code>.\nReturns the flags associated with the file.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a reference to a <code>File</code> from a valid pointer.\nCreates a reference to a <code>LocalFile</code> from a valid pointer.\nCreates a new file descriptor reservation.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns the file descriptor number that was reserved.\nBitmask for access mode flags.\nFile is opened in append mode.\nSignal-driven I/O is enabled.\nClose-on-exec flag is set.\nFile was created if it didn’t already exist.\nDirect I/O is enabled for this file.\nFile must be a directory.\nLike <code>O_SYNC</code> except metadata is not synced.\nEnsure that this file is created with the <code>open(2)</code> call.\nLarge file size enabled (<code>off64_t</code> over <code>off_t</code>).\nFile is using nonblocking I/O.\nDo not update the file last access time.\nFile should not be used as process’s controlling …\nIf basename of path is a symbolic link, fail open.\nFile is using nonblocking I/O.\nUsed to obtain a path file descriptor.\nFile is read only.\nFile can be both read and written.\nWrite operations on this file will flush data and metadata.\nThis file is an unnamed temporary regular file.\nFile should be truncated to length 0.\nFile is write only.\nSmart pointer that can initialize memory in-place.\nPinned version of <code>Self</code>.\nUse the given initializer to in-place initialize a <code>T</code>.\nUse the given pin-initializer to pin-initialize a <code>T</code> inside …\nUse the given initializer to in-place initialize a <code>T</code>.\nUse the given pin-initializer to pin-initialize a <code>T</code> inside …\nIO-mapped memory, starting at the base address @addr and …\nRaw representation of an MMIO region.\nReturns the base address of the MMIO region.\nReturns the base address of this mapping.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConverts an <code>IoRaw</code> into an <code>Io</code> instance, providing the …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns the maximum size of the MMIO region.\nReturns the maximum size of this mapping.\nReturns a new <code>IoRaw</code> instance on success, an error …\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nBuild an ioctl number for an argumentless ioctl.\nGet the ioctl direction from an ioctl number.\nGet the ioctl number from an ioctl number.\nGet the ioctl size from an ioctl number.\nGet the ioctl type from an ioctl number.\nBuild an ioctl number for a read-only ioctl.\nBuild an ioctl number for a write-only ioctl.\nBuild an ioctl number for a read-write ioctl.\nBranch based on a static key.\nA utility for tracking whether a <code>ListArc</code> exists using an …\nA cursor into a <code>List</code>.\nReferences the element in the list next to the cursor.\nDeclares that this type has a <code>ListLinks&lt;ID&gt;</code> field at a …\nDeclares that the <code>ListLinks&lt;ID&gt;</code> field in this struct is …\nAn owning iterator into a <code>List</code>.\nAn iterator over a <code>List</code>.\nThe offset from the <code>ListLinks</code> to the self pointer field.\nA linked list.\nA wrapper around <code>Arc</code> that’s guaranteed unique for the …\nA field owned by a specific <code>ListArc</code>.\nDeclares that this type has some way to ensure that there …\nImplemented by types where a <code>ListArc&lt;Self&gt;</code> can be inserted …\nThe prev/next pointers for an item in a linked list.\nSimilar to <code>ListLinks</code>, but also contains a pointer to the …\nThe offset of the <code>ListLinks</code> field.\nDeclares that this type is able to safely attempt to …\nAccess this value as an <code>ArcBorrow</code>.\nReturns a reference to an <code>Arc</code> from the given <code>ListArc</code>.\nReturns an <code>ArcBorrow</code> from the given <code>ListArc</code>.\nUnsafely assert that you have mutable access to the <code>ListArc</code>…\nUnsafely assert that you have shared access to the <code>ListArc</code> …\nClone a <code>ListArc</code> into an <code>Arc</code>.\nReturns a cursor that points after the last element in the …\nReturns a cursor that points before the first element of …\nDefines getters for a <code>ListArcField</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConvert a <code>UniqueArc</code> into a <code>ListArc</code>.\nConvert a pinned <code>UniqueArc</code> into a <code>ListArc</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nTake ownership of the <code>ListArc</code> from a raw pointer.\nAccess the value when we have exclusive access to the …\nImplements the <code>HasListLinks</code> trait for the given type.\nImplements the <code>HasListLinks</code> and <code>HasSelfPtr</code> traits for the …\nDeclares that this type supports <code>ListArc</code>.\nImplements the <code>ListItem</code> trait for the given type.\nUse the given initializer to in-place initialize a <code>T</code>.\nThe <code>ListLinks</code> field inside this value.\nInsert an element at this cursor’s location.\nInserts an element after this cursor.\nInserts an element before this cursor.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConverts the <code>ListArc</code> into an <code>Arc</code>.\nConvert ownership of this <code>ListArc</code> into a raw pointer.\nReturns whether this list is empty.\nCreates an iterator over the list.\nMove the cursor one element forward.\nMove the cursor one element backwards.\nCreates a new initializer for this type.\nCreates a new <code>ListArcField</code>.\nCreates a new empty list.\nCreates a new initializer for this type.\nCreates a new initializer for this type.\nConstructs a new reference counted instance of <code>T</code>.\nInforms the tracking inside this type that it now has a …\nInforms the tracking inside this type that there is no …\nCreates two <code>ListArc</code>s from a pinned <code>UniqueArc</code>.\nCreates two <code>ListArc</code>s from a <code>UniqueArc</code>.\nAccess the element after this cursor.\nAccess the element before this cursor.\nUse the given initializer to in-place initialize a <code>T</code>.\nRemoves the last item from this list.\nRemoves the first item from this list.\nThis undoes a previous call to <code>prepare_to_insert</code>.\nThis is called when an item is inserted into a <code>List</code>.\nCompare whether two <code>ListArc</code> pointers reference the same …\nMoves all items from <code>other</code> into <code>self</code>.\nAdd the provided item to the back of the list.\nAdd the provided item to the front of the list.\nReturns a pointer to the <code>ListLinks&lt;T, ID&gt;</code> field.\nReturns a pointer to the <code>ListLinks&lt;T, ID&gt;</code> field.\nRemoves the provided item from this list and returns it.\nRemove the element from the list.\nRemove the next element from the list.\nRemove the previous element from the list.\nTry to create a new <code>ListArc</code>.\nTry to create a new <code>ListArc</code>.\nTry to create a new <code>ListArc</code>.\nAttempts to convert an <code>Arc&lt;Self&gt;</code> into an <code>ListArc&lt;Self&gt;</code>. …\nViews the <code>ListLinks</code> for this value.\nView the full value given its <code>ListLinks</code> field.\nIndicates if the <code>compat_ioctl</code> method is overridden by the …\nIndicates if the <code>ioctl</code> method is overridden by the …\nIndicates if the <code>mmap</code> method is overridden by the …\nIndicates if the <code>open</code> method is overridden by the …\nIndicates if the <code>release</code> method is overridden by the …\nIndicates if the <code>show_fdinfo</code> method is overridden by the …\nTrait implemented by the private data of an open misc …\nOptions for creating a misc device.\nA registration of a miscdevice.\nWhat kind of pointer should <code>Self</code> be wrapped in.\nA marker to prevent implementors from forgetting to use …\nReturns a raw pointer to the misc device.\nHandler for ioctls.\nAccess the <code>this_device</code> field.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreate a raw <code>struct miscdev</code> ready for registration.\nHandler for ioctls.\nHandle for mmap.\nThe name of the miscdevice.\nCalled when the misc device is opened.\nRegister a misc device.\nCalled when the misc device is released.\nShow info for this fd.\nA wrapper for the kernel’s <code>struct mm_struct</code>.\nA wrapper for the kernel’s <code>struct mm_struct</code>.\nA wrapper for the kernel’s <code>struct mm_struct</code>.\nA guard for the mmap read lock.\nA guard for the vma read lock.\nReturns a raw pointer to the inner <code>mm_struct</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nObtain a reference from a raw pointer.\nObtain a reference from a raw pointer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nUse <code>mmput_async</code> when dropping this refcount.\nAttempt to access a vma using the vma read lock.\nLock the mmap read lock.\nTry to lock the mmap read lock.\nCalls <code>mmget_not_zero</code> and returns a handle if it succeeds.\nVirtual memory.\nLook up a vma at the given address.\nA wrapper for the kernel’s <code>struct vm_area_struct</code> with …\nA configuration object for setting up a VMA in an …\nA wrapper for the kernel’s <code>struct vm_area_struct</code> with …\nIf the <code>VM_MIXEDMAP</code> flag is set, returns a <code>VmaMixedMap</code> to …\nReturns a raw pointer to this area.\nReturns the (exclusive) end address of the virtual memory …\nReturns whether <code>VM_EXEC</code> is set.\nAll possible flags for <code>VmaRef</code>.\nReturns the flags associated with the virtual memory area.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nAccess a virtual memory area given a raw pointer.\nAccess a virtual memory area given a raw pointer.\nAccess a virtual memory area given a raw pointer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nAccess the underlying <code>mm_struct</code>.\nReturns whether <code>VM_READ</code> is set.\nSet the <code>VM_DONTCOPY</code> flag on this vma.\nSet the <code>VM_DONTDUMP</code> flag on this vma.\nSet the <code>VM_DONTEXPAND</code> flag on this vma.\nSet the <code>VM_IO</code> flag on this vma.\nSet the <code>VM_MIXEDMAP</code> flag on this vma.\nReturns the (inclusive) start address of the virtual …\nTry to clear the <code>VM_MAYEXEC</code> flag, failing if <code>VM_EXEC</code> is …\nTry to clear the <code>VM_MAYREAD</code> flag, failing if <code>VM_READ</code> is …\nTry to clear the <code>VM_MAYWRITE</code> flag, failing if <code>VM_WRITE</code> is …\nThe integer type used for vma flags.\nMaps a single page at the given address within the virtual …\nReturns whether <code>VM_WRITE</code> is set.\nZap pages in the given page range.\nIs a VM accounted object.\nArchitecture-specific flag.\nDo not copy this vma on fork.\nDo not include in the core dump.\nCannot expand with mremap().\nMapping allows execution.\nMADV_HUGEPAGE marked this vma.\nHuge TLB Page VM.\nMemory mapped I/O or similar.\nLock the pages covered when they are faulted in.\nMapping may be updated to allow execution.\nMapping may be updated to allow reads.\nMapping may be updated to be shared.\nMapping may be updated to allow writes.\nKSM may merge identical pages.\nCan contain <code>struct page</code> and pure PFN pages.\nMADV_NOHUGEPAGE marked this vma.\nNo flags are set.\nShould the VM suppress accounting.\nPage-ranges managed without <code>struct page</code>, just pure PFN.\nMapping allows reads.\nMapping is shared.\nNot soft dirty clean area.\nSynchronous page faults. (DAX-specific)\nWipe VMA contents in child on fork.\nMapping allows writes.\nAn open firmware device id.\nIdTable type for OF drivers.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreate a new device id from an OF ‘compatible’ string.\nFind the lowest frequency greater than or equal to the …\nOPP configurations.\nOPP configuration callbacks.\nOPP configuration token.\nOPP data.\nMatch the exact frequency.\nFind the highest frequency less than or equal to the given …\nOPP frequency table.\nIndicates if the <code>config_clks</code> method is overridden by the …\nIndicates if the <code>config_regulators</code> method is overridden by …\nThe voltage unit.\nThe power unit.\nA reference-counted Operating performance point (OPP).\n<code>OPP</code> search options.\nA reference-counted OPP table.\nHandle for a dynamically created <code>OPP</code>.\nA marker to prevent implementors from forgetting to use …\nAdds an <code>OPP</code> dynamically.\nUpdates the voltage value for an <code>OPP</code>.\nThis is typically used to scale clocks when transitioning …\nThis provides access to the old and new OPPs, allowing for …\nCreates <code>FreqTable</code> from <code>Table</code>.\nDisables the <code>OPP</code>.\nEnables the <code>OPP</code>.\nReturns the frequency of an <code>OPP</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a new reference-counted <code>Table</code> instance for a <code>Device</code>…\nCreates a reference to a <code>OPP</code> from a valid pointer.\nCreates an owned reference to a <code>OPP</code> from a valid pointer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns true if the <code>OPP</code> is turbo.\nReturns the level of an <code>OPP</code>.\nReturns max clock latency (in nanoseconds) of the <code>OPP</code>s in …\nReturns max transition latency (in nanoseconds) of the <code>OPP</code>…\nReturns max volt latency (in nanoseconds) of the <code>OPP</code>s in …\nCreates a new instance of <code>Data</code>.\nCreates a new instance of <code>Config</code>.\nReturns the number of <code>OPP</code>s in the <code>Table</code>.\nFinds <code>OPP</code> based on bandwidth.\nFinds <code>OPP</code> based on frequency.\nFinds <code>OPP</code> based on level.\nReturns the power of an <code>OPP</code>.\nReturns the required pstate of an <code>OPP</code>.\nSets the configuration with the OPP core.\nInitializes clock names.\nConfigures device with <code>OPP</code>.\nInitializes property name.\nConfigures device with <code>OPP</code> matching the frequency value.\nInitializes regulator names.\nInitializes required devices.\nSets sharing CPUs.\nInitializes supported hardware.\nGets sharing CPUs.\nReturns the suspend <code>OPP</code>’s frequency.\nSynchronizes regulators used by the <code>Table</code>.\nReturns the voltage of an <code>OPP</code>.\nA bitmask that gives the page containing a given address.\nA bitwise shift for the page size.\nThe number of bytes in a page.\nA pointer to a page that owns the page allocation.\nAllocates a new page.\nReturns a raw pointer to the page.\nCopies data from userspace into this page.\nMaps the page and zeroes the given slice.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nRound up the given number to the next multiple of <code>PAGE_SIZE</code>…\nMaps the page and reads from it into the given buffer.\nMaps the page and writes into it from the given buffer.\nAn adapter for the registration of PCI drivers.\nA PCI BAR to perform I/O-Operations on.\nThe PCI device representation.\nAbstraction for the PCI device ID structure (…\nThe PCI driver trait.\nThe table of device ids supported by the driver.\nThe type holding information about each device id …\n<code>IdTable</code> type for PCI.\nReturns the PCI device ID.\nEnable memory resources for this device.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nEquivalent to C’s <code>PCI_DEVICE_CLASS</code> macro.\nEquivalent to C’s <code>PCI_DEVICE</code> macro.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nMapps an entire PCI-BAR after performing a region-request …\nMapps an entire PCI-BAR after performing a region-request …\nPCI driver probe.\nReturns the size of the given PCI bar resource.\nEnable bus-mastering for this device.\nReturns the PCI vendor ID.\nWraps the kernel’s <code>struct pid_namespace</code>. Thread safe.\nReturns a raw pointer to the inner C struct.\nReturns the argument unchanged.\nCreates a reference to a <code>PidNamespace</code> from a valid pointer.\nCalls <code>U::from(self)</code>.\nAn adapter for the registration of platform drivers.\nThe platform device representation.\nThe platform driver trait.\nThe type holding driver private data about each device id …\nThe table of OF device ids supported by the driver.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nPlatform driver probe.\nSmart pointer containing uninitialized memory and that can …\nAn initializer for <code>T</code>.\nThe type <code>Self</code> turns into when the contents are initialized.\nA pin-initializer for the type <code>T</code>.\nMarker trait for types that can be initialized by writing …\nInitializes <code>slot</code>.\nInitializes <code>slot</code>.\nAsserts that a boolean expression is <code>true</code> at compile time.\nFails the build if the code path calling <code>build_error!</code> can …\nEquivalent to C’s <code>void</code> type when used as a pointer.\nFirst initializes the value using <code>self</code> then calls the …\nReturns the currently running task.\nPrints an alert-level message (level 1) prefixed with …\nPrints a critical-level message (level 2) prefixed with …\nPrints a debug-level message (level 7) prefixed with …\nPrints an emergency-level message (level 0) prefixed with …\nPrints an error-level message (level 3) prefixed with …\nPrints an info-level message (level 6) prefixed with …\nPrints a notice-level message (level 5) prefixed with …\nPrints a warning-level message (level 4) prefixed with …\nA convenience alias for <code>core::format_args</code>.\nReturns the argument unchanged.\nConstruct an in-place initializer for <code>struct</code>s.\nCalls <code>U::from(self)</code>.\nFirst initializes the value using <code>self</code> then calls the …\nConstruct an in-place, pinned initializer for <code>struct</code>s.\nPrints an alert-level message (level 1).\nPrints a critical-level message (level 2).\nPrints a debug-level message (level 7).\nPrints an emergency-level message (level 0).\nPrints an error-level message (level 3).\nPrints an info-level message (level 6).\nPrints a notice-level message (level 5).\nPrints a warning-level message (level 4).\nStatic assert (i.e. compile-time assert).\nConstruct an in-place fallible initializer for <code>struct</code>s.\nConstruct an in-place, fallible pinned initializer for …\nUse the given initializer to write a value into <code>self</code>.\nUse the given pin-initializer to write a value into <code>self</code>.\nA bidirectional cursor over the tree nodes, sorted by key.\nA view into a single entry in a map, which may either be …\nAn iterator over the nodes of a <code>RBTree</code>.\nA mutable iterator over the nodes of a <code>RBTree</code>.\nThis <code>RBTree</code> already has a node with this key.\nA view into an occupied entry in a <code>RBTree</code>. It is part of …\nA red-black tree with owned nodes.\nA red-black tree node.\nA memory reservation for a red-black tree node.\nThis <code>RBTree</code> does not have a node with this key.\nA view into a vacant entry in a <code>RBTree</code>. It is part of the …\nThe current node\nThe current node, with a mutable value\nReturns a cursor over the tree nodes, starting with the …\nReturns a cursor over the tree nodes, starting with the …\nReturns a cursor over the tree nodes based on the given …\nGets the given key’s corresponding entry in the map for …\nUsed for accessing the given node, if it exists.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns a reference to the value corresponding to the key.\nGets a reference to the value in the entry.\nReturns a mutable reference to the value corresponding to …\nGets a mutable reference to the value in the entry.\nInserts a new node into the tree.\nInserts the given node into the <code>RBTree</code> at this entry.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConverts the entry into a mutable reference to its value.\nInitialises a node reservation.\nDrop the key and value, but keep the allocation.\nReturns an iterator over the tree nodes, sorted by key.\nReturns a mutable iterator over the tree nodes, sorted by …\nReturns an iterator over the keys of the nodes in the …\nMove the cursor to the next node, returning <code>None</code> if it …\nMove the cursor to the previous node, returning <code>None</code> if it …\nCreates a new and empty tree.\nAllocates memory for a node to be eventually initialised …\nAllocates and initialises a node that can be inserted into …\nAccess the previous node without moving the cursor.\nAccess the next node mutably without moving the cursor.\nAccess the previous node without moving the cursor.\nAccess the previous node mutably without moving the cursor.\nRemoves the node with the given key from the tree.\nTakes the value of the entry out of the map, and returns …\nRemove the current node from the tree.\nRemove the next node, returning it if it exists.\nRemoves the node with the given key from the tree.\nRemove this entry from the <code>RBTree</code>.\nRemove the previous node, returning it if it exists.\nGet the key and value from inside the node.\nTries to insert a new value into the tree.\nReturns an iterator over the values of the nodes in the …\nReturns a mutable iterator over the values of the nodes in …\nAn object that can become inaccessible at runtime.\nA guard that allows access to a revocable object and keeps …\nDirectly access the revocable wrapped object.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates a new revocable instance of the given data.\nRevokes access to and drops the wrapped object.\nRevokes access to and drops the wrapped object.\nTries to access the revocable wrapped object.\nTries to access the wrapped object and run a closure on it …\nTries to access the revocable wrapped object.\nA security context string.\nReturns the bytes for this security context.\nReturns the argument unchanged.\nGet the security context given its id.\nCalls <code>U::from(self)</code>.\nReturns whether the security context is empty.\nReturns the length of this security context.\nA utility for generating the contents of a seq file.\nUsed by the <code>seq_print</code> macro.\nReturns the argument unchanged.\nCreates a new <code>SeqFile</code> from a raw pointer.\nCalls <code>U::from(self)</code>.\nWrite to a <code>SeqFile</code> with the ordinary Rust formatting …\n0x00020000\n0x00004000\n0x00000400\n0x00040000\n0x00000800\n0x00008000\n0x00001000\n0x00080000\n0x00010000\n0x00002000\nByte string without UTF-8 validity guarantee.\nA string that is guaranteed to have exactly one <code>NUL</code> byte, …\nPossible errors when using conversion functions in <code>CStr</code>.\nAn owned string that is guaranteed to have exactly one <code>NUL</code> …\nSupplied bytes contain an interior <code>NUL</code>.\nSupplied bytes are not terminated by <code>NUL</code>.\nConvert the string to a byte slice without the trailing <code>NUL</code>…\nConvert the string to a byte slice containing the trailing …\nReturns a C pointer to the string.\nUnsafely convert this <code>CStr</code> into a <code>&amp;str</code>, without checking …\nFormats printable ASCII characters, escaping the rest.\nFormats printable ASCII characters with a double quote on …\nFormats printable ASCII characters with a double quote on …\nFormats printable ASCII characters, escaping the rest.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a <code>BStr</code> from a <code>[u8]</code>.\nCreates a <code>CStr</code> from a <code>[u8]</code>.\nCreates a <code>CStr</code> from a <code>[u8]</code> without performing any …\nCreates a mutable <code>CStr</code> from a <code>[u8]</code> without performing any …\nWraps a raw C string pointer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns <code>true</code> if the string is empty.\nReturns <code>true</code> if the string only includes <code>NUL</code>.\nReturns the length of this string.\nReturns the length of this string excluding <code>NUL</code>.\nReturns the length of this string with <code>NUL</code>.\nConverts this <code>CStr</code> to its ASCII lower case equivalent …\nConverts this <code>CStr</code> to its ASCII upper case equivalent …\nStrip a prefix from <code>self</code>. Delegates to <code>slice::strip_prefix</code>.\nReturns a copy of this <code>CString</code> where each character is …\nReturns a copy of this <code>CString</code> where each character is …\nConvert this <code>CStr</code> into a <code>CString</code> by allocating memory and …\nYields a <code>&amp;str</code> slice if the <code>CStr</code> contains valid UTF-8.\nCreates an instance of <code>CString</code> from the given formatted …\nA reference-counted pointer to an instance of <code>T</code>.\nA borrowed reference to an <code>Arc</code> instance.\nThe backend used for this global lock.\nA conditional variable.\nThe return type of <code>wait_timeout</code>.\nA guard for a <code>GlobalLock</code>.\nType used for global locks.\nTrait implemented for marker types for global locks.\nA version of <code>LockedBy</code> for a <code>GlobalLock</code>.\nItem type stored in this global lock.\nRepresents a lockdep class. It’s a wrapper around C’s …\nAllows access to some data to be serialised by a lock that …\nThe name for this global lock.\nA signal occurred.\nThe timeout was reached.\nA refcounted object that is known to have a refcount of 1.\nSomebody woke us up.\nReturns a reference to the protected data when the caller …\nReturns a mutable reference to the protected data when the …\nReturns an <code>ArcBorrow</code> from the given <code>Arc</code>.\nAccess the value mutably.\nReturn a raw pointer to the data in this arc.\nAccess the value immutably.\nUnsafely assume that <code>self</code> is initialized.\nCompletion support.\nAttempt to downcast the <code>Arc&lt;dyn Any + Send + Sync&gt;</code> to a …\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nRecreates an <code>Arc</code> instance previously deconstructed via …\nCreates an <code>ArcBorrow</code> to an <code>Arc</code> that has previously been …\nThe class for this global lock.\nAccess the value mutably directly.\nDefines a global lock.\nInitializes a global lock.\nInitialize <code>self</code> using the given initializer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConvert the <code>Arc</code> into a raw pointer.\nConverts this <code>Arc</code> into a <code>UniqueArc</code>, or destroys it if it …\nGeneric kernel lock and guard.\nLock this global lock.\nTries to allocate a new <code>UniqueArc</code> instance.\nCreates a global lock.\nCreate a new <code>GlobalLockedBy</code>.\nConstructs a new instance of <code>LockedBy</code>.\nConstructs a new reference counted instance of <code>T</code>.\nConstructs a new condvar initialiser.\nCreates a <code>CondVar</code> initialiser with the given name and a …\nInitializes a dynamically allocated lock class key. In the …\nTries to allocate a new <code>UniqueArc</code> instance whose contents …\nWakes all waiters up, if any.\nWakes a single waiter up, if any.\nCalls the kernel function to notify one thread …\nPin-initialize <code>self</code> using the given pin-initializer.\nUtilities for working with <code>struct poll_table</code>.\nCompare whether two <code>Arc</code> pointers reference the same …\nRCU support.\nTry to lock this global lock.\nReleases the lock and waits for a notification in …\nReleases the lock and waits for a notification in …\nReleases the lock and waits for a notification in …\nReleases the lock and waits for a notification in …\nConverts a <code>UniqueArc&lt;MaybeUninit&lt;T&gt;&gt;</code> into a <code>UniqueArc&lt;T&gt;</code> …\nRemaining sleep duration.\nRemaining sleep duration.\nSynchronization primitive to signal when a certain task …\nSignal all tasks waiting on this completion.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreate an initializer for a new <code>Completion</code>.\nWait for completion of a task.\nThe “backend” of a lock.\nThe backend used for this global lock.\nA guard for a <code>GlobalLock</code>.\nType used for global locks.\nTrait implemented for marker types for global locks.\nA version of <code>LockedBy</code> for a <code>GlobalLock</code>.\nA lock guard.\nThe state required to be kept between <code>lock</code> and <code>unlock</code>.\nItem type stored in this global lock.\nA mutual exclusion primitive.\nThe name for this global lock.\nThe state required by the lock.\nAsserts that the lock is held using lockdep.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConstructs a <code>Lock</code> from a raw pointer.\nThe class for this global lock.\nInitialises the lock.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nAcquires the lock, making the caller its owner.\nAcquires the lock and gives the caller access to the data …\nReturns the lock that this guard originates from.\nA kernel mutex.\nConstructs a new immutable lock guard.\nConstructs a new lock initialiser.\nReacquires the lock, making the caller its owner.\nA kernel spinlock.\nTries to acquire the lock.\nTries to acquire the lock.\nReleases the lock, giving up its ownership.\nA mutual exclusion primitive.\nA kernel <code>struct mutex</code> lock backend.\nA <code>Guard</code> acquired from locking a <code>Mutex</code>.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreates a <code>Mutex</code> initialiser with the given name and a …\nA spinlock.\nA kernel <code>spinlock_t</code> lock backend.\nA <code>Guard</code> acquired from locking a <code>SpinLock</code>.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreates a <code>SpinLock</code> initialiser with the given name and a …\nA wrapper around <code>CondVar</code> that makes it usable with …\nWraps the kernel’s <code>struct poll_table</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a reference to a <code>PollTable</code> from a valid pointer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConstructs a new condvar initialiser.\nRegister this <code>PollTable</code> with the provided <code>PollCondVar</code>, so …\nEvidence that the RCU read side lock is held on the …\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nAcquires the RCU read side lock and returns a guard.\nAcquires the RCU read side lock.\nExplicitly releases the RCU read side lock.\nRepresents the <code>Task</code> in the <code>current</code> global.\nThe type of user identifiers (UIDs).\nA sentinel value used for infinite timeouts.\nThe type of process identifiers (PIDs).\nBitmask for tasks that are sleeping in a freezable state.\nBitmask for tasks that are sleeping in an interruptible …\nConvenience constant for waking up tasks regardless of …\nBitmask for tasks that are sleeping in an uninterruptible …\nWraps the kernel’s <code>struct task_struct</code>.\nAccess the pid namespace of the current task.\nReturns a raw pointer to the task.\nReturns a task reference for the currently executing …\nGet the current euid.\nReturns a raw pointer to the current task.\nReturns the effective UID of the given task.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreate a <code>Kuid</code> given the raw C type.\nReturns task’s pid namespace with elevated reference …\nReturns the group leader of the given task.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nTurn this kuid into the raw C type.\nConverts this kernel UID into a userspace UID.\nAccess the address space of the current task.\nReturns the PID of the given task.\nDetermines whether the given task has pending signals.\nReturns the given task’s pid in the provided pid …\nReturns the UID of the given task.\nWakes up the task.\nA monotonic that ticks while system is suspended.\nAn identifier for a clock. Used when specifying clock …\nA span of time.\nA specific point in time.\nThe time unit of Linux kernel. One jiffy equals (1/HZ) …\nA monotonically increasing clock.\nThe millisecond time unit.\nThe number of nanoseconds per millisecond.\nThe number of nanoseconds per second.\nThe number of nanoseconds per microsecond.\nA settable system-wide clock that measures real (i.e., …\nInternational Atomic Time.\nA span of time equal to zero.\nReturn the smallest number of microseconds greater than or …\nReturn the number of milliseconds in the <code>Delta</code>.\nReturn the number of nanoseconds in the <code>Delta</code>.\nReturn the amount of time elapsed since the <code>Instant</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreate a new <code>Delta</code> from a number of microseconds.\nCreate a new <code>Delta</code> from a number of milliseconds.\nCreate a new <code>Delta</code> from a number of seconds.\nIntrusive high resolution timers.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturn <code>true</code> if the <code>Delta</code> spans a negative amount of time.\nReturn <code>true</code> if the <code>Delta</code> spans no time.\nConverts milliseconds to jiffies.\nGet the current time using <code>CLOCK_MONOTONIC</code>.\nTimer expires at the given expiration time.\nTimer expires at the given expiration time. Timer handler …\nTimer expires at the given expiration time. Timer does not …\nTimer expires at the given expiration time. Timer does not …\nTimer expires at the given expiration time. Timer does not …\nTimer expires at the given expiration time. Timer handler …\nA handle for an <code>Arc&lt;HasHrTimer&lt;T&gt;&gt;</code> returned by a call to …\nA handle for a <code>Box&lt;HasHrTimer&lt;T&gt;&gt;</code> returned by a call to …\nType of the parameter passed to <code>HrTimerCallback::run</code>. It …\nTimer handler is executed in hard irq context.\nImplemented by structs that contain timer nodes.\nA timer backed by a C <code>struct hrtimer</code>.\nImplemented by structs that can be the target of a timer …\nA handle representing a potentially running timer.\nOperational mode of <code>HrTimer</code>.\nImplemented by pointer types that point to structs that …\nRestart policy for timers.\nA Rust wrapper around a <code>ktime_t</code>.\nTimer should not be restarted.\nA handle for a <code>Pin&lt;&amp;HasHrTimer&gt;</code>. When the handle exists, …\nA handle for a <code>Pin&lt;&amp;mut HasHrTimer&gt;</code>. When the handle …\nTimer does not move between CPU cores.\nThe type whose <code>RawHrTimerCallback::run</code> method will be …\nImplemented by <code>HrTimerPointer</code> implementers to give the C …\nTimer expires after the given expiration time interpreted …\nTimer expires after the given expiration time interpreted …\nTimer expires after the given expiration time interpreted …\nTimer expires after the given expiration time interpreted …\nTimer expires after the given expiration time interpreted …\nTimer expires after the given expiration time interpreted …\nTimer should be restarted.\nA trait for stack allocated timers.\nTimer handler is executed in soft irq context.\nA handle representing a started or restarted timer.\nA handle representing a running timer.\nUnsafe version of <code>HrTimerPointer</code> for situations where …\nGet pointer to the contained <code>bindings::hrtimer</code> struct.\nCancel the timer. If the timer is in the running state, …\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturn an initializer for a new timer instance.\nReturn a pointer to the <code>HrTimer</code> within <code>Self</code>.\nCallback to be called from C when timer fires.\nCalled by the timer logic when the timer fires.\nStart the timer with expiry after <code>expires</code> time units. If …\nStart the timer after <code>expires</code> time units. If the timer was …\nStart the timer contained in the <code>Self</code> pointed to by …\nStart the timer to run after <code>expires</code> time units and …\nReturn a pointer to the struct that is containing the …\nReturns the number of nanoseconds.\nDeclare the Rust entry point for a tracepoint.\nTypes that can be viewed as an immutable slice of …\nTypes for which any bit pattern is valid.\nAn owned reference to an always-reference-counted object.\nTypes that are <em>always</em> reference counted.\nType used to immutably borrow a value that is currently …\nType used to mutably borrow a value that is currently …\nA sum type that always holds either a value of type <code>L</code> or <code>R</code>.\nUsed to transfer ownership to and from foreign (non-Rust) …\nConstructs an instance of <code>Either</code> containing a value of …\nZero-sized type to mark types not <code>Send</code>.\nUsed to construct instances of type <code>NotThreadSafe</code> similar …\nStores an opaque value.\nType used when the value is foreign-owned. In practical …\nConstructs an instance of <code>Either</code> containing a value of …\nRuns a cleanup function/closure when dropped.\nBorrows a foreign-owned object immutably.\nBorrows a foreign-owned object mutably.\nDecrements the reference count on the object.\nPrevents the cleanup function from running and returns the …\nCreates a pin-initializer from the given initializer …\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConverts a foreign-owned object back to a Rust-owned one.\nCreates a new instance of <code>ARef</code>.\nReturns a raw pointer to the opaque data.\nIncrements the reference count on the object.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConverts a Rust-owned object to a foreign-owned one.\nConsumes the <code>ARef</code>, returning a raw pointer.\nCreates a new guarded object with the given cleanup …\nCreates a new opaque value.\nCreates a new guarded object wrapping the given data and …\nCreate an opaque pin-initializer from the given …\nGets the value behind <code>this</code>.\nCreates a fallible pin-initializer from the given …\nTries to convert a foreign-owned object back to a …\nCreates an uninitialised value.\nCreates a new zeroed opaque value.\nThe type used for userspace addresses.\nA pointer to an area in userspace memory, which can be …\nA reader for <code>UserSlice</code>.\nA writer for <code>UserSlice</code>.\nCreate a reader that can access the same range of data.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns <code>true</code> if no data is available in the io buffer.\nReturns <code>true</code> if no more data can be written to this buffer.\nReturns the number of bytes left to be read from this …\nReturns the amount of space remaining in this buffer.\nConstructs a user slice from a raw pointer and a length in …\nReads a value of the specified type.\nReads the entirety of the user slice, appending it to the …\nReads the entirety of the user slice, appending it to the …\nReads raw data from the user slice into a kernel buffer.\nReads raw data from the user slice into a kernel buffer.\nConstructs a <code>UserSliceReader</code>.\nConstructs both a <code>UserSliceReader</code> and a <code>UserSliceWriter</code>.\nSkip the provided number of bytes.\nWrites the provided Rust value to this userspace pointer.\nWrites raw data to this user pointer from a kernel buffer.\nConstructs a <code>UserSliceWriter</code>.\nThe return type of <code>Queue::enqueue</code>.\nDeclares that a type has a <code>Work&lt;T, ID&gt;</code> field.\nThe pointer type that this struct is wrapped in. This will …\nA kernel work queue.\nA raw work item.\nLinks for a work item.\nDefines the method that should be called when this work …\nDefines the method that should be called directly when a …\nEnqueues this work item on a queue using the provided …\nEnqueues a work item.\nReturns the argument unchanged.\nReturns the argument unchanged.\nUse the provided <code>struct workqueue_struct</code> with Rust.\nUsed to safely implement the <code>HasWork&lt;T, ID&gt;</code> trait.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates a new instance of <code>Work</code>.\nCreates a <code>Work</code> initialiser with the given name and a …\nGet a pointer to the inner <code>work_struct</code>.\nReturns a pointer to the <code>Work&lt;T, ID&gt;</code> field.\nRun this work item.\nThe method that should be called when this work item is …\nReturns the system work queue (<code>system_wq</code>).\nReturns the system bottom halves work queue (<code>system_bh_wq</code>).\nReturns the system bottom halves high-priority work queue (…\nReturns the system freezable work queue (…\nReturns the system freezable power-efficient work queue (…\nReturns the system high-priority work queue (…\nReturns the system work queue for potentially long-running …\nReturns the system power-efficient work queue (…\nReturns the system unbound work queue (<code>system_unbound_wq</code>).\nTries to spawn the given function or closure as a work …\nReturns a pointer to the struct containing the <code>Work&lt;T, ID&gt;</code> …\nConsider the first element to be at index 0.\nConsider the first element to be at index 1.\nFlags passed to <code>XArray::new</code> to configure the array’s …\nA lock guard.\nThe error returned by <code>store</code>.\nAn array which efficiently maps sparse integer indices to …\nThe error that occurred.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nProvides a reference to the element at the given index.\nProvides a mutable reference to the element at the given …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nLocks the <code>XArray</code> for exclusive access.\nCreates a new initializer for this type.\nRemoves and returns the element at the given index.\nStores an element at the given index.\nAttempts to lock the <code>XArray</code> for exclusive access.\nThe value that was not stored.")