/* auto-generated by NAPI-RS */
/* eslint-disable */
/**
 * 剪贴板监听器实例，用于监听剪贴板变化并支持停止
 * 支持自动检测环境：在 Wayland 环境下使用 Wayland 专用监听器，否则使用通用监听器
 * 使用方法：
 * ```javascript
 * const { ClipboardListener } = require('./index.node');
 * const listener = new ClipboardListener();
 * listener.watch((data) => {
 *   console.log('剪贴板数据变化:', data);
 *   console.log('可用格式:', data.available_formats);
 *   if (data.text) console.log('文本:', data.text);
 *   if (data.html) console.log('HTML:', data.html);
 *   if (data.rtf) console.log('RTF:', data.rtf);
 *   if (data.image) console.log('图片 (base64):', data.image.substring(0, 50) + '...');
 *   if (data.files) console.log('文件:', data.files);
 *   if (data.other) console.log('其他格式:', data.other);
 * });
 * // 停止监听
 * listener.stop();
 * ```
 */
export declare class ClipboardListener {
  /**
   * 创建新的剪贴板监听器实例
   * 自动检测当前环境类型（Wayland 或其他）
   */
  constructor()
  /**
   * 开始监听剪贴板变化
   * callback: 当剪贴板变化时调用的回调函数，参数为包含所有格式数据的复杂对象
   * 自动根据当前环境选择合适的监听方式（Wayland 或通用）
   */
  watch(callback: (arg: ClipboardData) => void): void
  /** 停止监听剪贴板变化 */
  stop(): void
  /** 检查是否正在监听 */
  isWatching(): boolean
  /** 获取当前使用的监听器类型 */
  getListenerType(): string
}

/** 剪贴板管理器，提供跨平台的剪贴板操作功能 */
export declare class ClipboardManager {
  /** 创建新的剪贴板管理器实例 */
  constructor()
  /** 获取剪贴板中的纯文本内容 */
  getText(): string
  /** 设置剪贴板中的纯文本内容 */
  setText(text: string): void
  /** 获取剪贴板中的 HTML 内容 */
  getHtml(): string
  /** 设置剪贴板中的 HTML 内容 */
  setHtml(html: string): void
  /** 获取剪贴板中的富文本内容 */
  getRichText(): string
  /** 设置剪贴板中的富文本内容 */
  setRichText(text: string): void
  /** 获取剪贴板中的图片数据（以 base64 编码返回） */
  getImageBase64(): string
  /** 获取剪贴板中的图片详细信息（包含宽度、高度、大小和原始数据） */
  getImageData(): ImageData
  /** 从 base64 编码的图片数据设置剪贴板图片 */
  setImageBase64(base64Data: string): void
  /** 从原始字节数据设置剪贴板图片 */
  setImageRaw(imageData: Buffer): void
  /** 获取剪贴板中的图片原始数据（Buffer） */
  getImageRaw(): Buffer
  /** 获取剪贴板中的文件列表 */
  getFiles(): Array<string>
  /** 设置剪贴板中的文件列表 */
  setFiles(files: Array<string>): void
  /** 设置剪贴板中的自定义格式数据 */
  setBuffer(format: string, buffer: Buffer): void
  /** 获取剪贴板中的自定义格式数据 */
  getBuffer(format: string): Buffer
  /** 设置剪贴板中的复合内容（可同时设置多种格式） */
  setContents(contents: ClipboardData): void
  /** 检查剪贴板是否包含指定格式的内容 */
  hasFormat(format: string): boolean
  /** 获取剪贴板中所有可用的格式 */
  getAvailableFormats(): Array<string>
  /** 清空剪贴板 */
  clear(): void
  /** 异步获取剪贴板文本内容 */
  getTextAsync(): Promise<string>
  /** 异步设置剪贴板文本内容 */
  setTextAsync(text: string): Promise<void>
  /** 异步获取剪贴板图片数据（以 base64 编码返回） */
  getImageBase64Async(): Promise<string>
  /** 异步获取剪贴板图片详细信息（包含宽度、高度、大小和原始数据） */
  getImageDataAsync(): Promise<ImageData>
}

/** 快速清空剪贴板 */
export declare function clearClipboard(): void

/** 剪贴板数据结构，包含所有可用格式的数据 */
export interface ClipboardData {
  /** 可用的格式列表 */
  availableFormats: Array<string>
  /** 纯文本内容 */
  text?: string
  /** RTF 富文本内容 */
  rtf?: string
  /** HTML 内容 */
  html?: string
  /** 图片数据 */
  image?: ImageData
  /** 文件列表 */
  files?: Array<string>
}

/** 快速获取剪贴板自定义格式数据 */
export declare function getClipboardBuffer(format: string): Buffer

/** 快速获取剪贴板文件列表 */
export declare function getClipboardFiles(): Array<string>

/** 快速获取剪贴板 HTML 内容 */
export declare function getClipboardHtml(): string

/** 快速获取剪贴板图片（base64 编码） */
export declare function getClipboardImage(): string

/** 快速获取剪贴板图片详细信息（包含宽度、高度、大小和原始数据） */
export declare function getClipboardImageData(): ImageData

/** 快速获取剪贴板图片原始数据（Buffer） */
export declare function getClipboardImageRaw(): Buffer

/** 快速获取剪贴板文本内容 */
export declare function getClipboardText(): string

/** 快速获取完整的剪贴板数据 */
export declare function getFullClipboardData(): ClipboardData

/** 图片数据结构，包含图片的详细信息 */
export interface ImageData {
  /** 图片宽度（像素） */
  width: number
  /** 图片高度（像素） */
  height: number
  /** 图片数据大小（字节） */
  size: number
  /** 图片原始数据（Buffer） */
  data: Buffer
}

/**
 * 检测 Wayland 剪贴板监听是否可用
 *
 * 返回 true 表示当前环境支持 Wayland 剪贴板监听
 */
export declare function isWaylandClipboardAvailable(): boolean

/** 快速设置剪贴板自定义格式数据 */
export declare function setClipboardBuffer(format: string, buffer: Buffer): void

/** 快速设置剪贴板复合内容（可同时设置多种格式） */
export declare function setClipboardContents(contents: ClipboardData): void

/** 快速设置剪贴板文件列表 */
export declare function setClipboardFiles(files: Array<string>): void

/** 快速设置剪贴板 HTML 内容 */
export declare function setClipboardHtml(html: string): void

/** 快速设置剪贴板图片（从 base64 编码） */
export declare function setClipboardImage(base64Data: string): void

/** 快速设置剪贴板图片（从原始字节数据） */
export declare function setClipboardImageRaw(imageData: Buffer): void

/** 快速设置剪贴板文本内容 */
export declare function setClipboardText(text: string): void
