/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.phonetic;

import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.DoubleMetaphoneFilter;

public class DoubleMetaphoneFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "doubleMetaphone";
    public static final String INJECT = "inject";
    public static final String MAX_CODE_LENGTH = "maxCodeLength";
    public static final int DEFAULT_MAX_CODE_LENGTH = 4;
    private final boolean inject;
    private final int maxCodeLength;

    public DoubleMetaphoneFilterFactory(Map<String, String> args) {
        super(args);
        this.inject = this.getBoolean(args, INJECT, true);
        this.maxCodeLength = this.getInt(args, MAX_CODE_LENGTH, 4);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public DoubleMetaphoneFilterFactory() {
        throw DoubleMetaphoneFilterFactory.defaultCtorException();
    }

    public DoubleMetaphoneFilter create(TokenStream input) {
        return new DoubleMetaphoneFilter(input, this.maxCodeLength, this.inject);
    }
}

