/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ModelCache {
    private LRU models;
    private String defaultZkHost;
    private SolrClientCache solrClientCache;

    public ModelCache(int size, String defaultZkHost, SolrClientCache solrClientCache) {
        this.models = new LRU(size);
        this.defaultZkHost = defaultZkHost;
        this.solrClientCache = solrClientCache;
    }

    public Tuple getModel(String collection, String modelID, long checkMillis) throws IOException {
        return this.getModel(this.defaultZkHost, collection, modelID, checkMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple getModel(String zkHost, String collection, String modelID, long checkMillis) throws IOException {
        Model model = null;
        long currentTime = new Date().getTime();
        ModelCache modelCache = this;
        synchronized (modelCache) {
            model = (Model)this.models.get(modelID);
            if (model != null && currentTime - model.getLastChecked() <= checkMillis) {
                return model.getTuple();
            }
            if (model != null) {
                this.models.remove(modelID);
            }
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{"name_s:" + modelID});
        params.set("fl", new String[]{"terms_ss, idfs_ds, weights_ds, iteration_i, _version_"});
        params.set("sort", new String[]{"iteration_i desc"});
        StreamContext streamContext = new StreamContext();
        streamContext.setSolrClientCache(this.solrClientCache);
        CloudSolrStream stream = new CloudSolrStream(zkHost, collection, (SolrParams)params);
        stream.setStreamContext(streamContext);
        Tuple tuple = null;
        try {
            stream.open();
            tuple = stream.read();
            if (tuple.EOF) {
                Tuple tuple2 = null;
                return tuple2;
            }
        }
        finally {
            stream.close();
        }
        ModelCache modelCache2 = this;
        synchronized (modelCache2) {
            Model m = (Model)this.models.get(modelID);
            if (m != null) {
                Tuple t = m.getTuple();
                long v = t.getLong("_version_");
                if (v >= tuple.getLong("_version_")) {
                    return t;
                }
                this.models.put(modelID, new Model(tuple, currentTime));
                return tuple;
            }
            this.models.put(modelID, new Model(tuple, currentTime));
            return tuple;
        }
    }

    private static class LRU
    extends LinkedHashMap<String, Model> {
        private int maxSize;

        public LRU(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<String, Model> eldest) {
            return this.size() > this.maxSize;
        }
    }

    private static class Model {
        private Tuple tuple;
        private long lastChecked;

        public Model(Tuple tuple, long lastChecked) {
            this.tuple = tuple;
            this.lastChecked = lastChecked;
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public long getLastChecked() {
            return this.lastChecked;
        }
    }
}

