/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.llm.textvectorisation.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.llm.textvectorisation.model.SolrTextToVectorModel;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextToVectorUpdateProcessor
extends UpdateRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IndexSchema schema;
    private final String inputField;
    private final String outputField;
    private SolrTextToVectorModel textToVector;

    public TextToVectorUpdateProcessor(String inputField, String outputField, SolrTextToVectorModel textToVector, SolrQueryRequest req, UpdateRequestProcessor next) {
        super(next);
        this.schema = req.getSchema();
        this.inputField = inputField;
        this.outputField = outputField;
        this.textToVector = textToVector;
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        block4: {
            SolrInputDocument doc = cmd.getSolrInputDocument();
            SolrInputField inputFieldContent = doc.get((Object)this.inputField);
            if (!this.isNullOrEmpty(inputFieldContent)) {
                try {
                    String textToVectorise = inputFieldContent.getValue().toString();
                    float[] vector = this.textToVector.vectorise(textToVectorise);
                    ArrayList<Float> vectorAsList = new ArrayList<Float>(vector.length);
                    for (float f : vector) {
                        vectorAsList.add(Float.valueOf(f));
                    }
                    doc.addField(this.outputField, vectorAsList);
                }
                catch (RuntimeException vectorisationFailure) {
                    if (!log.isErrorEnabled()) break block4;
                    SchemaField uniqueKeyField = this.schema.getUniqueKeyField();
                    String uniqueKeyFieldName = uniqueKeyField.getName();
                    log.error("Could not vectorise: {} for the document with {}: {}", new Object[]{this.inputField, uniqueKeyFieldName, doc.getFieldValue(uniqueKeyFieldName), vectorisationFailure});
                }
            }
        }
        super.processAdd(cmd);
    }

    protected boolean isNullOrEmpty(SolrInputField inputFieldContent) {
        return inputFieldContent == null || inputFieldContent.getValue() == null || inputFieldContent.getValue().toString().isEmpty();
    }
}

