/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.solr.spelling.SpellCheckCorrection;
import org.apache.solr.spelling.Token;

public class PossibilityIterator
implements Iterator<RankedSpellPossibility> {
    private List<List<SpellCheckCorrection>> possibilityList = new ArrayList<List<SpellCheckCorrection>>();
    private Iterator<RankedSpellPossibility> rankedPossibilityIterator = null;
    private int[] correctionIndex;
    private boolean done = false;
    private Iterator<List<SpellCheckCorrection>> nextOnes = null;
    private int nextOnesRank = 0;
    private int nextOnesIndex = 0;
    private boolean suggestionsMayOverlap = false;

    private PossibilityIterator() {
        throw new AssertionError((Object)"You shan't go here.");
    }

    public PossibilityIterator(Map<Token, LinkedHashMap<String, Integer>> suggestions, int maximumRequiredSuggestions, int maxEvaluations, boolean overlap) {
        this.suggestionsMayOverlap = overlap;
        for (Map.Entry<Token, LinkedHashMap<String, Integer>> entry : suggestions.entrySet()) {
            Token token = entry.getKey();
            if (entry.getValue().size() == 0) continue;
            ArrayList<SpellCheckCorrection> possibleCorrections = new ArrayList<SpellCheckCorrection>();
            for (Map.Entry<String, Integer> entry1 : entry.getValue().entrySet()) {
                SpellCheckCorrection correction = new SpellCheckCorrection();
                correction.setOriginal(token);
                correction.setCorrection(entry1.getKey());
                correction.setNumberOfOccurences(entry1.getValue());
                possibleCorrections.add(correction);
            }
            this.possibilityList.add(possibleCorrections);
        }
        int wrapSize = this.possibilityList.size();
        if (wrapSize == 0) {
            this.done = true;
        } else {
            this.correctionIndex = new int[wrapSize];
            for (int i = 0; i < wrapSize; ++i) {
                int suggestSize = this.possibilityList.get(i).size();
                if (suggestSize == 0) {
                    this.done = true;
                    break;
                }
                this.correctionIndex[i] = 0;
            }
        }
        PriorityQueue<RankedSpellPossibility> rankedPossibilities = new PriorityQueue<RankedSpellPossibility>(11, new RankComparator());
        HashSet<RankedSpellPossibility> removeDuplicates = null;
        if (this.suggestionsMayOverlap) {
            removeDuplicates = new HashSet<RankedSpellPossibility>();
        }
        long numEvaluations = 0L;
        while (numEvaluations < (long)maxEvaluations && this.internalHasNext()) {
            RankedSpellPossibility rsp = this.internalNext();
            ++numEvaluations;
            if (rankedPossibilities.size() >= maximumRequiredSuggestions && rsp.rank >= rankedPossibilities.peek().rank || !this.isSuggestionForReal(rsp)) continue;
            if (removeDuplicates == null) {
                rankedPossibilities.offer(rsp);
            } else {
                rsp.corrections.sort(new StartOffsetComparator());
                if (removeDuplicates.add(rsp)) {
                    rankedPossibilities.offer(rsp);
                }
            }
            if (rankedPossibilities.size() <= maximumRequiredSuggestions) continue;
            RankedSpellPossibility removed = rankedPossibilities.poll();
            if (removeDuplicates == null) continue;
            removeDuplicates.remove(removed);
        }
        RankedSpellPossibility[] rpArr = new RankedSpellPossibility[rankedPossibilities.size()];
        for (int i = rankedPossibilities.size() - 1; i >= 0; --i) {
            rpArr[i] = (RankedSpellPossibility)rankedPossibilities.remove();
        }
        this.rankedPossibilityIterator = Arrays.asList(rpArr).iterator();
    }

    private boolean isSuggestionForReal(RankedSpellPossibility rsp) {
        for (SpellCheckCorrection corr : rsp.corrections) {
            if (corr.getOriginalAsString().equals(corr.getCorrection())) continue;
            return true;
        }
        return false;
    }

    private boolean internalHasNext() {
        if (this.nextOnes != null && this.nextOnes.hasNext()) {
            return true;
        }
        if (this.done) {
            return false;
        }
        this.internalNextAdvance();
        return this.nextOnes != null && this.nextOnes.hasNext();
    }

    private RankedSpellPossibility internalNext() {
        if (this.nextOnes != null && this.nextOnes.hasNext()) {
            RankedSpellPossibility rsl = new RankedSpellPossibility();
            rsl.corrections = this.nextOnes.next();
            rsl.rank = this.nextOnesRank;
            rsl.index = this.nextOnesIndex++;
            return rsl;
        }
        if (this.done) {
            throw new NoSuchElementException();
        }
        this.internalNextAdvance();
        if (this.nextOnes != null && this.nextOnes.hasNext()) {
            RankedSpellPossibility rsl = new RankedSpellPossibility();
            rsl.corrections = this.nextOnes.next();
            rsl.rank = this.nextOnesRank;
            rsl.index = this.nextOnesIndex++;
            return rsl;
        }
        throw new NoSuchElementException();
    }

    private void internalNextAdvance() {
        ArrayList<SpellCheckCorrection> possibleCorrection = null;
        if (this.nextOnes != null && this.nextOnes.hasNext()) {
            possibleCorrection = this.nextOnes.next();
        } else {
            if (this.done) {
                throw new NoSuchElementException();
            }
            possibleCorrection = new ArrayList();
            List<List<SpellCheckCorrection>> possibleCorrections = null;
            int rank = 0;
            while (!(this.done || possibleCorrections != null && possibleCorrections.size() != 0)) {
                rank = 0;
                for (int i = 0; i < this.correctionIndex.length; ++i) {
                    List<SpellCheckCorrection> singleWordPossibilities = this.possibilityList.get(i);
                    SpellCheckCorrection singleWordPossibility = singleWordPossibilities.get(this.correctionIndex[i]);
                    rank += this.correctionIndex[i];
                    if (i == this.correctionIndex.length - 1) {
                        int n = i;
                        this.correctionIndex[n] = this.correctionIndex[n] + 1;
                        if (this.correctionIndex[i] == singleWordPossibilities.size()) {
                            this.correctionIndex[i] = 0;
                            if (this.correctionIndex.length == 1) {
                                this.done = true;
                            }
                            for (int ii = i - 1; ii >= 0; --ii) {
                                int n2 = ii;
                                this.correctionIndex[n2] = this.correctionIndex[n2] + 1;
                                if (this.correctionIndex[ii] < this.possibilityList.get(ii).size() || ii <= 0) break;
                                this.correctionIndex[ii] = 0;
                            }
                        }
                    }
                    possibleCorrection.add(singleWordPossibility);
                }
                if (this.correctionIndex[0] == this.possibilityList.get(0).size()) {
                    this.done = true;
                }
                if (this.suggestionsMayOverlap) {
                    possibleCorrections = this.separateOverlappingTokens(possibleCorrection);
                    continue;
                }
                possibleCorrections = new ArrayList<List<SpellCheckCorrection>>(1);
                possibleCorrections.add(possibleCorrection);
            }
            this.nextOnes = possibleCorrections.iterator();
            this.nextOnesRank = rank;
            this.nextOnesIndex = 0;
        }
    }

    private List<List<SpellCheckCorrection>> separateOverlappingTokens(List<SpellCheckCorrection> possibleCorrection) {
        ArrayList<List<SpellCheckCorrection>> ret = null;
        if (possibleCorrection.size() == 1) {
            ret = new ArrayList(1);
            ret.add(possibleCorrection);
            return ret;
        }
        ret = new ArrayList<List<SpellCheckCorrection>>();
        for (int i = 0; i < possibleCorrection.size(); ++i) {
            List<SpellCheckCorrection> c = this.compatible(possibleCorrection, i);
            ret.add(c);
        }
        return ret;
    }

    private List<SpellCheckCorrection> compatible(List<SpellCheckCorrection> all, int pos) {
        SpellCheckCorrection disposable;
        int i;
        ArrayList<SpellCheckCorrection> priorPassCompatibles = null;
        ArrayList<SpellCheckCorrection> firstPassCompatibles = new ArrayList<SpellCheckCorrection>(all.size());
        SpellCheckCorrection sacred = all.get(pos);
        firstPassCompatibles.add(sacred);
        int index = pos;
        boolean gotOne = false;
        for (i = 0; i < all.size() - 1; ++i) {
            if (++index == all.size()) {
                index = 0;
            }
            if (this.conflicts(sacred, disposable = all.get(index))) continue;
            firstPassCompatibles.add(disposable);
            gotOne = true;
        }
        if (!gotOne) {
            return firstPassCompatibles;
        }
        priorPassCompatibles = firstPassCompatibles;
        pos = 1;
        while (pos != priorPassCompatibles.size() - 1) {
            ArrayList<SpellCheckCorrection> subsequentPassCompatibles = new ArrayList<SpellCheckCorrection>(priorPassCompatibles.size());
            sacred = null;
            for (int i2 = 0; i2 <= pos; ++i2) {
                sacred = (SpellCheckCorrection)priorPassCompatibles.get(i2);
                subsequentPassCompatibles.add(sacred);
            }
            index = pos;
            gotOne = false;
            for (i = 0; i < priorPassCompatibles.size() - 1 && ++index != priorPassCompatibles.size(); ++i) {
                disposable = (SpellCheckCorrection)priorPassCompatibles.get(index);
                if (this.conflicts(sacred, disposable)) continue;
                subsequentPassCompatibles.add(disposable);
                gotOne = true;
            }
            if (!gotOne || pos == priorPassCompatibles.size() - 1) {
                return subsequentPassCompatibles;
            }
            priorPassCompatibles = subsequentPassCompatibles;
            ++pos;
        }
        return priorPassCompatibles;
    }

    private boolean conflicts(SpellCheckCorrection c1, SpellCheckCorrection c2) {
        int s1 = c1.getOriginal().startOffset();
        int e1 = c1.getOriginal().endOffset();
        int s2 = c2.getOriginal().startOffset();
        int e2 = c2.getOriginal().endOffset();
        if (s2 >= s1 && s2 <= e1) {
            return true;
        }
        return s1 >= s2 && s1 <= e2;
    }

    @Override
    public boolean hasNext() {
        return this.rankedPossibilityIterator.hasNext();
    }

    @Override
    public RankedSpellPossibility next() {
        return this.rankedPossibilityIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class RankComparator
    implements Comparator<RankedSpellPossibility> {
        private RankComparator() {
        }

        @Override
        public int compare(RankedSpellPossibility r1, RankedSpellPossibility r2) {
            int retval = r2.rank - r1.rank;
            if (retval == 0) {
                retval = r2.index - r1.index;
            }
            return retval;
        }
    }

    private static class StartOffsetComparator
    implements Comparator<SpellCheckCorrection> {
        private StartOffsetComparator() {
        }

        @Override
        public int compare(SpellCheckCorrection o1, SpellCheckCorrection o2) {
            return o1.getOriginal().startOffset() - o2.getOriginal().startOffset();
        }
    }

    public static class RankedSpellPossibility {
        public List<SpellCheckCorrection> corrections;
        public int rank;
        public int index;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.corrections == null ? 0 : this.corrections.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RankedSpellPossibility)) {
                return false;
            }
            RankedSpellPossibility other = (RankedSpellPossibility)obj;
            return Objects.equals(this.corrections, other.corrections);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("rank=").append(this.rank).append(" (").append(this.index).append(")");
            if (this.corrections != null) {
                for (SpellCheckCorrection corr : this.corrections) {
                    sb.append("     ");
                    sb.append((CharSequence)((Object)corr.getOriginal())).append(">").append(corr.getCorrection()).append(" (").append(corr.getNumberOfOccurences()).append(")");
                }
            }
            return sb.toString();
        }
    }
}

