/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class CborLoader {
    final CBORFactory cborFactory;
    private final Consumer<SolrInputDocument> sink;

    public CborLoader(CBORFactory cborFactory, Consumer<SolrInputDocument> sink) {
        this.cborFactory = cborFactory == null ? CBORFactory.builder().enable(CBORGenerator.Feature.STRINGREF).build() : cborFactory;
        this.sink = sink;
    }

    public void stream(InputStream is) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new CBORFactory());
        try (CBORParser parser = (CBORParser)mapper.getFactory().createParser(is);){
            JsonToken t;
            while ((t = parser.nextToken()) != null) {
                if (t == JsonToken.START_ARRAY) {
                    t = parser.nextToken();
                    if (t != JsonToken.START_OBJECT) continue;
                    this.handleDoc(parser);
                    continue;
                }
                if (t != JsonToken.START_OBJECT) continue;
                this.handleDoc(parser);
            }
        }
    }

    private void handleDoc(CBORParser p) throws IOException {
        SolrInputDocument doc = new SolrInputDocument();
        while (true) {
            JsonToken t;
            if ((t = p.nextToken()) == JsonToken.END_OBJECT) {
                if (!doc.isEmpty()) {
                    this.sink.accept(doc);
                }
                return;
            }
            if (t != JsonToken.FIELD_NAME) continue;
            String name = p.getCurrentName();
            t = p.nextToken();
            if (t == JsonToken.START_ARRAY) {
                ArrayList<Object> l = new ArrayList<Object>();
                while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
                    l.add(this.readVal(t, p));
                }
                if (l.isEmpty()) continue;
                doc.addField(name, l);
                continue;
            }
            doc.addField(name, this.readVal(t, p));
        }
    }

    private Object readVal(JsonToken t, CBORParser p) throws IOException {
        if (t == JsonToken.VALUE_NULL) {
            return null;
        }
        if (t == JsonToken.VALUE_STRING) {
            return p.getValueAsString();
        }
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p.getNumberValue();
        }
        if (t == JsonToken.START_OBJECT) {
            Object[] returnVal = new Object[1];
            new CborLoader(this.cborFactory, d -> {
                returnVal[0] = d;
            }).handleDoc(p);
            return returnVal[0];
        }
        throw new RuntimeException("Unknown type :" + String.valueOf(t));
    }

    public static ContentStreamLoader createLoader(SolrParams p) {
        final CBORFactory factory = CBORFactory.builder().enable(CBORGenerator.Feature.STRINGREF).build();
        return new ContentStreamLoader(){

            @Override
            public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws IOException {
                int commitWithin = req.getParams().getInt("commitWithin", -1);
                boolean overwrite = req.getParams().getBool("overwrite", true);
                new CborLoader(factory, doc -> {
                    AddUpdateCommand add = new AddUpdateCommand(req);
                    add.commitWithin = commitWithin;
                    add.solrDoc = doc;
                    add.overwrite = overwrite;
                    try {
                        processor.processAdd(add);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).stream(stream.getStream());
            }
        }.init(p);
    }
}

