/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.FontPanel;
import org.freehep.graphicsio.exportchooser.OptionPanel;

public class EMFExportFileType
extends AbstractExportFileType {
    @Override
    public String getDescription() {
        return "Windows Enhanced Metafile";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"emf"};
    }

    @Override
    public String[] getMIMETypes() {
        return new String[]{"image/x-emf"};
    }

    @Override
    public boolean hasOptionPanel() {
        return true;
    }

    @Override
    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, EMFGraphics2D.getDefaultProperties());
        String rootKey = EMFGraphics2D.class.getName();
        String abstractRootKey = AbstractVectorGraphicsIO.class.getName();
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add("0 0 [5 5 5 5] wt", new BackgroundPanel(options, rootKey, true));
        optionsPanel.add("0 1 [5 5 5 5] wt", new FontPanel(options, null, abstractRootKey));
        optionsPanel.add("0 * wh", new JLabel());
        return optionsPanel;
    }

    @Override
    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new EMFGraphics2D(os, target);
    }

    @Override
    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return new EMFGraphics2D(os, dimension);
    }
}

