/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.SwingUtilities;
import net.sf.sdedit.diagram.AbstractPaintDevice;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.DiagramFactory;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.error.FatalError;
import net.sf.sdedit.ui.impl.DiagramTab;

public class DiagramRenderer
implements Runnable {
    private LinkedList<DiagramFactory> queue = new LinkedList();

    public DiagramRenderer() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("DiagramRenderer-Thread");
        thread.start();
    }

    private synchronized void enqueue(DiagramFactory factory) {
        ListIterator iter = this.queue.listIterator();
        while (iter.hasNext()) {
            DiagramFactory theFactory = (DiagramFactory)iter.next();
            if (theFactory.getProvider() != factory.getProvider()) continue;
            iter.remove();
            break;
        }
        this.queue.addFirst(factory);
        this.notify();
    }

    public void renderDiagram(DiagramTab tab) {
        AbstractPaintDevice ppd = tab.createPaintDevice(null);
        DiagramFactory factory = tab.createFactory(ppd);
        this.enqueue(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            DiagramFactory factory;
            DiagramError err = null;
            DiagramRenderer diagramRenderer = this;
            synchronized (diagramRenderer) {
                while (this.queue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                factory = this.queue.removeLast();
            }
            DiagramTab tab = (DiagramTab)factory.getProviderFactory();
            try {
                factory.generateDiagram(tab.getConfiguration().getDataObject());
            }
            catch (DiagramError e) {
                err = e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                err = new FatalError(factory.getProvider(), e);
            }
            this.doDisplay(tab, factory.getDiagram(), err);
        }
    }

    private void doDisplay(final DiagramTab tab, final Diagram diagram, final DiagramError err) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tab.displayDiagram(diagram, err);
            }
        });
    }
}

